/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.common.world.level.block;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.CandyTweak;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.common.BlockCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChestBlock.class})
public abstract class ChestBlockMixin {
    @Inject(method={"getRenderShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetRenderShape(BlockState state, CallbackInfoReturnable<RenderShape> callback) {
        if (NostalgicTweaks.isServer()) {
            return;
        }
        if (BlockCommonUtil.isOldChest(state.m_60734_())) {
            callback.setReturnValue((Object)RenderShape.MODEL);
        }
    }

    @Inject(method={"getShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void NT$onGetShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> callback) {
        TweakServerCache cache = TweakServerCache.get(CandyTweak.CHEST_VOXEL);
        VoxelShape shape = Shapes.m_83144_();
        if (NostalgicTweaks.isServer() && ModConfig.Candy.oldChestVoxel()) {
            callback.setReturnValue((Object)shape);
        } else if (NostalgicTweaks.isClient()) {
            boolean isServerVoxel;
            boolean bl = isServerVoxel = cache != null && (Boolean)cache.getServerCache() != false;
            if (NostalgicTweaks.isNetworkVerified() && NetUtil.isMultiplayer() && isServerVoxel) {
                callback.setReturnValue((Object)shape);
                return;
            }
            if (!ModConfig.Candy.oldChestVoxel()) {
                return;
            }
            if (!ModConfig.Candy.oldChest() && state.m_60734_().getClass().equals(ChestBlock.class)) {
                return;
            }
            if (!ModConfig.Candy.oldTrappedChest() && state.m_60734_().getClass().equals(TrappedChestBlock.class)) {
                return;
            }
            callback.setReturnValue((Object)shape);
        }
    }
}

