/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.common.world.level.block;

import mod.adrenix.nostalgic.common.config.ModConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireBlock.class})
public abstract class FireBlockMixin {
    @Shadow
    @Final
    public static IntegerProperty f_53408_;

    @Shadow
    protected abstract BlockState m_53437_(LevelAccessor var1, BlockPos var2, int var3);

    @Shadow
    protected abstract boolean m_53485_(BlockGetter var1, BlockPos var2);

    @Shadow
    protected abstract boolean m_53428_(Level var1, BlockPos var2);

    @Shadow
    protected abstract boolean m_7599_(BlockState var1);

    @Shadow
    protected abstract int m_221156_(LevelReader var1, BlockPos var2);

    @Shadow
    protected abstract int m_221164_(BlockState var1);

    @Unique
    private void NT$oldCheckBurnOut(Level level, BlockPos blockPos, int rand, RandomSource randomSource) {
        BlockState blockState = level.m_8055_(blockPos);
        int burnOdds = this.m_221164_(blockState);
        if (randomSource.m_188503_(rand) < burnOdds) {
            if (randomSource.m_188503_(2) == 0 && !level.m_46758_(blockPos)) {
                level.m_7731_(blockPos, this.m_53437_((LevelAccessor)level, blockPos, 0), 3);
            } else {
                level.m_7471_(blockPos, false);
            }
            if (blockState.m_60734_() instanceof TntBlock) {
                TntBlock.m_57433_((Level)level, (BlockPos)blockPos);
            }
        }
    }

    @Inject(method={"getFireTickDelay"}, at={@At(value="HEAD")}, cancellable=true)
    private static void NT$onGetFireTickDelay(RandomSource randomSource, CallbackInfoReturnable<Integer> callback) {
        if (ModConfig.Gameplay.oldFire()) {
            callback.setReturnValue((Object)10);
        }
    }

    @Inject(method={"tick"}, cancellable=true, at={@At(ordinal=0, value="INVOKE", target="Ljava/lang/Math;min(II)I")})
    private void NT$onTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo callback) {
        if (!ModConfig.Gameplay.oldFire()) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)f_53408_);
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        boolean isBlockForeverBurning = stateBelow.m_204336_(level.m_6042_().f_63836_());
        int newAge = Math.min(15, age + 1);
        if (age != newAge) {
            state = (BlockState)state.m_61124_((Property)f_53408_, (Comparable)Integer.valueOf(newAge));
            level.m_7731_(pos, state, 4);
        }
        if (!isBlockForeverBurning) {
            if (!this.m_53485_((BlockGetter)level, pos)) {
                BlockPos posBelow = pos.m_7495_();
                if (!level.m_8055_(posBelow).m_60783_((BlockGetter)level, posBelow, Direction.UP) || age > 3) {
                    level.m_7471_(pos, false);
                }
                callback.cancel();
                return;
            }
            if (age == 15 && random.m_188503_(4) == 0 && !this.m_7599_(level.m_8055_(pos.m_7495_()))) {
                level.m_7471_(pos, false);
                callback.cancel();
                return;
            }
        }
        if (age % 2 == 0 && age > 2) {
            this.NT$oldCheckBurnOut((Level)level, pos.m_122029_(), 300, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_122024_(), 300, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_7495_(), 250, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_7494_(), 250, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_122012_(), 300, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_122019_(), 300, random);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    for (int offsetY = -1; offsetY <= 4; ++offsetY) {
                        if (offsetX == 0 && offsetY == 0 && offsetZ == 0) continue;
                        int rand = 100;
                        if (offsetY > 1) {
                            rand += (offsetY - 1) * 100;
                        }
                        mutablePos.m_122154_((Vec3i)pos, offsetX, offsetY, offsetZ);
                        int igniteOdds = this.m_221156_((LevelReader)level, (BlockPos)mutablePos);
                        if (igniteOdds <= 0 || random.m_188503_(rand) > igniteOdds || level.m_46471_() && this.m_53428_((Level)level, (BlockPos)mutablePos)) continue;
                        level.m_7731_((BlockPos)mutablePos, this.m_53437_((LevelAccessor)level, (BlockPos)mutablePos, 0), 3);
                    }
                }
            }
        }
        if (age == 15 && !ModConfig.Gameplay.infiniteBurn()) {
            this.NT$oldCheckBurnOut((Level)level, pos.m_122029_(), 1, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_122024_(), 1, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_7495_(), 1, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_7494_(), 1, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_122012_(), 1, random);
            this.NT$oldCheckBurnOut((Level)level, pos.m_122019_(), 1, random);
        }
        callback.cancel();
    }
}

