/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.auto.AutoConfig;
import mod.adrenix.nostalgic.common.config.list.ConfigList;
import mod.adrenix.nostalgic.common.config.list.ListMap;
import mod.adrenix.nostalgic.common.config.list.ListSet;
import mod.adrenix.nostalgic.common.config.tweak.TweakSerializer;
import mod.adrenix.nostalgic.network.packet.PacketS2CTweakUpdate;
import mod.adrenix.nostalgic.server.config.ServerConfig;
import mod.adrenix.nostalgic.server.config.reflect.ServerReflect;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;

public class PacketC2SChangeTweak {
    private final String json;

    public static void register() {
        NostalgicTweaks.NETWORK.register(PacketC2SChangeTweak.class, PacketC2SChangeTweak::encode, PacketC2SChangeTweak::new, PacketC2SChangeTweak::handle);
    }

    public PacketC2SChangeTweak(TweakServerCache<?> tweak) {
        this.json = new TweakSerializer(tweak).serialize();
    }

    public PacketC2SChangeTweak(FriendlyByteBuf buffer) {
        this.json = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.json);
    }

    public void handle(Supplier<NetworkManager.PacketContext> supplier) {
        supplier.get().queue(() -> this.process((NetworkManager.PacketContext)supplier.get()));
    }

    private void process(NetworkManager.PacketContext context) {
        boolean isListMatched;
        if (context.getEnv() == Dist.CLIENT) {
            PacketUtil.warn(Dist.CLIENT, this.getClass());
            return;
        }
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        boolean isOperator = PacketUtil.isPlayerOp(player);
        if (!isOperator) {
            String warn = String.format("Player (%s) tried changing a tweak without permission", player.m_5446_().getString());
            NostalgicTweaks.LOGGER.warn(warn);
            return;
        }
        TweakSerializer serializer = TweakSerializer.deserialize(this.json);
        TweakServerCache cache = TweakServerCache.get(serializer.getGroup(), serializer.getKey());
        boolean isCached = cache != null;
        boolean isValueMatched = isCached && cache.getValue().getClass().equals(serializer.getValue().getClass());
        boolean bl = isListMatched = isCached && cache.getList() != null && cache.getList().id() == serializer.getListId();
        if (NostalgicTweaks.isServer() && isListMatched) {
            ListSet listSet = ConfigList.getSetFromId(serializer.getListId());
            ListMap<?> listMap = ConfigList.getMapFromId(serializer.getListId());
            String lastConfig = "";
            String lastDisabled = "";
            if (listSet != null) {
                lastConfig = String.format("%s did have %s", new Object[]{listSet.getId(), listSet.getConfigSet()});
                lastDisabled = String.format("%s did have disabled defaults %s", new Object[]{listSet.getId(), listSet.getDisabledDefaults()});
                listSet.getConfigSet().clear();
                listSet.getConfigSet().addAll((Collection)serializer.getValue());
                listSet.getDisabledDefaults().clear();
                listSet.getDisabledDefaults().addAll(serializer.getDisabledDefaults());
            } else if (listMap != null) {
                lastConfig = String.format("%s did have %s", new Object[]{listMap.getId(), listMap.getConfigMap()});
                lastDisabled = String.format("%s did have disabled defaults %s", new Object[]{listMap.getId(), listMap.getDisabledDefaults()});
                listMap.getConfigMap().clear();
                listMap.getConfigMap().putAll((Map)serializer.getValue());
                listMap.getDisabledDefaults().clear();
                listMap.getDisabledDefaults().addAll(serializer.getDisabledDefaults());
            }
            List players = player.f_8924_.m_6846_().m_11314_();
            PacketUtil.sendToAll(players, new PacketS2CTweakUpdate(cache));
            AutoConfig.getConfigHolder(ServerConfig.class).save();
            String information = String.format("Updated server list cache in group (%s) and key (%s)", LogColor.apply(LogColor.LIGHT_PURPLE, serializer.getGroup().toString()), LogColor.apply(LogColor.GREEN, serializer.getKey()));
            NostalgicTweaks.LOGGER.info(information);
            NostalgicTweaks.LOGGER.info(lastConfig);
            NostalgicTweaks.LOGGER.info(lastDisabled);
            NostalgicTweaks.LOGGER.info("%s now has %s", new Object[]{serializer.getListId(), serializer.getValue()});
            NostalgicTweaks.LOGGER.info("%s now has disabled defaults %s", new Object[]{serializer.getListId(), serializer.getDisabledDefaults()});
            return;
        }
        if (isValueMatched) {
            if (NostalgicTweaks.isServer()) {
                ServerReflect.setConfig(serializer.getGroup(), serializer.getKey(), serializer.getValue());
                AutoConfig.getConfigHolder(ServerConfig.class).save();
            }
            cache.setStatus(serializer.getStatus());
            cache.setValue(serializer.getValue());
            List players = player.f_8924_.m_6846_().m_11314_();
            PacketUtil.sendToAll(players, new PacketS2CTweakUpdate(cache));
            String information = String.format("%s updated server config entry in group (%s) with key (%s) with new value (%s)", new Object[]{player.m_5446_().getString(), serializer.getGroup(), serializer.getKey(), serializer.getValue()});
            if (NostalgicTweaks.isServer()) {
                NostalgicTweaks.LOGGER.info(information);
            } else {
                NostalgicTweaks.LOGGER.debug(information);
            }
        } else if (cache == null) {
            String warning = String.format("Server's deserialized data in group (%s) with key (%s) could not be found in tweak server cache", new Object[]{serializer.getGroup(), serializer.getKey()});
            NostalgicTweaks.LOGGER.warn(warning);
        } else {
            String warning = String.format("Server's tweak cache (%s) didn't match client's sent deserialized (%s)", cache.getValue().getClass(), serializer.getValue().getClass());
            NostalgicTweaks.LOGGER.warn(warning);
        }
    }
}

