/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.gui.toast.ToastNotification;
import mod.adrenix.nostalgic.common.NostalgicConnection;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;

public class PacketS2CHandshake {
    private final String json;

    public static void register() {
        NostalgicTweaks.NETWORK.register(PacketS2CHandshake.class, PacketS2CHandshake::encode, PacketS2CHandshake::new, PacketS2CHandshake::handle);
    }

    public PacketS2CHandshake(String loader, String version, String protocol) {
        this.json = new NostalgicConnection(loader, version, protocol).serialize();
    }

    public PacketS2CHandshake(FriendlyByteBuf buffer) {
        this.json = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.json);
    }

    public void handle(Supplier<NetworkManager.PacketContext> supplier) {
        supplier.get().queue(() -> this.process((NetworkManager.PacketContext)supplier.get()));
    }

    private void process(NetworkManager.PacketContext context) {
        if (context.getEnv() == Dist.DEDICATED_SERVER) {
            PacketUtil.warn(Dist.DEDICATED_SERVER, this.getClass());
            return;
        }
        NostalgicConnection.deserialize(this.json);
        NostalgicConnection connection = NostalgicTweaks.getConnection().orElseGet(NostalgicConnection::disconnected);
        NostalgicTweaks.LOGGER.info("Connected to server running Nostalgic Tweaks [loader=%s, version=%s, protocol=%s]", connection.getLoader(), connection.getVersion(), connection.getProtocol());
        if (connection.getProtocol().equals("1.3")) {
            NostalgicTweaks.setNetworkVerification(true);
            ToastNotification.handshake();
        } else {
            NostalgicTweaks.setNetworkVerification(false);
            NostalgicTweaks.LOGGER.warn("Connected to a server with Nostalgic Tweaks but received an incorrect protocol");
            String info = String.format("The server sent (%s) but the client has (%s)", LogColor.apply(LogColor.RED, connection.getProtocol()), LogColor.apply(LogColor.GREEN, "1.3"));
            NostalgicTweaks.LOGGER.warn(info);
            NostalgicTweaks.LOGGER.warn("This shouldn't happen! Continuing to play on this server is at your own risk!");
        }
    }
}

