/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.gui.toast.ToastNotification;
import mod.adrenix.nostalgic.client.config.reflect.ClientReflect;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.auto.AutoConfig;
import mod.adrenix.nostalgic.common.config.list.ConfigList;
import mod.adrenix.nostalgic.common.config.list.ListMap;
import mod.adrenix.nostalgic.common.config.list.ListSet;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.common.config.tweak.TweakSerializer;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;

public class PacketS2CTweakUpdate {
    private final String json;

    public static void register() {
        NostalgicTweaks.NETWORK.register(PacketS2CTweakUpdate.class, PacketS2CTweakUpdate::encode, PacketS2CTweakUpdate::new, PacketS2CTweakUpdate::handle);
    }

    public PacketS2CTweakUpdate(TweakServerCache<?> tweak) {
        this.json = new TweakSerializer(tweak).serialize();
    }

    public PacketS2CTweakUpdate(FriendlyByteBuf buffer) {
        this.json = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.json);
    }

    public void handle(Supplier<NetworkManager.PacketContext> supplier) {
        supplier.get().queue(() -> this.process((NetworkManager.PacketContext)supplier.get()));
    }

    private void process(NetworkManager.PacketContext context) {
        boolean isListMatched;
        if (context.getEnv() == Dist.DEDICATED_SERVER) {
            PacketUtil.warn(Dist.DEDICATED_SERVER, this.getClass());
            return;
        }
        TweakSerializer serializer = TweakSerializer.deserialize(this.json);
        TweakServerCache cache = TweakServerCache.get(serializer.getGroup(), serializer.getKey());
        boolean isCached = cache != null;
        boolean isValueMatched = isCached && cache.getValue().getClass().equals(serializer.getValue().getClass());
        boolean bl = isListMatched = isCached && cache.getList() != null && cache.getList().id() == serializer.getListId();
        if (isListMatched) {
            ListSet listSet = ConfigList.getSetFromId(serializer.getListId());
            ListMap<?> listMap = ConfigList.getMapFromId(serializer.getListId());
            if (listSet != null) {
                listSet.getConfigSet().clear();
                listSet.getConfigSet().addAll((Collection)serializer.getValue());
                listSet.getDisabledDefaults().clear();
                listSet.getDisabledDefaults().addAll(serializer.getDisabledDefaults());
            } else if (listMap != null) {
                listMap.getConfigMap().clear();
                listMap.getConfigMap().putAll((Map)serializer.getValue());
                listMap.getDisabledDefaults().clear();
                listMap.getDisabledDefaults().addAll(serializer.getDisabledDefaults());
            }
            if (NostalgicTweaks.isNetworkVerified()) {
                ToastNotification.gotChanges();
            }
            if (NetUtil.isLocalHost()) {
                AutoConfig.getConfigHolder(ClientConfig.class).save();
            }
            String information = String.format("Updated client's server list cache in group (%s) and key (%s)", LogColor.apply(LogColor.LIGHT_PURPLE, serializer.getGroup().toString()), LogColor.apply(LogColor.GREEN, serializer.getKey()));
            NostalgicTweaks.LOGGER.debug(information);
            return;
        }
        if (isValueMatched) {
            boolean isValueChanged = !cache.getServerCache().equals(serializer.getValue());
            cache.setValue(serializer.getValue());
            cache.setStatus(serializer.getStatus());
            cache.setServerCache(serializer.getValue());
            if (NostalgicTweaks.isNetworkVerified() && isValueChanged) {
                ToastNotification.gotChanges();
            }
            if (NetUtil.isLocalHost() && isValueChanged) {
                TweakClientCache.get(serializer.getGroup(), serializer.getKey()).setValue(serializer.getValue(), true);
                ClientReflect.setConfig(serializer.getGroup(), serializer.getKey(), serializer.getValue());
                AutoConfig.getConfigHolder(ClientConfig.class).save();
            }
            String information = String.format("Updated client's server cache in group (%s) and key (%s) with value (%s) and status (%s)", LogColor.apply(LogColor.LIGHT_PURPLE, serializer.getGroup().toString()), LogColor.apply(LogColor.GREEN, serializer.getKey()), LogColor.apply(LogColor.BLUE, serializer.getValue().toString()), TweakStatus.toStringWithColor(serializer.getStatus()));
            NostalgicTweaks.LOGGER.debug(information);
        } else if (cache == null) {
            String warning = String.format("Client's deserialized data with group (%s) and key (%s) could not be found in tweak server cache", LogColor.apply(LogColor.LIGHT_PURPLE, serializer.getGroup().toString()), LogColor.apply(LogColor.GREEN, serializer.getKey()));
            NostalgicTweaks.LOGGER.warn(warning);
        } else {
            String warning = String.format("Client's server cache (%s) didn't match deserialized (%s)", LogColor.apply(LogColor.GREEN, cache.getValue().getClass().toString()), LogColor.apply(LogColor.RED, serializer.getValue().getClass().toString()));
            NostalgicTweaks.LOGGER.warn(warning);
        }
    }
}

