/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.server.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mod.adrenix.nostalgic.common.config.DefaultConfig;
import mod.adrenix.nostalgic.common.config.ValidateConfig;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.auto.ConfigData;
import mod.adrenix.nostalgic.common.config.auto.annotation.Config;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;

@Config(name="nostalgic_tweaks-server")
public class ServerConfig
implements ConfigData {
    public boolean serverSideOnlyMode = false;
    @TweakData.Ignore
    private static final int HEALTH_MIN = 0;
    @TweakData.Ignore
    private static final int HEALTH_MAX = 20;
    @TweakData.Ignore
    private static final int HEALTH_RESET = 10;
    @TweakData.Ignore
    private static final int ITEM_MIN = 1;
    @TweakData.Ignore
    private static final int ITEM_MAX = 64;
    @TweakData.Ignore
    private static final int ITEM_RESET = 64;
    @TweakData.Ignore
    private static final int FOOD_RESET = 1;
    public EyeCandy eyeCandy = new EyeCandy();
    public Gameplay gameplay = new Gameplay();
    public Animation animation = new Animation();

    @Override
    public void validatePostLoad() throws ConfigData.ValidationException {
        ValidateConfig.scan(this);
    }

    public static class EyeCandy {
        @TweakData.BoundedSlider(min=1L, max=64L, reset=16L)
        public int itemMergeLimit = 16;
        public TweakVersion.Hotbar oldCreativeHotbar = DefaultConfig.Candy.OLD_CREATIVE_HOTBAR;
        public boolean oldChestVoxel = false;
        public boolean oldItemMerging = true;
        public boolean oldSquareBorder = true;
        public boolean oldClassicLighting = false;
        public boolean debugEntityId = true;
    }

    public static class Gameplay {
        public boolean oldLadderGap = true;
        public boolean oldSquidMilking = true;
        @TweakData.BoundedSlider(min=0L, max=100L, reset=25L)
        public int animalSpawnCap = 25;
        @TweakData.BoundedSlider(min=0L, max=100L, reset=90L)
        public int monsterSpawnCap = 90;
        public boolean disableAnimalPanic = true;
        public boolean disableSheepEatGrass = false;
        public boolean oldAnimalSpawning = false;
        public boolean oldSheepPunching = false;
        public boolean oneWoolPunch = false;
        public boolean oldZombiePigmenDrops = false;
        public boolean oldSkeletonDrops = false;
        public boolean oldChickenDrops = false;
        public boolean oldZombieDrops = false;
        public boolean oldSpiderDrops = false;
        public boolean oldSheepDrops = false;
        public boolean oldCowDrops = false;
        public boolean oldPigDrops = false;
        public boolean oldStyleZombieVillagerDrops = false;
        public boolean oldStyleCaveSpiderDrops = false;
        public boolean oldStyleMooshroomDrops = false;
        public boolean oldStyleDrownedDrops = false;
        public boolean oldStyleRabbitDrops = false;
        public boolean oldStyleStrayDrops = false;
        public boolean oldStyleHuskDrops = false;
        @TweakData.BoundedSlider(min=0L, max=100L, reset=70L)
        public int arrowSpeed = 70;
        public boolean instantBow = false;
        public boolean invincibleBow = false;
        public boolean disableCooldown = true;
        public boolean disableMissTimer = true;
        public boolean disableCriticalHit = true;
        public boolean disableSweep = true;
        public boolean oldDamageValues = true;
        public boolean disableOrbSpawn = false;
        public boolean disableAnvil = false;
        public boolean disableEnchantTable = false;
        public boolean oldFire = false;
        public boolean instantAir = true;
        public boolean infiniteBurn = false;
        public boolean leftClickDoor = true;
        public boolean leftClickLever = false;
        public boolean leftClickButton = false;
        public boolean instantBonemeal = true;
        public boolean tilledGrassSeeds = false;
        public boolean disableBedBounce = false;
        public boolean disableSprint = false;
        public boolean disableSwim = false;
        public boolean cartBoosting = false;
        public boolean disableHunger = false;
        public boolean instantEat = false;
        public boolean oldFoodStacking = false;
        @TweakData.BoundedSlider(min=0L, max=20L, reset=10L)
        public Map<String, Integer> customFoodHealth = new HashMap<String, Integer>();
        @TweakData.BoundedSlider(min=1L, max=64L, reset=1L)
        public Map<String, Integer> customFoodStacking = new HashMap<String, Integer>();
        public Set<String> disabledFoodHealth = new HashSet<String>();
        public Set<String> disabledFoodStacking = new HashSet<String>();
        @TweakData.BoundedSlider(min=1L, max=64L, reset=64L)
        public Map<String, Integer> customItemStacking = new HashMap<String, Integer>();
    }

    public static class Animation {
        public boolean oldCreativeCrouch = true;
        public boolean oldDirectionalDamage = true;
    }
}

