/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.server.config;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.auto.AutoConfig;
import mod.adrenix.nostalgic.common.config.auto.serializer.GsonConfigSerializer;
import mod.adrenix.nostalgic.server.config.ServerConfig;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import net.minecraft.world.InteractionResult;

public abstract class ServerConfigCache {
    private static boolean initialized = false;
    private static final ServerConfig CLIENT_CACHE = new ServerConfig();
    private static ServerConfig cache;

    private static ServerConfig getCache() {
        if (NostalgicTweaks.isClient()) {
            return CLIENT_CACHE;
        }
        if (!initialized) {
            ServerConfigCache.preload();
        }
        return cache;
    }

    public static ServerConfig getRoot() {
        return ServerConfigCache.getCache();
    }

    public static ServerConfig.EyeCandy getCandy() {
        return ServerConfigCache.getCache().eyeCandy;
    }

    public static ServerConfig.Gameplay getGameplay() {
        return ServerConfigCache.getCache().gameplay;
    }

    public static ServerConfig.Animation getAnimation() {
        return ServerConfigCache.getCache().animation;
    }

    private static InteractionResult reload() {
        cache = AutoConfig.getConfigHolder(ServerConfig.class).getConfig();
        NostalgicTweaks.LOGGER.info("Server config was reloaded");
        return InteractionResult.SUCCESS;
    }

    public static void preload() {
        NostalgicTweaks.LOGGER.info("Initializing server config prematurely for mixin compatibility");
        ServerConfigCache.initialize();
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        AutoConfig.register(ServerConfig.class, GsonConfigSerializer::new);
        AutoConfig.getConfigHolder(ServerConfig.class).registerLoadListener((manager, update) -> ServerConfigCache.reload());
        AutoConfig.getConfigHolder(ServerConfig.class).registerSaveListener((manager, data) -> ServerConfigCache.reload());
        ServerConfigCache.reload();
        NostalgicTweaks.LOGGER.info("Loaded %d server controlled tweaks", TweakServerCache.all().size());
    }
}

