/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.server.config.reflect;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import mod.adrenix.nostalgic.common.config.reflect.CommonReflect;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.server.config.ServerConfig;
import mod.adrenix.nostalgic.server.config.ServerConfigCache;

public abstract class ServerReflect {
    public static void setConfig(TweakGroup group, String key, Object value) {
        ServerReflect.setField(group, ServerConfigCache.getRoot(), key, value);
    }

    public static HashMap<String, Object> getGroup(TweakGroup group) {
        return ServerReflect.fetchFields(group, ServerConfigCache.getRoot());
    }

    private static Pair<Class<?>, Object> getServerGroupClass(TweakGroup group, ServerConfig config) {
        switch (group) {
            case ROOT: 
            case SWING: 
            case GUI: 
            case SOUND: {
                return new Pair(ServerConfig.class, (Object)config);
            }
            case ANIMATION: {
                return new Pair(ServerConfig.Animation.class, (Object)config.animation);
            }
            case GAMEPLAY: {
                return new Pair(ServerConfig.Gameplay.class, (Object)config.gameplay);
            }
            case CANDY: {
                return new Pair(ServerConfig.EyeCandy.class, (Object)config.eyeCandy);
            }
        }
        return new Pair(ServerConfig.class, (Object)config);
    }

    private static void setField(TweakGroup group, ServerConfig config, String key, Object value) {
        CommonReflect.setFieldHelper(ServerReflect.getServerGroupClass(group, config), key, value);
    }

    private static HashMap<String, Object> fetchFields(TweakGroup group, ServerConfig config) {
        return CommonReflect.fetchFieldsHelper(ServerReflect.getServerGroupClass(group, config));
    }
}

