/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.server.config.reflect;

import java.util.Arrays;
import java.util.HashMap;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.reflect.CommonReflect;
import mod.adrenix.nostalgic.common.config.reflect.TweakCommonCache;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.tweak.Tweak;
import mod.adrenix.nostalgic.server.config.reflect.ServerReflect;
import net.minecraftforge.api.distmarker.Dist;

public class TweakServerCache<T>
extends TweakCommonCache {
    private static final HashMap<String, TweakServerCache<?>> CACHE = new HashMap();
    private final boolean isAnnotatedDynamic;
    private T value;
    private T server;

    public static HashMap<String, TweakServerCache<?>> all() {
        return CACHE;
    }

    public static <T> TweakServerCache<T> get(TweakGroup group, String key) {
        return CACHE.get(TweakServerCache.generateKey(group, key));
    }

    public static <T> TweakServerCache<T> get(Tweak tweak) {
        if (tweak.getEnv() == Dist.CLIENT) {
            return null;
        }
        if (tweak.getServerCache() == null) {
            tweak.setServerCache(TweakServerCache.get(tweak.getGroup(), tweak.getKey()));
        }
        return tweak.getServerCache();
    }

    private TweakServerCache(TweakGroup group, String key, T value) {
        super(group, key);
        this.value = value;
        this.server = value;
        this.isAnnotatedDynamic = this.isMetadataPresent(TweakData.Dynamic.class);
    }

    public T getValue() {
        return this.value;
    }

    public T getServerCache() {
        return this.server;
    }

    public boolean isDynamic() {
        return this.isAnnotatedDynamic;
    }

    public void setValue(Object value) {
        if (value.getClass().equals(this.value.getClass())) {
            this.value = value;
        } else {
            String info = String.format("Unable to update value for %s since the received value was (%s). Expected (%s)", TweakServerCache.generateKey(this.group, this.key), value, this.value);
            NostalgicTweaks.LOGGER.warn(info);
        }
    }

    public void setServerCache(Object value) {
        if (value.getClass().equals(this.server.getClass())) {
            this.server = value;
        } else {
            String info = String.format("Unable to update server cache for %s since the received value was (%s). Expected (%s)", TweakServerCache.generateKey(this.group, this.key), value, this.value);
            NostalgicTweaks.LOGGER.warn(info);
        }
    }

    static {
        if (NostalgicTweaks.isClient()) {
            TweakClientCache.all().forEach((id, tweak) -> {
                if (!tweak.isClient() || tweak.isDynamic()) {
                    CACHE.put((String)id, new TweakServerCache(tweak.getGroup(), tweak.getKey(), tweak.getSavedValue()));
                }
            });
        } else {
            Arrays.stream(TweakGroup.values()).forEach(group -> ServerReflect.getGroup(group).forEach((key, value) -> {
                TweakData.Server server = CommonReflect.getAnnotation(group, key, TweakData.Server.class);
                TweakData.Dynamic dynamic = CommonReflect.getAnnotation(group, key, TweakData.Dynamic.class);
                if (server != null || dynamic != null) {
                    CACHE.put(TweakServerCache.generateKey(group, key), new TweakServerCache<Object>((TweakGroup)((Object)group), (String)key, value));
                }
            }));
        }
    }
}

