/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.server.event;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.network.packet.PacketS2CHandshake;
import mod.adrenix.nostalgic.network.packet.PacketS2CTweakUpdate;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.server.PlayerServerUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class ServerEventHelper {
    public static void connect(Player player) {
        if (player instanceof ServerPlayer) {
            String loader = TextUtil.toTitleCase(NostalgicTweaks.getLoader());
            String tiny = NostalgicTweaks.getTinyVersion();
            String beta = NostalgicTweaks.getBetaVersion();
            String version = beta.isEmpty() ? tiny : tiny + "-" + beta;
            String protocol = NostalgicTweaks.getProtocol();
            PacketUtil.sendToPlayer((ServerPlayer)player, new PacketS2CHandshake(loader, version, protocol));
            TweakServerCache.all().forEach((id, tweak) -> {
                if (NostalgicTweaks.isClient()) {
                    TweakClientCache<?> cache = TweakClientCache.all().get(id);
                    tweak.setValue(cache.getSavedValue());
                    tweak.setServerCache(cache.getSavedValue());
                    if (cache.isSavable()) {
                        cache.save();
                    }
                }
                PacketUtil.sendToPlayer((ServerPlayer)player, new PacketS2CTweakUpdate((TweakServerCache<?>)tweak));
            });
            PlayerServerUtil.setCreativeHotbar((ServerPlayer)player);
        }
    }

    public static void instantiate(MinecraftServer instance) {
        NostalgicTweaks.setServer(instance);
    }
}

