/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.util.common.ClassUtil;

public enum ModTracker {
    APPLE_SKIN("appleskin"),
    SODIUM("sodium"),
    RUBIDIUM("rubidium"),
    EXORDIUM("exordium"),
    OPTIFINE("optifine"),
    FLYWHEEL("flywheel");

    private final String id;
    private boolean installed;
    private static final Supplier<Boolean> OPTIFINE_SUPPLIER;

    private ModTracker(String id) {
        this.id = id;
    }

    public static Stream<ModTracker> stream() {
        return Arrays.stream(ModTracker.values());
    }

    public static void init(Function<String, Boolean> loader) {
        ModTracker.stream().forEach(mod -> {
            mod.installed = (Boolean)loader.apply(mod.id);
        });
    }

    public boolean isInstalled() {
        if (this.equals((Object)OPTIFINE)) {
            return OPTIFINE_SUPPLIER.get();
        }
        if (this.equals((Object)SODIUM) && RUBIDIUM.isInstalled()) {
            return true;
        }
        return this.installed;
    }

    static {
        OPTIFINE_SUPPLIER = Suppliers.memoize(ClassUtil::isOptifinePresent);
    }
}

