/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.mixin.widen.Matrix4fAccessor;
import mod.adrenix.nostalgic.util.common.BlockCommonUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BlockClientUtil {
    public static BlockPos getRandomPos(RandomSource randomSource, int bound) {
        return new BlockPos(randomSource.m_188503_(bound), randomSource.m_188503_(bound), randomSource.m_188503_(bound));
    }

    public static boolean isNearBedrock(BlockPos pos, Level level) {
        return pos.m_123342_() < level.m_141937_() + 5;
    }

    public static boolean isFullShape(Block block) {
        boolean isChest = BlockCommonUtil.isOldChest(block);
        boolean isAOFixed = ModConfig.Candy.fixAmbientOcclusion();
        boolean isSoulSand = isAOFixed && block.getClass().equals(SoulSandBlock.class);
        boolean isPowderedSnow = isAOFixed && block.getClass().equals(PowderSnowBlock.class);
        boolean isComposter = isAOFixed && block.getClass().equals(ComposterBlock.class);
        boolean isPiston = isAOFixed && block.getClass().equals(PistonBaseBlock.class);
        return isChest || isSoulSand || isPowderedSnow || isComposter || isPiston;
    }

    public static boolean isTorchModel(BlockState state) {
        return BlockCommonUtil.isBlockEqualTo(state, Blocks.f_50081_, Blocks.f_50174_, Blocks.f_50139_, Blocks.f_50082_, Blocks.f_50123_, Blocks.f_50140_);
    }

    public static void oldTorch(PoseStack poseStack, VertexConsumer consumer, BakedModel model, BlockState state, BlockPos position, RandomSource random) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        boolean isWallTorch = ModConfig.Candy.oldTorchModel() && state.m_60713_(Blocks.f_50082_);
        boolean isSoulWallTorch = ModConfig.Candy.oldSoulTorchModel() && state.m_60713_(Blocks.f_50140_);
        boolean isRedstoneWallTorch = ModConfig.Candy.oldRedstoneTorchModel() && state.m_60713_(Blocks.f_50123_);
        boolean isOldBrightness = ModConfig.Candy.oldTorchBrightness();
        boolean isTorchSheared = isWallTorch || isSoulWallTorch || isRedstoneWallTorch;
        int blockLight = level.m_45517_(LightLayer.BLOCK, position);
        int skyLight = level.m_45517_(LightLayer.SKY, position);
        int brightness = isOldBrightness ? 0xF000F0 : LightTexture.m_109885_((int)blockLight, (int)skyLight);
        int overlay = OverlayTexture.f_118083_;
        if (isTorchSheared) {
            poseStack.m_85836_();
            BlockState baseTorch = Blocks.f_50081_.m_49966_();
            Direction direction = (Direction)state.m_61143_((Property)WallTorchBlock.f_58119_);
            Matrix4fAccessor matrix = (Matrix4fAccessor)poseStack.m_85850_().m_85861_();
            if (isRedstoneWallTorch) {
                baseTorch = Blocks.f_50174_.m_152465_(state);
            } else if (isSoulWallTorch) {
                baseTorch = Blocks.f_50139_.m_49966_();
            }
            BakedModel torch = Minecraft.m_91087_().m_91289_().m_110910_(baseTorch);
            float shear = 0.401f;
            float yShift = 0.198f;
            float xzShift = 0.579f;
            if (direction == Direction.EAST) {
                matrix.NT$setM01(shear);
                poseStack.m_85837_((double)(-xzShift), (double)yShift, 0.0);
            } else if (direction == Direction.WEST) {
                matrix.NT$setM01(-shear);
                poseStack.m_85837_((double)xzShift, (double)yShift, 0.0);
            } else if (direction == Direction.SOUTH) {
                matrix.NT$setM21(shear);
                poseStack.m_85837_(0.0, (double)yShift, (double)(-xzShift));
            } else if (direction == Direction.NORTH) {
                matrix.NT$setM21(-shear);
                poseStack.m_85837_(0.0, (double)yShift, (double)xzShift);
            }
            for (BakedQuad quad : torch.m_213637_(state, null, random)) {
                consumer.m_85987_(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, brightness, overlay);
            }
            poseStack.m_85849_();
        } else {
            for (BakedQuad quad : model.m_213637_(state, null, random)) {
                consumer.m_85987_(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, brightness, overlay);
            }
        }
    }
}

