/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.util.common.ArrayUtil;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.WorldCommonUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.FogType;

public abstract class FogUtil {
    public static boolean isMobEffectActive = false;

    public static boolean isOverworld(Camera camera) {
        return camera.m_90592_().m_9236_().m_46472_() == Level.f_46428_ && !isMobEffectActive;
    }

    public static boolean isNether(Camera camera) {
        return camera.m_90592_().m_9236_().m_46472_() == Level.f_46429_ && !isMobEffectActive;
    }

    private static boolean isFluidFog(Camera camera) {
        return camera.m_167685_() != FogType.NONE;
    }

    private static boolean isEntityBlind(Camera camera) {
        return camera.m_90592_() instanceof LivingEntity && ((LivingEntity)camera.m_90592_()).m_21023_(MobEffects.f_19610_);
    }

    private static void setTerrainFog(FogRenderer.FogMode fogMode, TweakVersion.WorldFog worldFog) {
        int farPlaneDistance;
        if (fogMode != FogRenderer.FogMode.FOG_TERRAIN) {
            return;
        }
        int renderDistance = Minecraft.m_91087_().f_91066_.m_193772_();
        if (worldFog == TweakVersion.WorldFog.CLASSIC) {
            int farPlaneDistance2 = switch (renderDistance) {
                case 2 -> 18;
                case 3, 4 -> 96;
                case 5, 6, 7, 8 -> 302;
                case 9, 10, 11, 12, 13, 14, 15 -> 824;
                default -> 1028;
            };
            RenderSystem.m_157445_((float)0.0f);
            RenderSystem.m_157443_((float)((float)farPlaneDistance2 * 0.8f));
            return;
        }
        if (worldFog == TweakVersion.WorldFog.ALPHA_R164) {
            farPlaneDistance = switch (renderDistance) {
                case 2, 3 -> 8;
                case 4, 5 -> 32;
                case 6, 7, 8, 9 -> 256;
                case 10, 11, 12, 13, 14, 15, 16 -> 512;
                default -> renderDistance * 32;
            };
        } else {
            farPlaneDistance = renderDistance * 16;
        }
        float linearEnding = switch (farPlaneDistance) {
            case 8 -> 4.6f;
            case 32 -> 2.2f;
            default -> 0.8f;
        };
        RenderSystem.m_157445_((float)0.0f);
        RenderSystem.m_157443_((float)((float)farPlaneDistance * linearEnding));
    }

    private static void setHorizonFog(FogRenderer.FogMode fogMode, TweakVersion.WorldFog worldFog) {
        int farPlaneDistance;
        if (fogMode != FogRenderer.FogMode.FOG_SKY || !ModConfig.Candy.disableHorizonFog()) {
            return;
        }
        int renderDistance = Minecraft.m_91087_().f_91066_.m_193772_();
        if (worldFog == TweakVersion.WorldFog.CLASSIC) {
            int farPlaneDistance2 = switch (renderDistance) {
                case 2, 3, 4 -> 128;
                case 5, 6, 7, 8 -> 256;
                default -> 512;
            };
            RenderSystem.m_157445_((float)((float)farPlaneDistance2 * 0.2f));
            RenderSystem.m_157443_((float)farPlaneDistance2);
            return;
        }
        if (worldFog == TweakVersion.WorldFog.ALPHA_R164) {
            farPlaneDistance = switch (renderDistance) {
                case 2, 3 -> 8;
                case 4, 5 -> 32;
                case 6, 7, 8, 9 -> 256;
                default -> 512;
            };
        } else {
            farPlaneDistance = renderDistance * 16;
        }
        RenderSystem.m_157445_((float)((float)farPlaneDistance * 0.25f));
        RenderSystem.m_157443_((float)farPlaneDistance);
    }

    private static void renderFog(FogRenderer.FogMode fogMode) {
        TweakVersion.WorldFog worldFog = ModConfig.Candy.getWorldFog();
        if (worldFog != TweakVersion.WorldFog.MODERN) {
            if (worldFog != TweakVersion.WorldFog.R17_R118) {
                FogUtil.setTerrainFog(fogMode, worldFog);
                FogUtil.setHorizonFog(fogMode, worldFog);
            } else {
                int renderDistance = Minecraft.m_91087_().f_91066_.m_193772_();
                int farPlaneDistance = renderDistance * 16;
                if (fogMode == FogRenderer.FogMode.FOG_TERRAIN) {
                    RenderSystem.m_157445_((float)((float)farPlaneDistance * 0.75f));
                    RenderSystem.m_157443_((float)farPlaneDistance);
                } else {
                    RenderSystem.m_157445_((float)0.0f);
                    RenderSystem.m_157443_((float)farPlaneDistance);
                }
            }
            RenderSystem.m_202160_((FogShape)FogShape.SPHERE);
        }
    }

    private static boolean isFogModified(Camera camera) {
        return FogUtil.isFluidFog(camera) || FogUtil.isEntityBlind(camera) || !FogUtil.isOverworld(camera) || isMobEffectActive;
    }

    public static void setupFog(Camera camera, FogRenderer.FogMode fogMode) {
        if (!FogUtil.isFogModified(camera)) {
            FogUtil.renderFog(fogMode);
        }
        if (ModConfig.Candy.disableVoidFog() || !ModConfig.isModEnabled() || !fogMode.equals((Object)FogRenderer.FogMode.FOG_TERRAIN)) {
            return;
        }
        Void.setFogStart(RenderSystem.m_157200_());
        Void.setFogEnd(RenderSystem.m_157199_());
        Void.render(camera);
    }

    public static void setupNetherFog(Camera camera, FogRenderer.FogMode fogMode) {
        if (isMobEffectActive || !ModConfig.Candy.oldNetherFog() || FogUtil.isFluidFog(camera) || FogUtil.isEntityBlind(camera) || !FogUtil.isNether(camera)) {
            return;
        }
        FogUtil.renderFog(fogMode);
        RenderSystem.m_157445_((float)0.0f);
    }

    public static class Void {
        private static boolean isInitialized = false;
        private static double currentBrightness;
        private static float currentFogStart;
        private static float currentFogEnd;
        private static float currentCelestial;
        private static float currentStarAlpha;
        private static float targetStarAlpha;
        private static float targetFogStart;
        private static float targetFogEnd;
        private static float fogSpeedShift;
        private static float starSpeedShift;
        private static float colorSpeedShift;
        private static float celestialSpeedShift;
        private static float brightnessSpeedShift;
        private static final float MAX_SHIFT = 100000.0f;
        private static final float[] CURRENT_VOID_RGB;
        private static final float[] CURRENT_FOG_RGB;
        private static final float[] CURRENT_SKY_RGB;
        private static final float[] TARGET_SKY_RGB;
        private static final float[] TARGET_FOG_RGB;
        private static final float[] TARGET_VOID_RGB;

        public static void setSkyRed(float red) {
            Void.TARGET_SKY_RGB[0] = red;
        }

        public static void setSkyGreen(float green) {
            Void.TARGET_SKY_RGB[1] = green;
        }

        public static void setSkyBlue(float blue) {
            Void.TARGET_SKY_RGB[2] = blue;
        }

        public static float getSkyRed() {
            return CURRENT_SKY_RGB[0];
        }

        public static float getSkyGreen() {
            return CURRENT_SKY_RGB[1];
        }

        public static float getSkyBlue() {
            return CURRENT_SKY_RGB[2];
        }

        public static void setFogStart(float start) {
            targetFogStart = start;
        }

        public static void setFogEnd(float end) {
            targetFogEnd = end;
        }

        public static void setFogRGB(float r, float g, float b) {
            Void.TARGET_FOG_RGB[0] = r;
            Void.TARGET_FOG_RGB[1] = g;
            Void.TARGET_FOG_RGB[2] = b;
        }

        public static float[] getVoidRGB() {
            return CURRENT_VOID_RGB;
        }

        public static void setVoidRGB(float r, float g, float b) {
            Void.TARGET_VOID_RGB[0] = r;
            Void.TARGET_VOID_RGB[1] = g;
            Void.TARGET_VOID_RGB[2] = b;
        }

        public static void setStarAlpha(float value) {
            targetStarAlpha = value;
        }

        public static float getStarAlpha() {
            return currentStarAlpha;
        }

        public static float getCelestial() {
            return currentCelestial;
        }

        private static float getSpeed(float modifier, Shift shift) {
            Minecraft minecraft = Minecraft.m_91087_();
            Camera camera = minecraft.f_91063_.m_109153_();
            if (FogUtil.isFogModified(camera)) {
                fogSpeedShift = Float.MAX_VALUE;
                starSpeedShift = Float.MAX_VALUE;
                colorSpeedShift = Float.MAX_VALUE;
                celestialSpeedShift = Float.MAX_VALUE;
                brightnessSpeedShift = Float.MAX_VALUE;
            } else if (Void.getYLevel(camera.m_90592_()) > (double)ModConfig.Candy.getVoidFogStart() || !Void.isBelowHorizon()) {
                switch (shift) {
                    case BRIGHTNESS: {
                        brightnessSpeedShift = Mth.m_14036_((float)(brightnessSpeedShift + 0.002f), (float)1.0f, (float)100000.0f);
                        break;
                    }
                    case CELESTIAL: {
                        celestialSpeedShift = Mth.m_14036_((float)(celestialSpeedShift + 0.001f), (float)1.0f, (float)100000.0f);
                        break;
                    }
                    case COLOR: {
                        colorSpeedShift = Mth.m_14036_((float)(colorSpeedShift + 0.01f), (float)1.0f, (float)100000.0f);
                        break;
                    }
                    case STAR: {
                        starSpeedShift = Mth.m_14036_((float)(starSpeedShift + 0.001f), (float)1.0f, (float)100000.0f);
                        break;
                    }
                    case FOG: {
                        fogSpeedShift = Mth.m_14036_((float)(fogSpeedShift + 0.05f), (float)1.0f, (float)100000.0f);
                    }
                }
            } else {
                switch (shift) {
                    case BRIGHTNESS: {
                        brightnessSpeedShift = Float.MAX_VALUE == brightnessSpeedShift ? 100000.0f : 1.0f;
                        break;
                    }
                    case CELESTIAL: {
                        celestialSpeedShift = Float.MAX_VALUE == celestialSpeedShift ? 100000.0f : 1.0f;
                        break;
                    }
                    case COLOR: {
                        colorSpeedShift = Float.MAX_VALUE == colorSpeedShift ? 100000.0f : 1.0f;
                        break;
                    }
                    case STAR: {
                        starSpeedShift = Float.MAX_VALUE == starSpeedShift ? 100000.0f : 1.0f;
                        break;
                    }
                    case FOG: {
                        fogSpeedShift = Float.MAX_VALUE == fogSpeedShift ? 100000.0f : 1.0f;
                    }
                }
            }
            float speedShift = switch (shift) {
                default -> throw new IncompatibleClassChangeError();
                case Shift.BRIGHTNESS -> brightnessSpeedShift;
                case Shift.CELESTIAL -> celestialSpeedShift;
                case Shift.COLOR -> colorSpeedShift;
                case Shift.STAR -> starSpeedShift;
                case Shift.FOG -> fogSpeedShift;
            };
            return modifier * minecraft.m_91297_() * speedShift;
        }

        public static void setCelestialTransparency() {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            float[] RGB = RenderSystem.m_157197_();
            float RAIN = level.m_46722_(Minecraft.m_91087_().m_91297_());
            float ALPHA = Math.min(1.0f - RAIN, Void.getCelestial());
            if (Void.isRendering()) {
                RenderSystem.m_157429_((float)RGB[0], (float)RGB[1], (float)RGB[2], (float)ALPHA);
            }
        }

        public static boolean isBelowHorizon() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            float partialTick = Minecraft.m_91087_().m_91297_();
            if (player == null || level == null) {
                return false;
            }
            return player.m_20299_((float)partialTick).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level) < 0.0;
        }

        public static double getYLevel(Entity entity) {
            return entity.m_20186_() - (double)entity.f_19853_.m_141937_();
        }

        public static boolean isIgnored(Camera camera) {
            Player player;
            boolean isVoidFogDisabled = ModConfig.Candy.disableVoidFog();
            boolean isHeightOutOfBounds = (double)ModConfig.Candy.getVoidFogStart() < Void.getYLevel(camera.m_90592_()) + 0.5;
            Entity entity = camera.m_90592_();
            boolean isNotSurvival = entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_());
            boolean isCreativeOverride = !ModConfig.Candy.creativeVoidFog() && isNotSurvival;
            return isVoidFogDisabled || isHeightOutOfBounds || isCreativeOverride || !Void.isBelowHorizon();
        }

        public static boolean isRendering() {
            return !ModConfig.Candy.disableVoidFog() && ModConfig.isModEnabled() && isInitialized;
        }

        public static int getSkylight(Entity entity) {
            return WorldCommonUtil.getBrightness((BlockAndTintGetter)entity.f_19853_, LightLayer.SKY, entity.m_20183_());
        }

        public static boolean canSeeSky(Camera camera) {
            return camera.m_90592_().f_19853_.m_45527_(camera.m_90588_());
        }

        private static int getLocalBrightness(Entity entity) {
            int encroachment = (int)((1.0f - (float)ModConfig.Candy.getVoidFogEncroach() / 100.0f) * 15.0f);
            int brightness = ModConfig.Candy.shouldLightRemoveVoidFog() ? entity.f_19853_.m_46803_(entity.m_20183_()) : Void.getSkylight(entity);
            return Mth.m_14045_((int)(brightness + encroachment), (int)0, (int)15);
        }

        private static float getDistance(Entity entity) {
            float renderDistance = Minecraft.m_91087_().f_91063_.m_109152_();
            double fogStart = ModConfig.Candy.getVoidFogStart();
            double fogDistance = (double)Void.getLocalBrightness(entity) / 16.0 + Void.getYLevel(entity) / (fogStart == 0.0 ? 1.0 : fogStart);
            return fogDistance >= 1.0 ? renderDistance : (float)Mth.m_14008_((double)(100.0 * Math.pow(Math.max(fogDistance, 0.0), 2.0)), (double)5.0, (double)renderDistance);
        }

        private static float getDistanceDelta(Entity entity) {
            return Math.max(1.0f, Math.min(1.0f, 1.0f - ((float)Void.getYLevel(entity) - (float)ModConfig.Candy.getVoidFogStart() - 15.0f) / 15.0f));
        }

        private static boolean isThick(Camera camera) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return false;
            }
            int x = Mth.m_14107_((double)camera.m_90583_().m_7096_());
            int y = Mth.m_14107_((double)camera.m_90583_().m_7098_());
            return mc.f_91073_.m_104583_().m_5781_(x, y) || mc.f_91065_.m_93090_().m_93715_();
        }

        private static float getFogStart(Camera camera, float distance) {
            return Void.isThick(camera) ? distance * 0.05f : distance * Math.max(0.0f, 0.55f * (1.0f - (distance - 5.0f) / 127.0f));
        }

        private static float getFogEnd(Camera camera, float distance) {
            return Void.isThick(camera) ? Math.min(distance, 192.0f) / 2.0f : distance;
        }

        private static double getBrightness(Entity entity) {
            double brightness = Math.max(15.0 - ((double)ModConfig.Candy.getVoidFogStart() - Void.getYLevel(entity)), (double)Void.getSkylight(entity)) / 15.0;
            currentBrightness = MathUtil.moveClampTowards(currentBrightness, brightness, (double)Void.getSpeed(0.002f, Shift.BRIGHTNESS), 0.0, 1.0);
            return currentBrightness;
        }

        public static void setColor(Camera camera) {
            float SPEED = Void.getSpeed(0.005f, Shift.COLOR);
            if (Void.isIgnored(camera) || FogUtil.isFogModified(camera) || Void.canSeeSky(camera)) {
                MathUtil.moveTowardsColor(CURRENT_FOG_RGB, TARGET_FOG_RGB, SPEED);
                MathUtil.moveTowardsColor(CURRENT_SKY_RGB, TARGET_SKY_RGB, SPEED);
                MathUtil.moveTowardsColor(CURRENT_VOID_RGB, TARGET_VOID_RGB, SPEED);
            } else {
                float[] CURRENT_FOG = RenderSystem.m_157198_();
                int[] CUSTOM_FOG = ColorUtil.toHexRGBA(ModConfig.Candy.getVoidFogColor());
                float LIGHT = (float)Void.getBrightness(camera.m_90592_());
                float FOG_R = Mth.m_14036_((float)(CURRENT_FOG[0] * LIGHT + (float)CUSTOM_FOG[0] / 255.0f), (float)0.0f, (float)1.0f);
                float FOG_G = Mth.m_14036_((float)(CURRENT_FOG[1] * LIGHT + (float)CUSTOM_FOG[1] / 255.0f), (float)0.0f, (float)1.0f);
                float FOG_B = Mth.m_14036_((float)(CURRENT_FOG[2] * LIGHT + (float)CUSTOM_FOG[2] / 255.0f), (float)0.0f, (float)1.0f);
                float[] TARGET_RGB = new float[]{FOG_R, FOG_G, FOG_B};
                MathUtil.moveTowardsGrayscale(CURRENT_FOG_RGB, TARGET_RGB, SPEED);
                MathUtil.moveTowardsGrayscale(CURRENT_SKY_RGB, TARGET_RGB, SPEED);
                MathUtil.moveTowardsGrayscale(CURRENT_VOID_RGB, TARGET_RGB, SPEED);
            }
            RenderSystem.m_69424_((float)CURRENT_FOG_RGB[0], (float)CURRENT_FOG_RGB[1], (float)CURRENT_FOG_RGB[2], (float)0.0f);
            RenderSystem.m_157434_((float)CURRENT_FOG_RGB[0], (float)CURRENT_FOG_RGB[1], (float)CURRENT_FOG_RGB[2]);
        }

        public static void reset() {
            isInitialized = false;
        }

        private static void initialize(Camera camera) {
            if (isInitialized) {
                return;
            }
            ArrayUtil.copy(TARGET_VOID_RGB, CURRENT_VOID_RGB);
            ArrayUtil.copy(TARGET_FOG_RGB, CURRENT_FOG_RGB);
            ArrayUtil.copy(TARGET_SKY_RGB, CURRENT_SKY_RGB);
            currentBrightness = Void.getBrightness(camera.m_90592_());
            currentStarAlpha = targetStarAlpha;
            currentFogStart = 0.0f;
            currentFogEnd = 0.0f;
            fogSpeedShift = 100000.0f;
            starSpeedShift = 100000.0f;
            colorSpeedShift = 100000.0f;
            celestialSpeedShift = 100000.0f;
            brightnessSpeedShift = 100000.0f;
            currentCelestial = 1.0f;
            isInitialized = true;
        }

        private static void render(Camera camera) {
            LivingEntity living;
            Entity entity = camera.m_90592_();
            boolean isIgnored = Void.isIgnored(camera) || FogUtil.isFogModified(camera);
            float partialTicks = Minecraft.m_91087_().m_91297_();
            float distance = Void.getDistance(entity);
            float encroach = Void.getDistanceDelta(entity);
            float speed = Void.getSpeed(1.0f, Shift.FOG);
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(MobEffects.f_19611_)) {
                distance *= 4.0f * GameRenderer.m_109108_((LivingEntity)living, (float)partialTicks);
            }
            float celestialTarget = !isIgnored && Void.getSkylight(entity) == 0 ? 0.0f : 1.0f;
            float fogStartTarget = isIgnored ? targetFogStart : Void.getFogStart(camera, distance) * encroach;
            float fogEndTarget = isIgnored ? targetFogEnd : Void.getFogEnd(camera, distance) * encroach;
            float starTarget = !isIgnored && Void.getSkylight(entity) == 0 ? 0.0f : targetStarAlpha;
            Void.initialize(camera);
            currentCelestial = MathUtil.moveTowards(currentCelestial, celestialTarget, Void.getSpeed(0.07f, Shift.CELESTIAL));
            currentStarAlpha = MathUtil.moveTowards(currentStarAlpha, starTarget, Void.getSpeed(0.03f, Shift.STAR));
            currentFogStart = MathUtil.moveTowards(currentFogStart, fogStartTarget, speed);
            currentFogEnd = MathUtil.moveTowards(currentFogEnd, fogEndTarget, speed);
            RenderSystem.m_157445_((float)currentFogStart);
            RenderSystem.m_157443_((float)currentFogEnd);
        }

        static {
            CURRENT_VOID_RGB = new float[]{0.0f, 0.0f, 0.0f};
            CURRENT_FOG_RGB = new float[]{0.0f, 0.0f, 0.0f};
            CURRENT_SKY_RGB = new float[]{0.0f, 0.0f, 0.0f};
            TARGET_SKY_RGB = new float[]{0.0f, 0.0f, 0.0f};
            TARGET_FOG_RGB = new float[]{0.0f, 0.0f, 0.0f};
            TARGET_VOID_RGB = new float[]{0.0f, 0.0f, 0.0f};
        }

        private static enum Shift {
            STAR,
            COLOR,
            FOG,
            CELESTIAL,
            BRIGHTNESS;

        }
    }

    public static class Water {
        private static float currentDensity = 0.0f;
        private static final float[] CURRENT_RGB = new float[]{0.0f, 0.0f, 0.0f};

        public static void setupFog(float farPlaneDistance) {
            float density = 0.15f;
            float deltaTime = Minecraft.m_91087_().m_91297_();
            Entity entity = Minecraft.m_91087_().m_91288_();
            RenderSystem.m_202160_((FogShape)FogShape.SPHERE);
            RenderSystem.m_157445_((float)-8.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                density = living.m_21023_(MobEffects.f_19608_) || living.m_21023_(MobEffects.f_19592_) ? 0.8f : 0.15f + (float)EnchantmentHelper.m_44918_((LivingEntity)living) * 0.1f;
            }
            float target = farPlaneDistance * Mth.m_14036_((float)density, (float)0.0f, (float)1.0f);
            if (currentDensity == 0.0f) {
                currentDensity = target;
            }
            currentDensity = MathUtil.moveTowards(currentDensity, target, deltaTime);
            RenderSystem.m_157443_((float)(ModConfig.Candy.smoothWaterDensity() ? currentDensity : target));
        }

        public static float getRed(int brightness, float respiration) {
            float red = switch (brightness) {
                case 12, 13, 14, 15 -> 9.0f;
                case 9, 10, 11 -> 6.0f;
                case 3, 4, 5, 6, 7, 8 -> 5.0f;
                default -> 4.0f;
            };
            float TARGET = (respiration > 0.0f ? 19.0f : red) / 255.0f;
            float SPEED = Minecraft.m_91087_().m_91297_() * 0.005f;
            if (CURRENT_RGB[0] == 0.0f) {
                Water.CURRENT_RGB[0] = TARGET;
            }
            Water.CURRENT_RGB[0] = MathUtil.moveTowards(CURRENT_RGB[0], TARGET, SPEED);
            return ModConfig.Candy.smoothWaterColor() ? CURRENT_RGB[0] : TARGET;
        }

        public static float getGreen(int brightness, float respiration) {
            float green = switch (brightness) {
                case 12, 13, 14, 15 -> 16.0f;
                case 9, 10, 11 -> 11.0f;
                case 6, 7, 8 -> 8.0f;
                case 3, 4, 5 -> 7.0f;
                default -> 5.0f;
            };
            float TARGET = (respiration > 0.0f ? 35.0f : green) / 255.0f;
            float SPEED = Minecraft.m_91087_().m_91297_() * 0.005f;
            if (CURRENT_RGB[1] == 0.0f) {
                Water.CURRENT_RGB[1] = TARGET;
            }
            Water.CURRENT_RGB[1] = MathUtil.moveTowards(CURRENT_RGB[1], TARGET, SPEED);
            return ModConfig.Candy.smoothWaterColor() ? CURRENT_RGB[1] : TARGET;
        }

        public static float getBlue(int brightness, float respiration) {
            float blue = switch (brightness) {
                case 12, 13, 14, 15 -> 73.0f;
                case 9, 10, 11 -> 58.0f;
                case 6, 7, 8 -> 50.0f;
                case 3, 4, 5 -> 45.0f;
                default -> 41.0f;
            };
            float TARGET = (respiration > 0.0f ? 150.0f : blue) / 255.0f;
            float SPEED = Minecraft.m_91087_().m_91297_() * 0.005f;
            if (CURRENT_RGB[2] == 0.0f) {
                Water.CURRENT_RGB[2] = TARGET;
            }
            Water.CURRENT_RGB[2] = MathUtil.moveTowards(CURRENT_RGB[2], TARGET, SPEED);
            return ModConfig.Candy.smoothWaterColor() ? CURRENT_RGB[2] : TARGET;
        }
    }
}

