/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.api.ClientEventFactory;
import mod.adrenix.nostalgic.api.event.HudEvent;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakType;
import mod.adrenix.nostalgic.mixin.duck.WidgetManager;
import mod.adrenix.nostalgic.mixin.widen.AbstractContainerScreenAccessor;
import mod.adrenix.nostalgic.mixin.widen.ScreenAccessor;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;

public abstract class GuiUtil {
    @CheckForNull
    public static Function<Screen, Screen> modScreen = null;
    public static int heartY = 0;
    public static int foodY = 0;

    public static ImageButton getLargeBook(AbstractContainerScreenAccessor screen, ImageButton parent) {
        return new ImageButton(screen.NT$getLeftPos() + 151, screen.NT$getTopPos() + 7, 18, 18, 178, 20, TextureLocation.INVENTORY, button -> {
            parent.m_5691_();
            ((ImageButton)button).m_94278_(screen.NT$getLeftPos() + 151, screen.NT$getTopPos() + 7);
        });
    }

    public static ImageButton getSmallBook(AbstractContainerScreenAccessor screen, ImageButton parent) {
        return new ImageButton(screen.NT$getLeftPos() + 160, screen.NT$getTopPos() + 7, 9, 10, 178, 0, TextureLocation.INVENTORY, button -> {
            parent.m_5691_();
            ((ImageButton)button).m_94278_(screen.NT$getLeftPos() + 160, screen.NT$getTopPos() + 7);
        });
    }

    public static void createRecipeButton(AbstractContainerScreenAccessor screen, TweakType.RecipeBook book) {
        ImageButton recipeButton = null;
        WidgetManager injector = (WidgetManager)Minecraft.m_91087_().f_91080_;
        for (Widget widget : ((ScreenAccessor)((Object)screen)).NT$getRenderables()) {
            ImageButton imageButton;
            if (!(widget instanceof ImageButton)) continue;
            recipeButton = imageButton = (ImageButton)widget;
            break;
        }
        if (injector != null && recipeButton != null) {
            switch (book) {
                case DISABLED: {
                    recipeButton.f_93623_ = false;
                    recipeButton.f_93624_ = false;
                    break;
                }
                case LARGE: {
                    injector.NT$removeWidget((GuiEventListener)recipeButton);
                    injector.NT$addRenderableWidget(GuiUtil.getLargeBook(screen, recipeButton));
                    break;
                }
                case SMALL: {
                    injector.NT$removeWidget((GuiEventListener)recipeButton);
                    injector.NT$addRenderableWidget(GuiUtil.getSmallBook(screen, recipeButton));
                }
            }
        }
    }

    private static int getRightX(String text) {
        return Minecraft.m_91087_().m_91268_().m_85445_() - Minecraft.m_91087_().f_91062_.m_92895_(text) - 2;
    }

    private static String getFoodColor(int food) {
        if (food <= 2) {
            return "\u00a74";
        }
        if (food <= 6) {
            return "\u00a7c";
        }
        if (food <= 10) {
            return "\u00a76";
        }
        if (food <= 15) {
            return "\u00a7e";
        }
        if (food < 20) {
            return "\u00a72";
        }
        return "\u00a7a";
    }

    private static String getPercentColor(int percent) {
        if (percent < 20) {
            return "\u00a7c";
        }
        if (percent < 40) {
            return "\u00a76";
        }
        if (percent < 60) {
            return "\u00a7e";
        }
        if (percent < 80) {
            return "\u00a72";
        }
        return "\u00a7a";
    }

    public static void drawText(PoseStack poseStack, String text, TweakType.Corner corner, CornerManager manager) {
        Minecraft minecraft = Minecraft.m_91087_();
        boolean isLeft = corner.equals(TweakType.Corner.TOP_LEFT) || corner.equals(TweakType.Corner.BOTTOM_LEFT);
        minecraft.f_91062_.m_92750_(poseStack, text, isLeft ? 2.0f : (float)GuiUtil.getRightX(text), manager.getAndAdd(corner), 0xFFFFFF);
    }

    public static void renderOverlays(PoseStack poseStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.f_92063_ || minecraft.f_91066_.f_92062_) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        CornerManager manager = new CornerManager();
        boolean isCreative = player.m_7500_() || player.m_5833_();
        boolean isLevelCreative = isCreative && ModConfig.Gameplay.displayAlternativeLevelCreative();
        boolean isProgressCreative = isCreative && ModConfig.Gameplay.displayAlternativeProgressCreative();
        int foodLevel = player.m_36324_().m_38702_();
        int xpPercent = (int)(player.f_36080_ * 100.0f);
        int satPercent = (int)(player.m_36324_().m_38722_() / 20.0f * 100.0f);
        if (ModConfig.Candy.oldVersionOverlay()) {
            GuiUtil.drawText(poseStack, ModConfig.Candy.getOverlayText(), ModConfig.Candy.oldOverlayCorner(), manager);
        }
        if (ModConfig.Gameplay.displayAlternativeLevelText() && (!isCreative || isLevelCreative)) {
            TweakType.Corner levelCorner = ModConfig.Gameplay.alternativeLevelCorner();
            String level = ModConfig.Gameplay.getAlternativeLevelText(Integer.toString(player.f_36078_));
            GuiUtil.drawText(poseStack, level, levelCorner, manager);
        }
        if (ModConfig.Gameplay.displayAlternativeProgressText() && (!isCreative || isProgressCreative)) {
            boolean useColor = ModConfig.Gameplay.useDynamicProgressColor();
            TweakType.Corner xpCorner = ModConfig.Gameplay.alternativeProgressCorner();
            String xp = ModConfig.Gameplay.getAlternativeProgressText((useColor ? GuiUtil.getPercentColor(xpPercent) : "") + xpPercent);
            GuiUtil.drawText(poseStack, xp, xpCorner, manager);
        }
        if (ModConfig.Gameplay.displayAlternativeFoodText() && !isCreative) {
            boolean useColor = ModConfig.Gameplay.useDynamicFoodColor();
            TweakType.Corner foodCorner = ModConfig.Gameplay.alternativeFoodCorner();
            String food = ModConfig.Gameplay.getAlternativeFoodText((useColor ? GuiUtil.getFoodColor(foodLevel) : "") + foodLevel);
            GuiUtil.drawText(poseStack, food, foodCorner, manager);
        }
        if (ModConfig.Gameplay.displayAlternativeSatText() && !isCreative) {
            boolean useColor = ModConfig.Gameplay.useDynamicSatColor();
            TweakType.Corner satCorner = ModConfig.Gameplay.alternativeSaturationCorner();
            String sat = ModConfig.Gameplay.getAlternativeSaturationText((useColor ? GuiUtil.getPercentColor(satPercent) : "") + satPercent);
            GuiUtil.drawText(poseStack, sat, satCorner, manager);
        }
    }

    public static void renderInverseArmor(PoseStack poseStack, float offset, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, (float)x, (float)(y + vHeight), offset).m_7421_((float)(uOffset + uWidth) / 256.0f, (float)(vOffset + vHeight) / 256.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + uWidth), (float)(y + vHeight), offset).m_7421_((float)uOffset / 256.0f, (float)(vOffset + vHeight) / 256.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + uWidth), (float)y, offset).m_7421_((float)uOffset / 256.0f, (float)vOffset / 256.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x, (float)y, offset).m_7421_((float)(uOffset + uWidth) / 256.0f, (float)vOffset / 256.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void renderArmor(Gui gui, PoseStack poseStack, Player player, int width, int height, int leftHeight, int rightHeight) {
        boolean isHungerDisabled = ModConfig.Gameplay.disableHungerBar();
        int left = width / 2 - 91;
        int top = height - (isHungerDisabled ? rightHeight : leftHeight);
        int level = player.m_21230_();
        int index = -1;
        for (int i = 1; level > 0 && i < 20; i += 2) {
            boolean isXChanged = false;
            int x = isHungerDisabled ? width - left - 10 : left;
            int y = top;
            HudEvent event = ClientEventFactory.RENDER_ARMOR.create(x, y, ++index, poseStack);
            event.emit();
            if (event.isCanceled()) continue;
            if (x != event.getX()) {
                isXChanged = true;
            }
            x = event.getX();
            y = event.getY();
            if (i == level) {
                if (isHungerDisabled && !isXChanged) {
                    GuiUtil.renderInverseArmor(poseStack, gui.m_93252_(), x, y, 25, 9, 9, 9);
                } else {
                    gui.m_93228_(poseStack, x, y, 25, 9, 9, 9);
                }
            } else if (i < level) {
                gui.m_93228_(poseStack, x, y, 34, 9, 9, 9);
            } else {
                gui.m_93228_(poseStack, x, y, 16, 9, 9, 9);
            }
            left += 8;
        }
    }

    public static void renderFood(Gui gui, PoseStack poseStack, Player player, int width, int height, int rightHeight) {
        RandomSource random = RandomSource.m_216327_();
        int left = width / 2 + 91;
        int top = height - rightHeight;
        FoodData stats = player.m_36324_();
        int level = stats.m_38702_();
        int index = -1;
        for (int i = 0; i < 10; ++i) {
            int iconX = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 0;
            if (player.m_21023_(MobEffects.f_19612_)) {
                icon += 36;
                background = 13;
            }
            if (player.m_36324_().m_38722_() <= 0.0f && gui.m_93079_() % (level * 3 + 1) == 0) {
                y = top + (random.m_188503_(3) - 1);
            }
            HudEvent event = ClientEventFactory.RENDER_FOOD.create(x, y, ++index, poseStack);
            event.emit();
            foodY = event.getY();
            if (event.isCanceled()) continue;
            x = event.getX();
            y = event.getY();
            gui.m_93228_(poseStack, x, y, 16 + background * 9, 27, 9, 9);
            if (iconX < level) {
                gui.m_93228_(poseStack, x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (iconX != level) continue;
            gui.m_93228_(poseStack, x, y, icon + 45, 27, 9, 9);
        }
    }

    public static void renderAir(Function<Player, Boolean> isPlayerLosingAir, Gui gui, PoseStack poseStack, Player player, int width, int height, int leftHeight, int rightHeight) {
        boolean isHungerDisabled = ModConfig.Gameplay.disableHungerBar();
        int index = -1;
        int left = width / 2 + 91;
        if (left % 2 != 0 && isHungerDisabled) {
            --left;
        }
        int y = height - (isHungerDisabled ? leftHeight : rightHeight);
        int air = player.m_20146_();
        if (isPlayerLosingAir.apply(player).booleanValue()) {
            int full = Mth.m_14165_((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = Mth.m_14165_((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                int shiftX = left - i * 8 - 9;
                int mirrorX = width - shiftX - 10;
                int x = isHungerDisabled ? mirrorX : shiftX;
                HudEvent event = ClientEventFactory.RENDER_BUBBLE.create(x, y, ++index, poseStack);
                event.emit();
                if (event.isCanceled()) {
                    return;
                }
                x = event.getX();
                y = event.getY();
                gui.m_93228_(poseStack, x, y, i < full ? 16 : 25, 18, 9, 9);
            }
        }
    }

    public static class CornerManager {
        private final float height = Minecraft.m_91087_().m_91268_().m_85446_();
        private final AtomicDouble topLeft = new AtomicDouble(2.0);
        private final AtomicDouble topRight = new AtomicDouble(2.0);
        private final AtomicDouble bottomLeft = new AtomicDouble((double)this.height - 10.0);
        private final AtomicDouble bottomRight = new AtomicDouble((double)this.height - 10.0);

        public float getAndAdd(TweakType.Corner corner) {
            return switch (corner) {
                default -> throw new IncompatibleClassChangeError();
                case TweakType.Corner.TOP_LEFT -> (float)this.topLeft.getAndAdd(10.0);
                case TweakType.Corner.TOP_RIGHT -> (float)this.topRight.getAndAdd(10.0);
                case TweakType.Corner.BOTTOM_LEFT -> (float)this.bottomLeft.getAndAdd(-10.0);
                case TweakType.Corner.BOTTOM_RIGHT -> (float)this.bottomRight.getAndAdd(-10.0);
            };
        }
    }
}

