/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.mixin.duck.SlotTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;

public abstract class ItemClientUtil {
    private static boolean isRenderingFlat = false;
    @CheckForNull
    public static PoseStack.Pose levelPoseStack;
    public static MultiBufferSource.BufferSource levelBufferSource;

    public static ItemStack getLastItem(ItemStack originalItemStack, ItemStack rendererItemStack, ItemStack playerItemStack, SlotTracker player) {
        boolean isUnequipped;
        boolean bl = isUnequipped = rendererItemStack.toString().equals("0 air") && playerItemStack.toString().equals("1 air");
        if (!ModConfig.Animation.oldItemReequip() || !isUnequipped) {
            return originalItemStack;
        }
        return player.NT$getLastItem();
    }

    public static boolean isModelFlat(BakedModel model) {
        return !model.m_7547_();
    }

    public static boolean isModelFlat(ItemStack itemStack) {
        return ItemClientUtil.isModelFlat(Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, 0));
    }

    public static void flatten(PoseStack poseStack) {
        poseStack.m_85841_(1.0f, 1.0f, 0.001f);
    }

    public static boolean isLightingFlat() {
        return isRenderingFlat;
    }

    public static void disableDiffusedLighting() {
        if (levelBufferSource != null) {
            levelBufferSource.m_109911_();
        }
        Lighting.m_84930_();
        isRenderingFlat = true;
    }

    public static void enableDiffusedLighting() {
        isRenderingFlat = false;
        if (levelBufferSource != null) {
            levelBufferSource.m_109911_();
        }
        if (Minecraft.m_91087_().f_91073_ == null || levelPoseStack == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_.m_104583_().m_108885_()) {
            Lighting.m_84925_((Matrix4f)levelPoseStack.m_85861_());
        } else {
            Lighting.m_84928_((Matrix4f)levelPoseStack.m_85861_());
        }
    }

    public static void setNormalQuad(PoseStack.Pose pose, BakedQuad quad) {
        pose.m_85864_().m_8180_();
        if (quad.m_111306_() == Direction.NORTH) {
            pose.m_85864_().m_8156_(-1.0f);
        }
    }

    public static List<BakedQuad> getSprites(List<BakedQuad> quads) {
        if (!isRenderingFlat) {
            return quads;
        }
        ArrayList<BakedQuad> southQuads = new ArrayList<BakedQuad>();
        for (BakedQuad baked : quads) {
            if (baked.m_111306_() != Direction.SOUTH) continue;
            southQuads.add(baked);
        }
        return southQuads;
    }

    public static boolean isValidColorItem() {
        return ModConfig.Candy.oldFlatColors() && isRenderingFlat;
    }

    private static void shiftItemColor(float[] SHIFT_RGB, float SHIFT) {
        SHIFT_RGB[0] = Mth.m_14036_((float)(SHIFT_RGB[0] + SHIFT_RGB[0] * SHIFT), (float)0.0f, (float)255.0f);
        SHIFT_RGB[1] = Mth.m_14036_((float)(SHIFT_RGB[1] + SHIFT_RGB[1] * SHIFT), (float)0.0f, (float)255.0f);
        SHIFT_RGB[2] = Mth.m_14036_((float)(SHIFT_RGB[2] + SHIFT_RGB[2] * SHIFT), (float)0.0f, (float)255.0f);
    }

    private static void shiftLeatherItemColor(float[] SHIFT_RGB) {
        float LIGHT = 0.4f * SHIFT_RGB[0] + 0.6f * SHIFT_RGB[1] + 0.1f * SHIFT_RGB[2];
        SHIFT_RGB[0] = Mth.m_14036_((float)(SHIFT_RGB[0] + 0.1f * (LIGHT - SHIFT_RGB[0])), (float)0.0f, (float)255.0f);
        SHIFT_RGB[1] = Mth.m_14036_((float)(SHIFT_RGB[1] + 0.1f * (LIGHT - SHIFT_RGB[1])), (float)0.0f, (float)255.0f);
        SHIFT_RGB[2] = Mth.m_14036_((float)(SHIFT_RGB[2] + 0.1f * (LIGHT - SHIFT_RGB[2])), (float)0.0f, (float)255.0f);
        ItemClientUtil.shiftItemColor(SHIFT_RGB, 0.4f);
    }

    public static int getOldColor(ItemColor itemColor, ItemStack stack, int tintIndex) {
        int COLOR = itemColor.m_92671_(stack, tintIndex);
        int[] ITEM_RGB = new int[]{(COLOR & 0xFF0000) >> 16, (COLOR & 0xFF00) >> 8, COLOR & 0xFF};
        float[] SHIFT_RGB = new float[]{ITEM_RGB[0], ITEM_RGB[1], ITEM_RGB[2]};
        if (stack.m_41720_() instanceof SpawnEggItem) {
            ItemClientUtil.shiftItemColor(SHIFT_RGB, 0.35f);
        } else if (stack.m_41720_() instanceof PotionItem) {
            ItemClientUtil.shiftItemColor(SHIFT_RGB, 0.37f);
        } else if (stack.m_41720_() instanceof DyeableLeatherItem) {
            ItemClientUtil.shiftLeatherItemColor(SHIFT_RGB);
        } else {
            ItemClientUtil.shiftItemColor(SHIFT_RGB, 0.35f);
        }
        return (int)SHIFT_RGB[0] << 16 | (int)SHIFT_RGB[1] << 8 | (int)SHIFT_RGB[2];
    }

    public static void renderGuiItem(ItemStack itemStack, int x, int y, float scale, float dx, float dy) {
        boolean isLightingFlat;
        Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack viewStack = RenderSystem.m_157191_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        viewStack.m_85836_();
        viewStack.m_85837_((double)x, (double)y, (double)(100.0f + itemRenderer.f_115093_));
        viewStack.m_85837_((double)(8.0f + dx), (double)(8.0f + dy), 0.0);
        viewStack.m_85841_(1.0f, -1.0f, 1.0f);
        viewStack.m_85841_(16.0f, 16.0f, 16.0f);
        viewStack.m_85841_(scale, scale, scale);
        RenderSystem.m_157182_();
        PoseStack poseStack = new PoseStack();
        BakedModel bakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = isLightingFlat = !bakedModel.m_7547_();
        if (isLightingFlat) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        buffer.m_109911_();
        RenderSystem.m_69482_();
        if (isLightingFlat) {
            Lighting.m_84931_();
        }
        viewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void renderGuiItem(ItemStack itemStack, int x, int y, float scale, float dy) {
        ItemClientUtil.renderGuiItem(itemStack, x, y, scale, 0.0f, dy);
    }
}

