/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.adrenix.nostalgic.client.config.gui.screen.SettingsScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public abstract class KeyUtil {
    private static final Map<String, KeyMapping> MAPPING_CACHE = new HashMap<String, KeyMapping>();
    public static boolean isFogDown = false;

    public static boolean isModifierDown() {
        return Screen.m_96638_() || Screen.m_96637_() || Screen.m_96639_();
    }

    public static boolean isGoingRight(int key) {
        return (Screen.m_96637_() || Screen.m_96639_()) && key == 262;
    }

    public static boolean isGoingLeft(int key) {
        return (Screen.m_96637_() || Screen.m_96639_()) && key == 263;
    }

    public static boolean isLeftOrRight(int key) {
        return key == 263 || key == 262;
    }

    public static boolean isSearching(int key) {
        return Screen.m_96637_() && key == 70;
    }

    public static boolean isSaving(int key) {
        return Screen.m_96637_() && key == 83;
    }

    public static boolean isSelectAll(int key) {
        return Screen.m_96637_() && key == 65;
    }

    public static boolean isEnter(int key) {
        return key == 257 || key == 335;
    }

    public static boolean isTab(int key) {
        return key == 258;
    }

    public static boolean isEsc(int key) {
        return key == 256;
    }

    public static Optional<KeyMapping> find(String langKey) {
        KeyMapping[] allMappings;
        KeyMapping cache = MAPPING_CACHE.get(langKey);
        if (cache != null) {
            return Optional.of(cache);
        }
        for (KeyMapping keyMapping : allMappings = Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!keyMapping.m_90860_().equals(langKey)) continue;
            MAPPING_CACHE.put(langKey, keyMapping);
            return Optional.of(keyMapping);
        }
        return Optional.empty();
    }

    public static boolean isMappingConflict(KeyMapping mapping) {
        if (!mapping.m_90862_()) {
            KeyMapping[] allMappings;
            for (KeyMapping keyMapping : allMappings = Minecraft.m_91087_().f_91066_.f_92059_) {
                if (keyMapping == mapping || !mapping.m_90850_(keyMapping)) continue;
                return true;
            }
        }
        return false;
    }

    public static void onOpenConfig(KeyMapping openConfig) {
        if (openConfig.m_90857_() && Minecraft.m_91087_().f_91080_ == null) {
            Minecraft.m_91087_().m_91152_((Screen)new SettingsScreen(null, true));
        }
    }

    public static void onToggleFog(KeyMapping toggleFog) {
        boolean isReleased = false;
        if (!isFogDown && toggleFog.m_90857_()) {
            isFogDown = true;
        } else if (isFogDown && !toggleFog.m_90857_()) {
            isFogDown = false;
            isReleased = true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (isReleased && minecraft.f_91073_ != null) {
            int distance = (Integer)minecraft.f_91066_.m_231984_().m_231551_();
            if (distance >= 16) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)8);
            } else if (distance >= 8) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)4);
            } else if (distance >= 4) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)2);
            } else if (distance >= 2) {
                minecraft.f_91066_.m_231984_().m_231514_((Object)16);
            }
            minecraft.f_91060_.m_109826_();
            minecraft.f_91066_.m_92169_();
        }
    }
}

