/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.FogUtil;
import mod.adrenix.nostalgic.util.common.BlockCommonUtil;
import mod.adrenix.nostalgic.util.common.Color;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TimeWatcher;
import mod.adrenix.nostalgic.util.common.WorldCommonUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;

public abstract class WorldClientUtil {
    private static float currentTemperature = Float.NaN;
    private static float currentDarknessShift = Float.NaN;
    public static Matrix4f blueModelView = new Matrix4f();
    public static Matrix4f blueProjection = new Matrix4f();
    private static int lastSkyLight = -1;
    private static boolean enqueueRelightChecks = false;
    private static final TimeWatcher RELIGHT_TIMER = new TimeWatcher(8000L, 2);

    public static float getBiomeTemperature() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        if (player == null) {
            return 0.0f;
        }
        float temp = ((Biome)player.f_19853_.m_204166_(camera.m_90588_()).m_203334_()).m_47554_();
        currentTemperature = Float.isNaN(currentTemperature) ? temp : MathUtil.moveTowards(currentTemperature, temp, 1.0E-5f);
        return currentTemperature;
    }

    public static void resetWorldInterpolationCache() {
        currentTemperature = Float.NaN;
        currentDarknessShift = Float.NaN;
    }

    public static int getSkyColorFromBiome() {
        float temp = WorldClientUtil.getBiomeTemperature() / 2.0f;
        return Color.getHSBColor(0.653f - temp * 0.05f, 0.415f + temp * 0.1f, 1.0f).get();
    }

    public static float[] getFogColorFromBiome() {
        float temp = WorldClientUtil.getBiomeTemperature() / 2.0f;
        float saturation = 0.26f;
        int renderDistance = Minecraft.m_91087_().f_91066_.m_193772_();
        if (renderDistance <= 8) {
            saturation = switch (renderDistance) {
                case 6, 7, 8 -> 0.235f;
                case 4, 5 -> 0.22f;
                case 2, 3 -> 0.18f;
                default -> 0.26f;
            };
        }
        return Color.getHSBColor(0.648f - temp * 0.05f, saturation + temp * 0.1f, 1.0f).getComponents();
    }

    public static float getSunriseRotation(float vanilla) {
        return ModConfig.Candy.oldSunriseAtNorth() ? 0.0f : vanilla;
    }

    public static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder, float y) {
        float x = Math.signum(y) * 512.0f;
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        builder.m_5483_(0.0, (double)y, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            builder.m_5483_((double)(x * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)y, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return builder.m_231175_();
    }

    public static float[] getStdEnvironmentInfluence() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float partialTicks = minecraft.m_91297_();
        float timeOfDay = level.m_46942_(partialTicks);
        float boundedTime = Mth.m_14036_((float)(Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float rain = 1.0f - level.m_46722_(partialTicks) + 0.4f;
        float thunder = 1.0f - level.m_46661_(partialTicks) + 0.2f;
        float weather = Mth.m_14036_((float)Math.min(rain, thunder), (float)0.0f, (float)1.0f);
        float r = boundedTime * weather;
        float g = boundedTime * weather;
        float b = boundedTime * weather;
        return new float[]{r, g, b};
    }

    public static float[] getBlueEnvironmentInfluence() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float partialTicks = minecraft.m_91297_();
        float timeOfDay = level.m_46942_(partialTicks);
        float boundedTime = Mth.m_14036_((float)(Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float voidRed = (float)((double)0.3f * (double)(boundedTime * 0.05f + 0.95f));
        float voidGreen = (float)((double)0.24f * (double)(boundedTime * 0.05f + 0.95f));
        float voidBlue = (float)((double)0.85f * (double)(boundedTime * 0.85f + 0.15f));
        float rainLevel = level.m_46722_(partialTicks);
        float thunderLevel = level.m_46661_(partialTicks);
        if (rainLevel > 0.0f) {
            float redGreenShift = 1.0f - rainLevel * 0.5f;
            float blueShift = 1.0f - rainLevel * 0.4f;
            voidRed *= redGreenShift;
            voidGreen *= redGreenShift;
            voidBlue *= blueShift;
        }
        if (thunderLevel > 0.0f) {
            float shift = 1.0f - thunderLevel * 0.5f;
            voidRed *= shift;
            voidGreen *= shift;
            voidBlue *= shift;
        }
        return new float[]{voidRed, voidGreen, voidBlue};
    }

    public static void setBlueVoidColor() {
        boolean isCustom = ModConfig.Candy.isVoidSkyCustom();
        float[] ENV_RGB = isCustom ? WorldClientUtil.getStdEnvironmentInfluence() : WorldClientUtil.getBlueEnvironmentInfluence();
        float r = ENV_RGB[0];
        float g = ENV_RGB[1];
        float b = ENV_RGB[2];
        float OLD_RED = 0.13f;
        float OLD_GREEN = 0.17f;
        float OLD_BLUE = 0.7f;
        float[] CUSTOM_RGB = ColorUtil.toFloatRGBA(ModConfig.Candy.getVoidSkyColor());
        r = Mth.m_14036_((float)r, (float)0.08f, (float)1.0f) * (isCustom ? CUSTOM_RGB[0] : 0.13f);
        g = Mth.m_14036_((float)g, (float)0.08f, (float)1.0f) * (isCustom ? CUSTOM_RGB[1] : 0.17f);
        b = Mth.m_14036_((float)b, (float)0.08f, (float)1.0f) * (isCustom ? CUSTOM_RGB[2] : 0.7f);
        FogUtil.Void.setVoidRGB(r, g, b);
        if (FogUtil.Void.isRendering()) {
            float[] VOID_RGB = FogUtil.Void.getVoidRGB();
            r = VOID_RGB[0];
            g = VOID_RGB[1];
            b = VOID_RGB[2];
        }
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
    }

    private static void calculateLightInfluence(float[] FOG_COLOR) {
        boolean isIgnored;
        Minecraft minecraft = Minecraft.m_91087_();
        int renderDistance = minecraft.f_91066_.m_193772_();
        int syncedLight = WorldClientUtil.getSyncedLight((BlockAndTintGetter)minecraft.f_91073_, minecraft.f_91063_.m_109153_().m_90588_());
        float brightness = WorldClientUtil.getOldBrightness(syncedLight);
        float distanceShift = (float)renderDistance / (12.0f + (float)renderDistance / 2.0f);
        float darknessShift = brightness * (1.0f - distanceShift) + distanceShift;
        boolean bl = isIgnored = syncedLight == 15 || renderDistance > 8;
        if (!ModConfig.Candy.oldDarkFog() || ModConfig.Candy.oldClassicLight() || isIgnored) {
            darknessShift = 1.0f;
        }
        currentDarknessShift = Float.isNaN(currentDarknessShift) ? darknessShift : MathUtil.moveTowards(currentDarknessShift, darknessShift, 9.0E-4f);
        FOG_COLOR[0] = FOG_COLOR[0] * currentDarknessShift;
        FOG_COLOR[1] = FOG_COLOR[1] * currentDarknessShift;
        FOG_COLOR[2] = FOG_COLOR[2] * currentDarknessShift;
    }

    public static float[] getOldInfluencedFog(float[] FOG_COLOR) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        if (ModConfig.Candy.getWorldFog() == TweakVersion.WorldFog.CLASSIC) {
            int renderDistance = minecraft.f_91066_.m_193772_();
            if (renderDistance <= 3) {
                FOG_COLOR[0] = 1.0f;
                FOG_COLOR[1] = 1.0f;
                FOG_COLOR[2] = 1.0f;
            } else if (renderDistance == 4) {
                FOG_COLOR[0] = 0.9372549f;
                FOG_COLOR[1] = 0.96862745f;
                FOG_COLOR[2] = 1.0f;
            } else if (renderDistance <= 8) {
                FOG_COLOR[0] = 0.9019608f;
                FOG_COLOR[1] = 0.9529412f;
                FOG_COLOR[2] = 1.0f;
            }
        }
        WorldClientUtil.calculateLightInfluence(FOG_COLOR);
        float partialTicks = minecraft.m_91297_();
        float timeOfDay = level.m_46942_(partialTicks);
        float boundedTime = Mth.m_14036_((float)(Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float fogRed = (float)((double)FOG_COLOR[0] * (double)(boundedTime * 0.96f + 0.04f));
        float fogGreen = (float)((double)FOG_COLOR[1] * (double)(boundedTime * 0.96f + 0.04f));
        float fogBlue = (float)((double)FOG_COLOR[2] * (double)(boundedTime * 0.947f + 0.063f));
        float rainLevel = level.m_46722_(partialTicks);
        float thunderLevel = level.m_46661_(partialTicks);
        if (rainLevel > 0.0f) {
            float redGreenShift = 1.0f - rainLevel * 0.5f;
            float blueShift = 1.0f - rainLevel * 0.4f;
            fogRed *= redGreenShift;
            fogGreen *= redGreenShift;
            fogBlue *= blueShift;
        }
        if (thunderLevel > 0.0f) {
            float shift = 1.0f - thunderLevel * 0.5f;
            fogRed *= shift;
            fogGreen *= shift;
            fogBlue *= shift;
        }
        return new float[]{fogRed, fogGreen, fogBlue};
    }

    public static float[] getCustomInfluencedFog(float[] CUSTOM_FOG) {
        float[] ENV_RGB = WorldClientUtil.getStdEnvironmentInfluence();
        WorldClientUtil.calculateLightInfluence(ENV_RGB);
        float r = ENV_RGB[0];
        float g = ENV_RGB[1];
        float b = ENV_RGB[2];
        r = Mth.m_14036_((float)r, (float)0.04f, (float)1.0f) * CUSTOM_FOG[0];
        g = Mth.m_14036_((float)g, (float)0.04f, (float)1.0f) * CUSTOM_FOG[1];
        b = Mth.m_14036_((float)b, (float)0.04f, (float)1.0f) * CUSTOM_FOG[2];
        return new float[]{r, g, b};
    }

    public static void resetLightingCache() {
        lastSkyLight = -1;
        enqueueRelightChecks = false;
    }

    public static boolean isRelightCheckEnqueued() {
        return enqueueRelightChecks;
    }

    public static void setRelightFinished() {
        enqueueRelightChecks = false;
    }

    public static int getSyncedLight(BlockAndTintGetter level, BlockPos blockPos) {
        boolean isWaterLight;
        if (ModConfig.Candy.oldClassicLight()) {
            return WorldClientUtil.getClassicLight(blockPos);
        }
        int skyLight = WorldCommonUtil.getBrightness(level, LightLayer.SKY, blockPos);
        int blockLight = WorldCommonUtil.getBrightness(level, LightLayer.BLOCK, blockPos);
        boolean isOldWater = ModConfig.Candy.oldWaterLighting();
        boolean bl = isWaterLight = isOldWater && BlockCommonUtil.isInWater(level, blockPos);
        if (isWaterLight && !ModTracker.SODIUM.isInstalled()) {
            skyLight = BlockCommonUtil.getWaterLightBlock(level, blockPos);
        }
        return WorldClientUtil.getMaxLight(skyLight, blockLight);
    }

    public static int getWeatherInfluence(ClientLevel level) {
        float partialTick = Minecraft.m_91087_().m_91297_();
        float rain = level.m_46722_(partialTick);
        float thunder = level.m_46661_(partialTick);
        int rainDiff = 0;
        int thunderDiff = 0;
        if (rain >= 0.3f) {
            rainDiff = 1;
        }
        if (rain >= 0.6f) {
            rainDiff = 2;
        }
        if (rain >= 0.9f) {
            rainDiff = 3;
        }
        if (thunder >= 0.8f) {
            thunderDiff = 5;
        }
        return Math.max(rainDiff, thunderDiff);
    }

    public static float getSkylightSubtracted(ClientLevel level) {
        if (ModConfig.Candy.oldLightRendering()) {
            return 0.0f;
        }
        float forceBrightness = level.m_46472_() == Level.f_46429_ ? 7.0f : 15.0f;
        float skyDarken = 1.0f - (Mth.m_14089_((float)(level.m_46942_(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f);
        skyDarken = 1.0f - Mth.m_14036_((float)skyDarken, (float)0.0f, (float)1.0f);
        skyDarken = (float)((double)skyDarken * (1.0 - (double)(level.m_46722_(1.0f) * 5.0f) / 16.0));
        skyDarken = (float)((double)skyDarken * (1.0 - (double)(level.m_46661_(1.0f) * 5.0f) / 16.0));
        skyDarken = 1.0f - skyDarken;
        return skyDarken * (forceBrightness - 4.0f) + (15.0f - forceBrightness);
    }

    public static float getOldBrightness(int i) {
        float light = 1.0f - (float)i / 15.0f;
        return (1.0f - light) / (light * 3.0f + 1.0f) * 0.95f + 0.05f;
    }

    public static int getClassicLight(BlockPos blockPos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || !level.m_6042_().f_223549_()) {
            return 0;
        }
        int skyLight = WorldCommonUtil.getBrightness((BlockAndTintGetter)level, LightLayer.SKY, blockPos);
        if (skyLight == 15) {
            return 15;
        }
        if (skyLight == 0) {
            return 0;
        }
        BlockPos abovePos = blockPos.m_7494_();
        while (abovePos.m_123342_() < level.m_151558_()) {
            if (level.m_8055_(abovePos).m_60739_((BlockGetter)level, abovePos) == 15) {
                return 0;
            }
            if (WorldCommonUtil.getBrightness((BlockAndTintGetter)level, LightLayer.SKY, abovePos) == 15) {
                return 15;
            }
            abovePos = abovePos.m_7494_();
        }
        return 15;
    }

    public static int getMaxLight(int currentSkyLight, int currentBlockLight) {
        boolean isExtraRelight;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || currentSkyLight <= 0) {
            return Math.max(currentSkyLight, currentBlockLight);
        }
        int dynamicLight = WorldCommonUtil.getDynamicSkylight((LevelAccessor)level);
        if (!level.m_6042_().f_223549_() || level.m_6042_().f_63856_()) {
            dynamicLight = 0;
        }
        int levelMaxLight = level.m_7469_();
        int weatherDiff = WorldClientUtil.getWeatherInfluence(level);
        int minSkyLight = Math.max(0, (level.m_6042_().m_63967_() ? dynamicLight : levelMaxLight) - 11);
        int minLight = currentSkyLight >= levelMaxLight ? minSkyLight : 0;
        int maxLight = Math.max(currentBlockLight, ModConfig.Candy.getMaxBlockLight());
        int skyLight = dynamicLight - weatherDiff;
        int skyDiff = levelMaxLight - currentSkyLight;
        boolean isSkyLightChanged = lastSkyLight == -1 || lastSkyLight != Math.max(0, skyLight);
        boolean bl = isExtraRelight = !isSkyLightChanged && !enqueueRelightChecks && RELIGHT_TIMER.isReady();
        if (isSkyLightChanged || isExtraRelight) {
            if (!isExtraRelight) {
                RELIGHT_TIMER.reset();
            }
            lastSkyLight = Math.max(0, skyLight);
            enqueueRelightChecks = true;
        }
        if (currentSkyLight != levelMaxLight && skyLight <= minSkyLight) {
            skyLight += weatherDiff;
        }
        return Mth.m_14045_((int)Math.max(skyLight - skyDiff, currentBlockLight), (int)minLight, (int)maxLight);
    }

    public static int getWaterLight(BlockAndTintGetter level, BlockPos source) {
        int center = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)source);
        int above = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)source.m_7494_());
        int below = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)source.m_7495_());
        int north = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)source.m_122012_());
        int south = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)source.m_122019_());
        int west = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)source.m_122024_());
        int east = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)source.m_122029_());
        return MathUtil.getLargest(center, above, below, north, south, west, east);
    }
}

