/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.util.common.WorldCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockCommonUtil {
    public static boolean isOldChest(Block block) {
        boolean isOldChest = ModConfig.Candy.oldChest() && block.getClass().equals(ChestBlock.class);
        boolean isOldEnder = ModConfig.Candy.oldEnderChest() && block.getClass().equals(EnderChestBlock.class);
        boolean isOldTrap = ModConfig.Candy.oldTrappedChest() && block.getClass().equals(TrappedChestBlock.class);
        return isOldChest || isOldEnder || isOldTrap;
    }

    public static int getWaterLightBlock(BlockAndTintGetter level, BlockPos blockPos) {
        BlockPos abovePos = blockPos.m_7494_();
        int numberOfWater = 1;
        for (int i = 0; i < 4 && BlockCommonUtil.isInWater(level, abovePos); ++i) {
            ++numberOfWater;
            abovePos = abovePos.m_7494_();
        }
        int skylight = WorldCommonUtil.getBrightness(level, LightLayer.SKY, blockPos);
        int subtract = numberOfWater * 3;
        return Math.max(0, skylight - subtract + numberOfWater);
    }

    public static boolean isInWater(BlockAndTintGetter level, BlockPos pos) {
        try {
            return level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isBlockEqualTo(BlockState block, Block ... equalTo) {
        for (Block equal : equalTo) {
            if (!block.m_60713_(equal)) continue;
            return true;
        }
        return false;
    }
}

