/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ColorUtil {
    private static boolean isHexadecimal(String hex) {
        try {
            Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isValidHexString(String check) {
        String[] split;
        if ((check = check.replaceAll("#", "")).length() != 6 && check.length() != 8) {
            return false;
        }
        for (String hex : split = ColorUtil.splitInTwo(check)) {
            if (ColorUtil.isHexadecimal(hex)) continue;
            return false;
        }
        return true;
    }

    public static int[] toHexRGBA(String convert) {
        int[] rgba = new int[]{255, 255, 255, 255};
        convert = convert.replaceAll("#", "");
        if ((convert = convert.replaceAll("0x", "")).length() != 6 && convert.length() != 8) {
            return rgba;
        }
        String[] hex = ColorUtil.splitInTwo(convert);
        for (int i = 0; i < hex.length; ++i) {
            if (!ColorUtil.isHexadecimal(hex[i])) continue;
            rgba[i] = Integer.parseInt(hex[i], 16);
        }
        return rgba;
    }

    public static float[] toFloatRGBA(String convert) {
        int[] rgba = ColorUtil.toHexRGBA(convert);
        return new float[]{(float)rgba[0] / 255.0f, (float)rgba[1] / 255.0f, (float)rgba[2] / 255.0f, (float)rgba[3] / 255.0f};
    }

    public static int toIntFromRGBA(float[] rgba) {
        return (int)(rgba[3] * 255.0f) << 24 | (int)(rgba[0] * 255.0f) << 16 | (int)(rgba[1] * 255.0f) << 8 | (int)(rgba[2] * 255.0f);
    }

    public static int toHexInt(String convert) {
        int[] hex = ColorUtil.toHexRGBA(convert);
        int r = hex[0];
        int g = hex[1];
        int b = hex[2];
        int a = hex[3];
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static String toHexString(int[] rgba) {
        StringBuilder hex = new StringBuilder("#");
        for (int color : rgba) {
            if (color < 0 || color > 255) continue;
            hex.append(color <= 15 ? "0" : "").append(Integer.toHexString(color).toUpperCase());
        }
        return hex.toString();
    }

    private static String[] splitInTwo(String convert) {
        String[] split = new String[]{"FF", "FF", "FF", "FF"};
        String regex = "(..)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(convert);
        int i = -1;
        while (matcher.find()) {
            split[++i] = matcher.group(0);
        }
        return split;
    }
}

