/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public abstract class ItemCommonUtil {
    public static Item getItem(String resourceKey) {
        return (Item)Registry.f_122827_.m_7745_(ResourceLocation.m_135820_((String)resourceKey));
    }

    public static ItemStack getItemStack(String resourceKey) {
        return ItemCommonUtil.getItem(resourceKey).m_7968_();
    }

    public static Block getBlock(String resourceKey) {
        return (Block)Registry.f_122824_.m_7745_(ResourceLocation.m_135820_((String)resourceKey));
    }

    public static Block getBlockFromItem(Item item) {
        return ItemCommonUtil.getBlock(ItemCommonUtil.getResourceKey(item));
    }

    public static String getResourceKey(Item item) {
        return Registry.f_122827_.m_7981_((Object)item).toString();
    }

    public static Set<String> getKeysFromItems(Item ... items) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Item item : items) {
            keys.add(ItemCommonUtil.getResourceKey(item));
        }
        return keys;
    }

    public static boolean isValidKey(String resourceKey) {
        return ItemCommonUtil.getResourceKey(ItemCommonUtil.getItem(resourceKey)).equals(resourceKey);
    }

    public static String getLocalizedItem(String resourceKey) {
        String localized = ItemCommonUtil.getItem(resourceKey).m_7968_().m_41786_().getString();
        Item item = ItemCommonUtil.getItem(resourceKey);
        if (ItemCommonUtil.getResourceKey(item).equals("minecraft:air")) {
            if (ItemCommonUtil.isValidKey(resourceKey)) {
                return Component.m_237115_((String)"gui.nostalgic_tweaks.swing.hand").getString();
            }
            return Component.m_237115_((String)"gui.nostalgic_tweaks.swing.unknown").getString();
        }
        return localized;
    }
}

