/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import net.minecraft.util.Mth;

public abstract class MathUtil {
    public static boolean isEven(int number) {
        return number % 2 == 0;
    }

    public static boolean isOdd(int number) {
        return !MathUtil.isEven(number);
    }

    public static long bytesToMegabytes(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static boolean isInRange(int value, int start, int end) {
        return value >= start && value <= end;
    }

    public static boolean isInRange(float value, float start, float end) {
        return value >= start && value <= end;
    }

    public static boolean tolerance(int a, int b, int tolerance) {
        return Math.abs(a - b) < tolerance;
    }

    public static boolean tolerance(int a, int b) {
        return MathUtil.tolerance(a, b, 3);
    }

    public static boolean tolerance(float a, float b, float tolerance) {
        return Math.abs(a - b) < tolerance;
    }

    public static boolean tolerance(double a, double b, double tolerance) {
        return Math.abs(a - b) < tolerance;
    }

    public static boolean tolerance(float a, float b, float c, float tolerance) {
        return MathUtil.tolerance(a, b, tolerance) && MathUtil.tolerance(b, c, tolerance);
    }

    public static boolean isWithinBox(double pointX, double pointY, double startX, double startY, double width, double height) {
        return pointX >= startX && pointX <= startX + width && pointY >= startY && pointY <= startY + height;
    }

    public static float sign(float input) {
        return input < 0.0f ? -1.0f : 1.0f;
    }

    public static double sign(double input) {
        return input < 0.0 ? -1.0 : 1.0;
    }

    private static boolean isTargetImmediate(float current, float target, float delta) {
        return Math.abs(target - current) <= delta;
    }

    public static float moveTowards(float current, float target, float delta) {
        return Math.abs(target - current) <= delta ? target : current + MathUtil.sign(target - current) * delta;
    }

    public static double moveTowards(double current, double target, double delta) {
        return Math.abs(target - current) <= delta ? target : current + MathUtil.sign(target - current) * delta;
    }

    public static float moveClampTowards(float current, float target, float delta, float min, float max) {
        return Mth.m_14036_((float)MathUtil.moveTowards(current, target, delta), (float)min, (float)max);
    }

    public static double moveClampTowards(double current, double target, double delta, double min, double max) {
        return Mth.m_14008_((double)MathUtil.moveTowards(current, target, delta), (double)min, (double)max);
    }

    public static void moveTowardsColor(float[] CURRENT_RGB, float[] TARGET_RGB, float SPEED) {
        CURRENT_RGB[0] = MathUtil.moveClampTowards(CURRENT_RGB[0], TARGET_RGB[0], SPEED, 0.0f, 1.0f);
        CURRENT_RGB[1] = MathUtil.moveClampTowards(CURRENT_RGB[1], TARGET_RGB[1], SPEED, 0.0f, 1.0f);
        CURRENT_RGB[2] = MathUtil.moveClampTowards(CURRENT_RGB[2], TARGET_RGB[2], SPEED, 0.0f, 1.0f);
    }

    public static void moveTowardsGrayscale(float[] CURRENT_RGB, float[] TARGET_RGB, float SPEED) {
        boolean isImmediate;
        boolean isR = MathUtil.tolerance(CURRENT_RGB[0], TARGET_RGB[0], 0.1f);
        boolean isG = MathUtil.tolerance(CURRENT_RGB[1], TARGET_RGB[1], 0.1f);
        boolean isB = MathUtil.tolerance(CURRENT_RGB[2], TARGET_RGB[2], 0.1f);
        boolean bl = isImmediate = MathUtil.isTargetImmediate(CURRENT_RGB[0], TARGET_RGB[0], SPEED) || isR && isG && isB;
        if (isImmediate || MathUtil.tolerance(CURRENT_RGB[0], CURRENT_RGB[1], CURRENT_RGB[2], 0.05f)) {
            MathUtil.moveTowardsColor(CURRENT_RGB, TARGET_RGB, SPEED);
        } else {
            float AVERAGE = (CURRENT_RGB[0] + CURRENT_RGB[1] + CURRENT_RGB[2]) / 3.0f;
            CURRENT_RGB[0] = MathUtil.moveClampTowards(CURRENT_RGB[0], AVERAGE, SPEED, 0.0f, 1.0f);
            CURRENT_RGB[1] = MathUtil.moveClampTowards(CURRENT_RGB[1], AVERAGE, SPEED, 0.0f, 1.0f);
            CURRENT_RGB[2] = MathUtil.moveClampTowards(CURRENT_RGB[2], AVERAGE, SPEED, 0.0f, 1.0f);
        }
    }

    public static int getLargest(int ... numbers) {
        int largest = Integer.MIN_VALUE;
        for (int number : numbers) {
            if (number <= largest) continue;
            largest = number;
        }
        return largest;
    }
}

