/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.common.config.BackupConfig;
import net.minecraft.Util;

public abstract class PathUtil {
    public static boolean isNotDirectory(Path file) {
        return !Files.isDirectory(file, new LinkOption[0]);
    }

    public static boolean isBackupFile(Path file) {
        return !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().matches(BackupConfig.FILE_REGEX);
    }

    public static String getDirectorySlash() {
        return Util.m_137581_() == Util.OS.WINDOWS ? "\\" : "/";
    }

    public static List<String> getFilenames(Path path, Predicate<? super Path> filter) throws IOException {
        try (Stream<Path> stream = Files.list(path);){
            List<String> list = stream.filter(filter).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
            return list;
        }
    }

    public static List<String> getFilenames(Path path) throws IOException {
        return PathUtil.getFilenames(path, PathUtil::isNotDirectory);
    }

    public static long getCreationTime(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
        }
        catch (IOException exception) {
            return 0L;
        }
    }

    public static List<Path> getOldestFiles(Path path, Predicate<? super Path> filter) throws IOException {
        try (Stream<Path> stream = Files.list(path);){
            List list = stream.filter(filter).sorted(Comparator.comparingLong(PathUtil::getCreationTime)).collect(Collectors.toCollection(LinkedList::new));
            return list;
        }
    }

    public static List<Path> getOldestFiles(Path path) throws IOException {
        return PathUtil.getOldestFiles(path, PathUtil::isNotDirectory);
    }

    public static void delete(Path file) {
        try {
            Files.delete(file);
            NostalgicTweaks.LOGGER.info("Deleted: %s", file.getFileName().toString());
        }
        catch (NoSuchFileException exception) {
            NostalgicTweaks.LOGGER.error("File: %s - does not exist so it cannot be deleted", file);
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error(exception.getMessage());
        }
    }

    private static Path getPath(String path) {
        try {
            return Files.createDirectories(Platform.getConfigFolder().resolve(path), new FileAttribute[0]);
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error(exception.getMessage());
            return null;
        }
    }

    public static Path getConfigPath() {
        return PathUtil.getPath("nostalgic_tweaks");
    }

    public static Path getBackupPath() {
        return PathUtil.getPath("nostalgic_tweaks/backup");
    }

    public static Path getPresetPath() {
        return PathUtil.getPath("nostalgic_tweaks/presets");
    }
}

