/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;

public abstract class TextUtil {
    public static ArrayList<String> extractAll(String from, String regex) {
        ArrayList<String> results = new ArrayList<String>();
        Pattern.compile(regex).matcher(from).results().map(match -> match.group(0)).forEach(results::add);
        if (results.isEmpty()) {
            results.add("");
        }
        return results;
    }

    public static String extract(String from, String regex) {
        return TextUtil.extractAll(from, regex).get(0);
    }

    public static String getPercentColorHigh(int percent) {
        if (percent < 20) {
            return "\u00a7a" + percent + "\u00a7r";
        }
        if (percent < 40) {
            return "\u00a72" + percent + "\u00a7r";
        }
        if (percent < 60) {
            return "\u00a7e" + percent + "\u00a7r";
        }
        if (percent < 80) {
            return "\u00a76" + percent + "\u00a7r";
        }
        if (percent < 100) {
            return "\u00a7c" + percent + "\u00a7r";
        }
        return "\u00a74" + percent + "\u00a7r";
    }

    public static String toTitleCase(String convert) {
        String delimiters = " _";
        StringBuilder builder = new StringBuilder(convert.toLowerCase());
        boolean next = true;
        for (int i = 0; i < builder.length(); ++i) {
            char c = builder.charAt(i);
            c = next ? Character.toUpperCase(c) : Character.toLowerCase(c);
            builder.deleteCharAt(i);
            builder.replace(i, i, String.valueOf(c));
            boolean bl = next = delimiters.indexOf(c) >= 0;
            if (!next) continue;
            builder.deleteCharAt(i);
            builder.replace(i, i, " ");
        }
        return builder.toString();
    }

    public static String ellipsis(String in) {
        if (in == null) {
            return "";
        }
        int length = (in = in.replaceAll("\\.\\.\\.", "")).length();
        if (length < 3) {
            return in;
        }
        return in.substring(0, length - 3) + "...";
    }

    public static Component combine(Component[] lines) {
        StringBuilder builder = new StringBuilder();
        for (Component component : lines) {
            builder.append(component.getString()).append("\n\n");
        }
        return Component.m_237113_((String)builder.toString());
    }

    public static class Wrap {
        public static List<Component> tooltip(Component translation, int width) {
            String translated = translation.getString();
            ArrayList<String> lines = Wrap.wrap(translated, width);
            ArrayList<Component> components = new ArrayList<Component>();
            lines.forEach(line -> components.add((Component)Component.m_237113_((String)line)));
            return components;
        }

        private static ArrayList<String> wrap(String string, int lineLength) {
            ArrayList<String> processed = new ArrayList<String>();
            ArrayList<String> lines = new ArrayList<String>();
            String last = "";
            for (String line : string.split(Pattern.quote("\n"))) {
                processed.add(Wrap.inspect(line, lineLength));
            }
            for (String row : processed) {
                for (String line : row.split(Pattern.quote("\n"))) {
                    lines.add(Wrap.getCodes(last) + line.trim());
                    last = lines.get(lines.size() - 1);
                }
            }
            return lines;
        }

        private static String getCodes(String row) {
            Pattern pattern = Pattern.compile(".*(\u00a7.)");
            Matcher matcher = pattern.matcher(row);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return "";
        }

        private static String inspect(String line, int lineLength) {
            if (line.length() == 0) {
                return " \n";
            }
            if (line.length() <= lineLength) {
                return line + "\n";
            }
            String[] words = line.split(" ");
            StringBuilder lineBuilder = new StringBuilder();
            StringBuilder trimBuilder = new StringBuilder();
            StringBuilder stripBuilder = new StringBuilder();
            for (String word : words) {
                String stripped = word.replaceAll("\u00a7.", "");
                if (stripBuilder.length() + 1 + stripped.length() <= lineLength) {
                    trimBuilder.append(word).append(" ");
                    stripBuilder.append(stripped).append(" ");
                    continue;
                }
                lineBuilder.append((CharSequence)trimBuilder).append("\n");
                trimBuilder = new StringBuilder();
                trimBuilder.append(word).append(" ");
                stripBuilder = new StringBuilder();
                stripBuilder.append(stripped).append(" ");
            }
            if (stripBuilder.length() > 0) {
                lineBuilder.append((CharSequence)trimBuilder);
            }
            return lineBuilder.toString();
        }
    }
}

