/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import mod.adrenix.nostalgic.NostalgicTweaks;
import net.minecraft.Util;

public class TimeWatcher {
    private static final int NO_REPEAT = -1;
    private boolean skip = false;
    private boolean debug = true;
    private final long timeInterval;
    private final int maxRepeat;
    private long timeSinceLast = 0L;
    private int repeated;

    public TimeWatcher(long timeInterval, int maxRepeat) {
        this.timeInterval = timeInterval;
        this.maxRepeat = maxRepeat;
        this.repeated = 0;
    }

    public TimeWatcher(long timeInterval) {
        this(timeInterval, -1);
    }

    public void setDebug(boolean state) {
        this.debug = state;
    }

    public void reset() {
        this.timeSinceLast = Util.m_137550_();
        this.repeated = 0;
    }

    public boolean isMaxReached() {
        return this.repeated == this.maxRepeat;
    }

    public void skip() {
        this.skip = true;
    }

    public boolean isReady() {
        if (this.skip) {
            this.skip = false;
            this.timeSinceLast = Util.m_137550_();
            return false;
        }
        if (this.timeSinceLast == 0L) {
            this.timeSinceLast = Util.m_137550_() - this.timeInterval;
        }
        if (this.maxRepeat != -1 && this.repeated >= this.maxRepeat) {
            return false;
        }
        if (Util.m_137550_() - this.timeSinceLast >= this.timeInterval) {
            if (this.maxRepeat != -1) {
                ++this.repeated;
            }
            this.timeSinceLast = Util.m_137550_();
            if (this.debug) {
                NostalgicTweaks.LOGGER.debug("Timer [timerInterval=%s, maxRepeat=%s, repeated=%s, timeSinceLast=%s] is ready", this.timeInterval, this.maxRepeat, this.repeated, this.timeSinceLast);
            }
            return true;
        }
        return false;
    }
}

