/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public abstract class WorldCommonUtil {
    public static int getBrightness(BlockAndTintGetter level, LightLayer lightLayer, BlockPos blockPos) {
        return level.m_5518_().m_75814_(lightLayer).m_7768_(blockPos);
    }

    public static int getDynamicSkylight(LevelAccessor level) {
        float sunAngle = level.m_46942_(1.0f) * ((float)Math.PI * 2);
        int skyLight = 15;
        if (MathUtil.isInRange(sunAngle, 1.8235918f, 4.459594f)) {
            skyLight = 4;
        } else if (MathUtil.isInRange(sunAngle, 4.459884f, 4.5061855f) || MathUtil.isInRange(sunAngle, 1.7769997f, 1.8233016f)) {
            skyLight = 5;
        } else if (MathUtil.isInRange(sunAngle, 4.5064745f, 4.55252f) || MathUtil.isInRange(sunAngle, 1.7306658f, 1.7767112f)) {
            skyLight = 6;
        } else if (MathUtil.isInRange(sunAngle, 4.552807f, 4.5983024f) || MathUtil.isInRange(sunAngle, 1.684883f, 1.7303787f)) {
            skyLight = 7;
        } else if (MathUtil.isInRange(sunAngle, 4.598588f, 4.6440983f) || MathUtil.isInRange(sunAngle, 1.6390872f, 1.6845976f)) {
            skyLight = 8;
        } else if (MathUtil.isInRange(sunAngle, 4.6443815f, 4.689612f) || MathUtil.isInRange(sunAngle, 1.5938551f, 1.6388037f)) {
            skyLight = 9;
        } else if (MathUtil.isInRange(sunAngle, 4.6898937f, 4.735117f) || MathUtil.isInRange(sunAngle, 1.548349f, 1.5935733f)) {
            skyLight = 10;
        } else if (MathUtil.isInRange(sunAngle, 4.7353964f, 4.7805977f) || MathUtil.isInRange(sunAngle, 1.5028657f, 1.548069f)) {
            skyLight = 11;
        } else if (MathUtil.isInRange(sunAngle, 4.780876f, 4.826043f) || MathUtil.isInRange(sunAngle, 1.4571424f, 1.5025874f)) {
            skyLight = 12;
        } else if (MathUtil.isInRange(sunAngle, 4.826319f, 4.8719864f) || MathUtil.isInRange(sunAngle, 1.4111987f, 1.4568661f)) {
            skyLight = 13;
        } else if (MathUtil.isInRange(sunAngle, 4.8722606f, 4.9184027f) || MathUtil.isInRange(sunAngle, 1.3650552f, 1.4109247f)) {
            skyLight = 14;
        }
        return skyLight;
    }

    public static void onTillGrass(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        RandomSource random = level.m_213780_();
        boolean isGrass = level.m_8055_(context.m_8083_()).m_60713_(Blocks.f_50440_);
        boolean isHoeItem = context.m_43722_().m_41720_() instanceof HoeItem;
        boolean isFarmland = state.m_60713_(Blocks.f_50093_);
        if (!(ModConfig.Gameplay.tilledGrassSeeds() && isHoeItem && isGrass && isFarmland)) {
            return;
        }
        if (random.m_188503_(10) == 0) {
            ItemStack seedItem = new ItemStack((ItemLike)Items.f_42404_);
            BlockPos clickPos = context.m_8083_();
            double x = (double)clickPos.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05);
            double y = (double)clickPos.m_123342_() + 1.0;
            double z = (double)clickPos.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05);
            double dx = Mth.m_216263_((RandomSource)random, (double)-0.1, (double)0.1);
            double dy = Mth.m_216263_((RandomSource)random, (double)0.18, (double)0.2);
            double dz = Mth.m_216263_((RandomSource)random, (double)-0.1, (double)0.1);
            ItemEntity seedEntity = new ItemEntity(level, x, y, z, seedItem, dx, dy, dz);
            seedEntity.m_32060_();
            level.m_7967_((Entity)seedEntity);
        }
    }

    public static boolean isBonemealApplicable(BonemealableBlock block, Level level, RandomSource random, BlockPos pos, BlockState state) {
        return ModConfig.Gameplay.instantBonemeal() || block.m_214167_(level, random, pos, state);
    }
}

