/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.log;

import dev.architectury.platform.Platform;
import java.io.PrintWriter;
import java.io.StringWriter;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ModLogger(String prefix) {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean isDebugging = Platform.isDevelopmentEnvironment();

    public boolean isDebugMode() {
        return isDebugging;
    }

    public void setDebug(boolean state) {
        isDebugging = state;
    }

    private String getStartBracket() {
        return String.format("%s", LogColor.apply(LogColor.RESET, "["));
    }

    private String getPrefix() {
        return String.format("%s%s] ", this.getStartBracket(), LogColor.apply(LogColor.BLUE, this.prefix));
    }

    private String getOutput(String input) {
        input = input.replaceAll("true", LogColor.apply(LogColor.GREEN, "true"));
        input = input.replaceAll("false", LogColor.apply(LogColor.RED, "false"));
        for (LogColor color : LogColor.values()) {
            input = color.convert(input);
        }
        return input;
    }

    public void info(String message) {
        String input = String.format(this.getPrefix() + "[%s] " + message, LogColor.apply(LogColor.GREEN, "INFO"));
        LOGGER.info(this.getOutput(input));
    }

    public void info(String message, Object ... args) {
        this.info(String.format(message, args));
    }

    public void warn(String message) {
        String input = String.format(this.getPrefix() + "[%s] " + message, LogColor.apply(LogColor.GOLD, "WARN"));
        LOGGER.warn(this.getOutput(input));
    }

    public void warn(String message, Object ... args) {
        this.warn(String.format(message, args));
    }

    public void error(String message) {
        String input = String.format(this.getPrefix() + "[%s] " + message, LogColor.apply(LogColor.RED, "ERROR"));
        LOGGER.error(this.getOutput(input));
    }

    public void error(String message, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof Throwable)) continue;
            Throwable exception = (Throwable)arg;
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            exception.printStackTrace(printer);
            args[i] = writer.toString();
        }
        this.error(String.format(message, args));
    }

    public void debug(String message) {
        if (isDebugging) {
            String input = String.format(this.getPrefix() + "[%s] " + message, LogColor.apply(LogColor.LIGHT_PURPLE, "DEBUG"));
            LOGGER.info(this.getOutput(input));
        }
    }

    public void debug(String message, Object ... args) {
        if (isDebugging) {
            this.debug(String.format(message, args));
        }
    }
}

