/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.server;

import mod.adrenix.nostalgic.common.config.ModConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BlockServerUtil {
    public static boolean isClimbableWithinTwoBlocks(Level level, BlockPos pos) {
        boolean isBelowClimbable = level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13082_);
        boolean isBelowNextClimbable = level.m_8055_(pos.m_7495_().m_7495_()).m_204336_(BlockTags.f_13082_);
        return isBelowClimbable || isBelowNextClimbable;
    }

    public static boolean isClimbable(Level level, BlockState state, BlockPos pos) {
        boolean isClimbable = state.m_204336_(BlockTags.f_13082_);
        if (!ModConfig.Gameplay.oldLadderGap()) {
            return isClimbable;
        }
        if (state.m_60734_() instanceof TrapDoorBlock && ((Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue() && BlockServerUtil.isClimbableWithinTwoBlocks(level, pos)) {
            return true;
        }
        BlockPos posAbove = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(posAbove);
        boolean isAboveClimbable = stateAbove.m_204336_(BlockTags.f_13082_);
        if (stateAbove.m_60734_() instanceof TrapDoorBlock && ((Boolean)stateAbove.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue() && BlockServerUtil.isClimbableWithinTwoBlocks(level, posAbove)) {
            return true;
        }
        return isClimbable || isAboveClimbable;
    }
}

