/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.server;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.adrenix.nostalgic.common.config.ModConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public abstract class ItemServerUtil {
    public static boolean isDroppingLoot = false;
    private static final Map<Class<? extends TieredItem>, Function<TieredItem, Float>> OLD_DAMAGE = Map.of(SwordItem.class, item -> Float.valueOf(item.m_43314_().m_6631_() + 4.0f), AxeItem.class, item -> Float.valueOf(item.m_43314_().m_6631_() + 3.0f), PickaxeItem.class, item -> Float.valueOf(item.m_43314_().m_6631_() + 2.0f), ShovelItem.class, item -> Float.valueOf(item.m_43314_().m_6631_() + 1.0f), HoeItem.class, item -> Float.valueOf(item.m_43314_().m_6631_()));

    private static void split(ItemStack stack, Consumer<ItemStack> consumer) {
        int count = stack.m_41613_();
        if (count >= ModConfig.Candy.getItemMergeLimit()) {
            consumer.accept(stack);
        } else {
            ItemStack instance = stack.m_41777_();
            instance.m_41764_(1);
            for (int i = 0; i < count; ++i) {
                consumer.accept(instance);
            }
        }
    }

    public static Consumer<ItemStack> splitConsumer(Consumer<ItemStack> consumer) {
        return ModConfig.Candy.oldItemMerging() ? stack -> ItemServerUtil.split(stack, consumer) : consumer;
    }

    public static void splitLoot(CallbackInfo callback, Entity entity, ItemStack drop) {
        if (ModConfig.Candy.oldItemMerging()) {
            ItemServerUtil.split(drop, arg_0 -> ((Entity)entity).m_19983_(arg_0));
        } else {
            entity.m_19983_(drop);
        }
        isDroppingLoot = false;
        callback.cancel();
    }

    public static void mergeWithNeighbors(CallbackInfo callback, List<ItemEntity> entities, ItemEntity entity) {
        boolean isBelowLimit = entities.size() + 1 < ModConfig.Candy.getItemMergeLimit() && entity.m_32055_().m_41613_() == 1;
        boolean isNeighborStacked = false;
        for (ItemEntity neighbor : entities) {
            if (neighbor.m_32055_().m_41613_() <= 1) continue;
            isNeighborStacked = true;
        }
        if (ModConfig.Candy.oldItemMerging() && isBelowLimit && !isNeighborStacked) {
            callback.cancel();
        }
    }

    public static float getOldDamage(TieredItem item) {
        Class<?> tierClass = item.getClass();
        if (OLD_DAMAGE.containsKey(tierClass)) {
            return OLD_DAMAGE.get(tierClass).apply(item).floatValue();
        }
        return 0.0f;
    }

    public static boolean isVanillaTiered(TieredItem item) {
        return OLD_DAMAGE.containsKey(item.getClass());
    }
}

