/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.api.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class GenerationUtils {
    public static boolean isAir(LevelSimulatedReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof BlockGetter)) {
            return worldIn.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
        }
        return worldIn.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }

    public static <B extends BlockState> boolean isProperBlock(B blockState, Block[] validBlocks, boolean orSolid) {
        if (!Arrays.asList(validBlocks).contains(blockState.m_60734_()) && orSolid) {
            return blockState.m_60815_();
        }
        return Arrays.asList(validBlocks).contains(blockState.m_60734_());
    }

    public static void fillAreaWithBlockCube(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    mutable.m_122178_(xx, yy, zz);
                    if (!world.m_8055_((BlockPos)mutable).m_60767_().m_76336_()) continue;
                    world.m_7731_((BlockPos)mutable, block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    mutable.m_122178_(xx, yy, zz);
                    if (!world.m_8055_((BlockPos)mutable).m_60767_().m_76336_() || xx != x2 && zz != z2) continue;
                    world.m_7731_((BlockPos)mutable, block, 2);
                }
            }
        }
    }

    public static void forceFillAreaWithBlockCube(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    world.m_7731_((BlockPos)mutable.m_122178_(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void forceFillAreaReversedWithBlockCube(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx >= x2; --xx) {
                for (int zz = z1; zz >= z2; --zz) {
                    world.m_7731_((BlockPos)mutable.m_122178_(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillWithRandomTwoBlocksCube(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, Random rand, BlockState block, BlockState block2, float chance) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    mutable.m_122178_(xx, yy, zz);
                    if (!world.m_8055_((BlockPos)mutable).m_60767_().m_76336_()) continue;
                    if (rand.nextFloat() <= chance) {
                        world.m_7731_((BlockPos)mutable, block2, 2);
                        continue;
                    }
                    world.m_7731_((BlockPos)mutable, block, 2);
                }
            }
        }
    }

    public static boolean isAreaReplacable(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (world.m_8055_((BlockPos)mutable.m_122178_(xx, yy, zz)).m_60767_().m_76336_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAreaAir(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (world.m_46859_((BlockPos)mutable.m_122178_(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAreaCompletelySolid(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.m_8055_((BlockPos)mutable.m_122178_(xx, yy, zz)).m_60767_().m_76336_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockPos getClosestPositionToPos(List<BlockPos> positions, BlockPos pos) {
        double distance = -1.0;
        BlockPos currentPos = null;
        for (BlockPos listOfPositions : positions) {
            double newDistance = Vec3.m_82528_((Vec3i)pos).m_82557_(Vec3.m_82528_((Vec3i)listOfPositions));
            if (distance != -1.0 && !(newDistance < distance)) continue;
            distance = newDistance;
            currentPos = listOfPositions;
        }
        return currentPos;
    }
}

