/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.EndimatorModelPart;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorLayerDefinition;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorPartDefinition;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;

public class PuffBugModel<E extends PuffBug>
extends EndimatorEntityModel<E> {
    public static final ModelLayerLocation LOCATION = new ModelLayerLocation(new ResourceLocation("endergetic", "puff_bug"), "main");
    public EndimatorModelPart Body;
    public EndimatorModelPart Stinger;
    public EndimatorModelPart Neck;
    public EndimatorModelPart Head;
    public EndimatorModelPart Sensor1;
    public EndimatorModelPart Sensor2;
    public EndimatorModelPart BodyDeflated;
    public EndimatorModelPart StingerDeflated;
    public EndimatorModelPart NeckDeflated;
    public EndimatorModelPart HeadDeflated;
    public EndimatorModelPart Sensor1Deflated;
    public EndimatorModelPart Sensor2Deflated;
    public EndimatorModelPart BodyDeflatedProjectile;
    public EndimatorModelPart StingerDeflatedProjectile;
    public EndimatorModelPart NeckDeflatedProjectile;
    public EndimatorModelPart HeadDeflatedProjectile;
    public EndimatorModelPart Sensor1DeflatedProjectile;
    public EndimatorModelPart Sensor2DeflatedProjectile;

    public PuffBugModel(ModelPart root) {
        this.Body = (EndimatorModelPart)root.m_171324_("Body");
        this.Stinger = (EndimatorModelPart)this.Body.m_171324_("Stinger");
        this.Neck = (EndimatorModelPart)this.Body.m_171324_("Neck");
        this.Head = (EndimatorModelPart)this.Neck.m_171324_("Head");
        this.Sensor1 = (EndimatorModelPart)this.Head.m_171324_("Sensor1");
        this.Sensor2 = (EndimatorModelPart)this.Head.m_171324_("Sensor2");
        this.BodyDeflated = (EndimatorModelPart)root.m_171324_("BodyDeflated");
        this.StingerDeflated = (EndimatorModelPart)this.BodyDeflated.m_171324_("StingerDeflated");
        this.NeckDeflated = (EndimatorModelPart)this.BodyDeflated.m_171324_("NeckDeflated");
        this.HeadDeflated = (EndimatorModelPart)this.NeckDeflated.m_171324_("HeadDeflated");
        this.Sensor1Deflated = (EndimatorModelPart)this.HeadDeflated.m_171324_("Sensor1Deflated");
        this.Sensor2Deflated = (EndimatorModelPart)this.HeadDeflated.m_171324_("Sensor2Deflated");
        this.BodyDeflatedProjectile = (EndimatorModelPart)root.m_171324_("BodyDeflatedProjectile");
        this.StingerDeflatedProjectile = (EndimatorModelPart)this.BodyDeflatedProjectile.m_171324_("StingerDeflatedProjectile");
        this.NeckDeflatedProjectile = (EndimatorModelPart)this.BodyDeflatedProjectile.m_171324_("NeckDeflatedProjectile");
        this.HeadDeflatedProjectile = (EndimatorModelPart)this.NeckDeflatedProjectile.m_171324_("HeadDeflatedProjectile");
        this.Sensor1DeflatedProjectile = (EndimatorModelPart)this.HeadDeflatedProjectile.m_171324_("Sensor1DeflatedProjectile");
        this.Sensor2DeflatedProjectile = (EndimatorModelPart)this.HeadDeflatedProjectile.m_171324_("Sensor2DeflatedProjectile");
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public static EndimatorLayerDefinition createLayerDefinition() {
        EndimatorPartDefinition root = EndimatorPartDefinition.root();
        EndimatorPartDefinition Body = root.addOrReplaceChild("Body", CubeListBuilder.m_171558_().m_171514_(8, 3).m_171506_(-3.0f, -3.5f, -3.0f, 6.0f, 7.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.045553092f, (float)0.0f));
        EndimatorPartDefinition Stinger = Body.addOrReplaceChild("Stinger", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171506_(0.0f, -4.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)-0.5f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition Neck = Body.addOrReplaceChild("Neck", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)0.0f, (float)-0.13665928f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.0f, 0.0f, -1.5f, 4.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)3.7f, (float)0.0f, (float)-0.13665928f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition Sensor1 = Head.addOrReplaceChild("Sensor1", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171506_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)-2.0f, (float)3.0f, (float)0.5f, (float)0.0f, (float)1.5707964f, (float)0.7330383f));
        EndimatorPartDefinition Sensor2 = Head.addOrReplaceChild("Sensor2", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171506_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)2.0f, (float)3.0f, (float)0.5f, (float)0.7330383f, (float)1.5707964f, (float)0.0f));
        EndimatorPartDefinition BodyDeflated = root.addOrReplaceChild("BodyDeflated", CubeListBuilder.m_171558_().m_171514_(10, 7).m_171506_(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition StingerDeflated = BodyDeflated.addOrReplaceChild("StingerDeflated", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171506_(-0.5f, -4.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition NeckDeflated = BodyDeflated.addOrReplaceChild("NeckDeflated", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.13962634f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition HeadDeflated = NeckDeflated.addOrReplaceChild("HeadDeflated", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.0f, 0.0f, -1.5f, 4.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)3.7f, (float)0.0f, (float)-0.13962634f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition Sensor1Deflated = HeadDeflated.addOrReplaceChild("Sensor1Deflated", CubeListBuilder.m_171558_().m_171514_(18, 1).m_171506_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)-2.0f, (float)3.0f, (float)0.5f, (float)0.0f, (float)1.5707964f, (float)0.7330383f));
        EndimatorPartDefinition Sensor2Deflated = HeadDeflated.addOrReplaceChild("Sensor2Deflated", CubeListBuilder.m_171558_().m_171514_(18, 1).m_171506_(-0.1f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)2.0f, (float)3.0f, (float)0.5f, (float)0.7330383f, (float)1.5707964f, (float)0.0f));
        EndimatorPartDefinition BodyDeflatedProjectile = root.addOrReplaceChild("BodyDeflatedProjectile", CubeListBuilder.m_171558_().m_171514_(10, 7).m_171506_(-1.0f, 0.5f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition StingerDeflatedProjectile = BodyDeflatedProjectile.addOrReplaceChild("StingerDeflatedProjectile", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171506_(-0.5f, -4.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition NeckDeflatedProjectile = BodyDeflatedProjectile.addOrReplaceChild("NeckDeflatedProjectile", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)6.5f, (float)0.0f, (float)-0.13665928f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition HeadDeflatedProjectile = NeckDeflatedProjectile.addOrReplaceChild("HeadDeflatedProjectile", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.0f, 0.0f, -1.5f, 4.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)3.7f, (float)0.0f, (float)-0.13962634f, (float)0.0f, (float)0.0f));
        EndimatorPartDefinition Sensor1DeflatedProjectile = HeadDeflatedProjectile.addOrReplaceChild("Sensor1DeflatedProjectile", CubeListBuilder.m_171558_().m_171514_(18, 1).m_171506_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)-2.0f, (float)3.0f, (float)0.5f, (float)0.0f, (float)1.5707964f, (float)0.7330383f));
        EndimatorPartDefinition Sensor2DeflatedProjectile = HeadDeflatedProjectile.addOrReplaceChild("Sensor2DeflatedProjectile", CubeListBuilder.m_171558_().m_171514_(18, 1).m_171506_(-0.1f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)2.0f, (float)3.0f, (float)0.5f, (float)0.7330383f, (float)1.5707964f, (float)0.08726646f));
        return new EndimatorLayerDefinition(root, 32, 16);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Entity ridingEntity = ((PuffBug)this.entity).m_20202_();
        if (ridingEntity instanceof Booflo && (!((Booflo)ridingEntity).isEndimationPlaying(EEPlayableEndimations.BOOFLO_EAT) || ((Booflo)ridingEntity).getAnimationTick() < 20)) {
            return;
        }
        if (!((PuffBug)this.entity).isInflated() && ((PuffBug)this.entity).stuckInBlock) {
            packedLightIn = this.getPackedLightForStuck((PuffBug)this.entity);
        }
        if (((PuffBug)this.entity).isInflated()) {
            this.Body.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        } else if (((PuffBug)this.entity).isProjectile()) {
            this.BodyDeflatedProjectile.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        } else {
            this.BodyDeflated.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    private int getPackedLightForStuck(PuffBug puffbug) {
        float partialTicks = ClientInfo.getPartialTicks();
        return LightTexture.m_109885_((int)(puffbug.m_6060_() ? 15 : puffbug.f_19853_.m_45517_(LightLayer.BLOCK, this.getStuckLightPos(puffbug, partialTicks))), (int)((PuffBug)this.entity).f_19853_.m_45517_(LightLayer.SKY, this.getStuckLightPos(puffbug, partialTicks)));
    }

    private BlockPos getStuckLightPos(PuffBug puffbug, float partialTicks) {
        Direction verticalOffset;
        BlockPos blockpos = new BlockPos(puffbug.m_20185_(), puffbug.m_20186_() + (double)puffbug.m_20192_(), puffbug.m_20185_());
        boolean rotationFlag = true;
        float[] rotations = puffbug.getRotationController().getRotations(partialTicks);
        Direction horizontalOffset = Direction.m_122364_((double)rotations[0]).m_122424_();
        Direction direction = verticalOffset = rotations[1] <= 180.0f && rotations[1] > 100.0f ? Direction.UP : Direction.DOWN;
        if (rotations[1] >= 80.0f && rotations[1] <= 100.0f) {
            rotationFlag = false;
        }
        return rotationFlag ? blockpos.m_121945_(horizontalOffset).m_121945_(verticalOffset) : blockpos.m_121945_(horizontalOffset);
    }

    public void setupAnim(E puffBug, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(puffBug, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.Body.setShouldScaleChildren(puffBug.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_TO) || puffBug.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_FROM));
        if (!puffBug.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_PUFF) && !puffBug.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_POLLINATE)) {
            float angle = 0.1f * Mth.m_14031_((float)(0.25f * ageInTicks));
            this.Sensor1.f_104205_ += angle;
            this.Sensor2.f_104203_ += angle;
        }
        if (!puffBug.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_FLY)) {
            this.Head.f_104203_ += 0.075f * Mth.m_14031_((float)(0.1f * ageInTicks));
            this.HeadDeflated.f_104203_ = this.Head.f_104203_;
        }
        float partialTicks = ClientInfo.getPartialTicks();
        float[] rotations = ((PuffBug)((Object)puffBug)).getRotationController().getRotations(partialTicks);
        this.Body.f_104204_ = rotations[0] * ((float)Math.PI / 180);
        this.Body.f_104203_ = rotations[1] * ((float)Math.PI / 180);
        if (puffBug.m_20159_()) {
            this.Body.f_104205_ = 1.57f;
        }
        this.BodyDeflated.f_104204_ = this.Body.f_104204_;
        this.BodyDeflated.f_104203_ = this.Body.f_104203_;
        this.BodyDeflatedProjectile.f_104204_ = this.Body.f_104204_;
        this.BodyDeflatedProjectile.f_104203_ = this.Body.f_104203_;
        this.NeckDeflated.f_104203_ += -0.56f * ((PuffBug)((Object)puffBug)).HIVE_LANDING.getProgress(partialTicks);
        this.HeadDeflated.f_104203_ += -0.42f * ((PuffBug)((Object)puffBug)).HIVE_LANDING.getProgress(partialTicks);
        this.Sensor1Deflated.f_104205_ += 1.7f * ((PuffBug)((Object)puffBug)).HIVE_LANDING.getProgress(partialTicks);
        this.Sensor2Deflated.f_104203_ += 1.7f * ((PuffBug)((Object)puffBug)).HIVE_LANDING.getProgress(partialTicks);
        this.NeckDeflated.f_104203_ += 0.3f * ((PuffBug)((Object)puffBug)).HIVE_SLEEP.getProgress(partialTicks);
        this.HeadDeflated.f_104203_ += 0.25f * ((PuffBug)((Object)puffBug)).HIVE_SLEEP.getProgress(partialTicks);
        this.Neck.f_104203_ = this.HeadDeflated.f_104203_;
        this.Head.f_104203_ = this.HeadDeflated.f_104203_;
        this.Sensor1.f_104205_ = this.Sensor1Deflated.f_104205_;
        this.Sensor2.f_104203_ = this.Sensor2Deflated.f_104203_;
        if (((PuffBug)((Object)puffBug)).isProjectile()) {
            this.Neck.f_104204_ = 0.0f;
            this.NeckDeflated.f_104204_ = 0.0f;
            this.Sensor1Deflated.f_104203_ = 0.7f;
            this.Sensor1Deflated.f_104204_ = 0.7f;
            this.Sensor1Deflated.f_104205_ = 0.09f;
            this.Sensor2Deflated.f_104203_ = 0.32f;
            this.Sensor2Deflated.f_104204_ = -2.64f;
            this.Sensor2Deflated.f_104205_ = 0.09f;
            float spin = Mth.m_14179_((float)ClientInfo.getPartialTicks(), (float)((PuffBug)((Object)puffBug)).prevSpin, (float)((PuffBug)((Object)puffBug)).spin);
            this.NeckDeflatedProjectile.f_104204_ = (float)((double)this.NeckDeflatedProjectile.f_104204_ + Math.toRadians(spin));
            this.StingerDeflatedProjectile.f_104204_ = (float)((double)this.StingerDeflatedProjectile.f_104204_ + Math.toRadians(spin));
        }
    }
}

