/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.model.eetle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.endergetic.common.entity.eetle.GliderEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.FlyingRotations;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class GliderEetleModel
extends EndimatorEntityModel<GliderEetle> {
    public static final ModelLayerLocation LOCATION = new ModelLayerLocation(new ResourceLocation("endergetic", "glider_eetle"), "main");
    private static final float WING_SHOW_THRESHOLD = (float)Math.toRadians(9.0);
    public ModelPart body;
    public ModelPart rightElytron;
    public ModelPart leftElytron;
    public ModelPart leftWing;
    public ModelPart rightWing;
    public ModelPart head;
    public ModelPart leftBackLeg;
    public ModelPart rightBackLeg;
    public ModelPart rightFrontLeg;
    public ModelPart leftFrontLeg;
    public ModelPart leftMandible;
    public ModelPart rightMandible;

    public GliderEetleModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.rightElytron = this.body.m_171324_("rightElytron");
        this.leftElytron = this.body.m_171324_("leftElytron");
        this.leftWing = this.body.m_171324_("leftWing");
        this.rightWing = this.body.m_171324_("rightWing");
        this.head = this.body.m_171324_("head");
        this.leftBackLeg = this.body.m_171324_("leftBackLeg");
        this.rightBackLeg = this.body.m_171324_("rightBackLeg");
        this.rightFrontLeg = this.body.m_171324_("rightFrontLeg");
        this.leftFrontLeg = this.body.m_171324_("leftFrontLeg");
        this.leftMandible = this.head.m_171324_("leftMandible");
        this.rightMandible = this.head.m_171324_("rightMandible");
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(28, 16).m_171506_(-4.0f, -3.0f, 0.0f, 8.0f, 6.0f, 10.0f, false), PartPose.m_171423_((float)0.0f, (float)13.3f, (float)-4.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition rightElytron = body.m_171599_("rightElytron", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-5.0f, -1.0f, -1.0f, 5.0f, 6.0f, 12.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)((float)(-Math.PI) / 90), (float)0.0f));
        PartDefinition leftElytron = body.m_171599_("leftElytron", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(0.0f, -1.0f, -1.0f, 5.0f, 6.0f, 12.0f, true), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI / 90), (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171506_(0.0f, 0.0f, 0.0f, 7.0f, 0.0f, 16.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171506_(-7.0f, 0.0f, 0.0f, 7.0f, 0.0f, 16.0f, true), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171506_(-3.0f, -2.0f, -5.0f, 6.0f, 4.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg = body.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171506_(0.0f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, true), PartPose.m_171423_((float)1.9f, (float)1.0f, (float)8.0f, (float)0.61086524f, (float)0.0f, (float)-0.7853982f));
        PartDefinition rightBackLeg = body.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171506_(-3.0f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, true), PartPose.m_171423_((float)-1.9f, (float)1.0f, (float)8.0f, (float)0.61086524f, (float)0.0f, (float)0.7853982f));
        PartDefinition rightFrontLeg = body.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171506_(-3.0f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, true), PartPose.m_171423_((float)-2.0f, (float)2.5f, (float)2.0f, (float)-0.2617994f, (float)0.0f, (float)0.7853982f));
        PartDefinition leftFrontLeg = body.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171506_(0.0f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, true), PartPose.m_171423_((float)2.0f, (float)2.5f, (float)2.0f, (float)-0.2617994f, (float)0.0f, (float)-0.7853982f));
        PartDefinition leftMandible = head.m_171599_("leftMandible", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171506_(0.0f, 0.0f, -6.0f, 5.0f, 0.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightMandible = head.m_171599_("rightMandible", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171506_(-5.0f, 0.0f, -6.0f, 5.0f, 0.0f, 6.0f, true), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(GliderEetle entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        FlyingRotations flyingRotations = entity.getFlyingRotations();
        float flyingProgress = entity.getFlyingProgress();
        this.body.f_104203_ += flyingRotations.getRenderFlyPitch() * ((float)Math.PI / 180);
        this.head.f_104203_ += 0.52f * flyingProgress;
        if (entity.isFlying()) {
            this.body.f_104205_ = flyingRotations.getRenderFlyRoll() * ((float)Math.PI / 180);
        }
        float frontLegFlying = 0.87f * flyingProgress;
        this.leftFrontLeg.f_104203_ += frontLegFlying;
        this.rightFrontLeg.f_104203_ += frontLegFlying;
        float backLegFlying = 0.7f * flyingProgress;
        this.leftBackLeg.f_104203_ += backLegFlying;
        this.rightBackLeg.f_104203_ += backLegFlying;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
        float takeOffProgress = entity.getTakeoffProgress();
        float elytronZ = 0.35f * takeOffProgress;
        this.leftElytron.f_104205_ += -elytronZ;
        this.rightElytron.f_104205_ += elytronZ;
        float elytronY = 1.22f * takeOffProgress;
        this.leftElytron.f_104204_ += elytronY;
        this.rightElytron.f_104204_ += -elytronY;
        float wingY = 0.52f * takeOffProgress;
        this.leftWing.f_104204_ += wingY;
        this.rightWing.f_104204_ += -wingY;
        if (entity.isFlying()) {
            float wingX = 0.1f * Mth.m_14031_((float)(8.0f * entity.getWingFlap())) + 0.15f;
            this.leftWing.f_104203_ += wingX;
            this.rightWing.f_104203_ += wingX;
            float frontLegMoving = Math.abs(Mth.m_14089_((float)(limbSwing * 0.3f))) * 0.28f * limbSwingAmount;
            this.leftFrontLeg.f_104203_ -= frontLegMoving;
            this.rightFrontLeg.f_104203_ -= frontLegMoving;
            float backLegMoving = Math.abs(Mth.m_14031_((float)(limbSwing * 0.3f))) * 0.28f * limbSwingAmount;
            this.leftBackLeg.f_104203_ += backLegMoving;
            this.rightBackLeg.f_104203_ += backLegMoving;
        } else {
            float angleX = Mth.m_14089_((float)(limbSwing * 1.34f + 4.712389f)) * limbSwingAmount;
            float backAngleX = Mth.m_14089_((float)(limbSwing * 1.34f)) * limbSwingAmount;
            this.leftFrontLeg.f_104203_ -= angleX;
            this.rightFrontLeg.f_104203_ += angleX;
            this.leftBackLeg.f_104203_ += backAngleX;
            this.rightBackLeg.f_104203_ -= backAngleX;
            float angleZ = Math.abs(Mth.m_14031_((float)(limbSwing * 0.67f + 4.712389f))) * 0.5f * limbSwingAmount;
            float backAngleZ = Math.abs(Mth.m_14031_((float)(limbSwing * 0.67f))) * 0.5f * limbSwingAmount;
            this.leftFrontLeg.f_104205_ -= angleZ;
            this.rightFrontLeg.f_104205_ += angleZ;
            this.leftBackLeg.f_104205_ -= backAngleZ;
            this.rightBackLeg.f_104205_ += backAngleZ;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.leftWing.f_104207_ = this.leftWing.f_104204_ >= WING_SHOW_THRESHOLD;
        this.rightWing.f_104207_ = this.rightWing.f_104204_ <= -WING_SHOW_THRESHOLD;
        this.body.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

