/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamabnormals.endergetic.client.model.eetle.eggs.IEetleEggModel;
import com.teamabnormals.endergetic.client.model.eetle.eggs.LargeEetleEggModel;
import com.teamabnormals.endergetic.client.model.eetle.eggs.MediumEetleEggModel;
import com.teamabnormals.endergetic.client.model.eetle.eggs.SmallEetleEggModel;
import com.teamabnormals.endergetic.common.block.EetleEggBlock;
import com.teamabnormals.endergetic.common.block.entity.EetleEggTileEntity;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.other.EERenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EetleEggTileEntityRenderer
implements BlockEntityRenderer<EetleEggTileEntity> {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("endergetic", "textures/tile/eggs/small_eetle_egg.png"), new ResourceLocation("endergetic", "textures/tile/eggs/medium_eetle_egg.png"), new ResourceLocation("endergetic", "textures/tile/eggs/large_eetle_egg.png")};
    private static final BlockState DEFAULT_STATE = ((Block)EEBlocks.EETLE_EGG.get()).m_49966_();
    private static final RandomSource ROTATION_RANDOM = RandomSource.m_216327_();
    private final IEetleEggModel[] eggModels;

    public EetleEggTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.eggModels = new IEetleEggModel[]{new SmallEetleEggModel(context.m_173582_(SmallEetleEggModel.LOCATION)), new MediumEetleEggModel(context.m_173582_(MediumEetleEggModel.LOCATION)), new LargeEetleEggModel(context.m_173582_(LargeEetleEggModel.LOCATION))};
    }

    public void render(EetleEggTileEntity eggs, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = eggs.m_58904_();
        BlockState state = DEFAULT_STATE;
        Direction randomDirection = Direction.NORTH;
        if (world != null) {
            state = eggs.m_58900_();
            ROTATION_RANDOM.m_188584_(EetleEggTileEntityRenderer.getPosSeed(eggs.m_58899_()));
            randomDirection = Direction.Plane.HORIZONTAL.m_235690_(ROTATION_RANDOM);
        }
        matrixStack.m_85836_();
        Direction facing = (Direction)state.m_61143_((Property)EetleEggBlock.FACING);
        switch (facing) {
            case UP: {
                matrixStack.m_85837_(0.5, 1.5, 0.5);
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                break;
            }
            case DOWN: {
                matrixStack.m_85837_(0.5, -0.5, 0.5);
                break;
            }
            default: {
                matrixStack.m_85837_((double)(0.5f + (float)facing.m_122429_()), 0.5, (double)(0.5f + (float)facing.m_122431_()));
                matrixStack.m_85845_((facing.m_122434_() == Direction.Axis.X ? Vector3f.f_122227_ : Vector3f.f_122222_).m_122240_(90.0f * (float)facing.m_122421_().m_122540_()));
            }
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(randomDirection.m_122435_()));
        int size = (Integer)state.m_61143_((Property)EetleEggBlock.SIZE);
        IEetleEggModel eggsModel = this.eggModels[size];
        eggsModel.render(matrixStack, buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURES[size])), combinedLight, combinedOverlay, partialTicks, eggs.getSackGrowths());
        eggsModel.renderSilk(matrixStack, buffer.m_6299_(EERenderTypes.EETLE_EGG_SILK), combinedLight, combinedOverlay);
        matrixStack.m_85849_();
    }

    private static long getPosSeed(BlockPos pos) {
        return 825276691L + ((long)pos.m_123341_() * 73856093L ^ (long)pos.m_123342_() * 19349663L ^ (long)pos.m_123343_() * 83492791L);
    }

    public int m_142163_() {
        return 256;
    }
}

