/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.entity.booflo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.blueprint.client.EntitySkinHelper;
import com.teamabnormals.endergetic.client.model.booflo.BoofloModel;
import com.teamabnormals.endergetic.client.renderer.entity.layers.BoofloEmissiveLayer;
import com.teamabnormals.endergetic.client.renderer.entity.layers.LayerRendererBoofloBracelets;
import com.teamabnormals.endergetic.client.renderer.entity.layers.LayerRendererBoofloFruit;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoofloRenderer
extends MobRenderer<Booflo, EntityModel<Booflo>> {
    private static final ResourceLocation DEFAULT = new ResourceLocation("endergetic", "textures/entity/booflo/booflo.png");
    private static final EntitySkinHelper<Booflo> SKIN_HELPER = EntitySkinHelper.create((String)"endergetic", (String)"textures/entity/booflo/", (String)"booflo", skinHelper -> {
        skinHelper.putSkins("snake", new String[]{"snake", "snake block", "the forsaken one"});
        skinHelper.putSkins("cam", new String[]{"cameron", "cam"});
    });

    public BoofloRenderer(EntityRendererProvider.Context context) {
        super(context, new BoofloModel(context.m_174023_(BoofloModel.LOCATION)), 1.25f);
        this.m_115326_(new BoofloEmissiveLayer(this));
        this.m_115326_(new LayerRendererBoofloBracelets(this));
        this.m_115326_(new LayerRendererBoofloFruit((RenderLayerParent<Booflo, EntityModel<Booflo>>)this, context.m_234598_()));
    }

    public void render(Booflo booflo, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.f_114477_ = booflo.isBoofed() ? 2.0f : 1.25f;
        super.m_7392_((Mob)booflo, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(Booflo booflo) {
        return SKIN_HELPER.getSkinForEntityOrElse((Entity)booflo, DEFAULT);
    }
}

