/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.core.registry.EEItems;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerRendererBoofloFruit
extends RenderLayer<Booflo, EntityModel<Booflo>> {
    private final ItemInHandRenderer itemInHandRenderer;

    public LayerRendererBoofloFruit(RenderLayerParent<Booflo, EntityModel<Booflo>> renderer, ItemInHandRenderer itemInHandRenderer) {
        super(renderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, Booflo booflo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (booflo.hasCaughtFruit() && !booflo.isBoofed() && booflo.isEndimationPlaying(EEPlayableEndimations.BOOFLO_EAT) && booflo.getAnimationTick() > 20) {
            matrixStack.m_85836_();
            Vec3 fruitPos = new Vec3(-1.25, 0.0, 0.0).m_82524_(-netHeadYaw * ((float)Math.PI / 180) - 1.5707964f);
            matrixStack.m_85837_(fruitPos.m_7096_(), fruitPos.m_7098_() + (double)1.15f + (double)this.getFruitPosOffset(booflo), fruitPos.m_7094_());
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            matrixStack.m_85841_(1.3f, 1.3f, 1.3f);
            this.itemInHandRenderer.m_109322_((LivingEntity)booflo, new ItemStack((ItemLike)EEItems.BOLLOOM_FRUIT.get()), ItemTransforms.TransformType.GROUND, false, matrixStack, bufferIn, packedLightIn);
            matrixStack.m_85849_();
        }
    }

    private float getFruitPosOffset(Booflo booflo) {
        return 0.22f * Booflo.getEatingOffsetProgress((float)booflo.getAnimationTick() + ClientInfo.getPartialTicks());
    }
}

