/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.endergetic.common.block.CorrockBlock;
import com.teamabnormals.endergetic.common.block.EetleEggBlock;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.other.EEEvents;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class InfestedCorrockBlock
extends Block {
    private static final Direction[] POSSIBLE_DIRECTIONS = Direction.values();
    private static final Map<ResourceLocation, Supplier<Block>> CONVERSIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), conversions -> {
        conversions.put(BuiltinDimensionTypes.f_223538_.m_135782_(), EEBlocks.CORROCK_OVERWORLD_BLOCK);
        conversions.put(BuiltinDimensionTypes.f_223539_.m_135782_(), EEBlocks.CORROCK_NETHER_BLOCK);
        conversions.put(BuiltinDimensionTypes.f_223540_.m_135782_(), EEBlocks.INFESTED_CORROCK);
    });

    public InfestedCorrockBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        Block conversion = this.getConversionBlock((LevelAccessor)level);
        if (conversion != this) {
            level.m_46597_(pos, conversion.m_49966_());
            return;
        }
        if (level.isAreaLoaded(pos, 1) && rand.m_188501_() <= 0.02f) {
            EetleEggBlock.shuffleDirections(POSSIBLE_DIRECTIONS, rand);
            boolean grewNewEgg = false;
            Block eetleEggs = (Block)EEBlocks.EETLE_EGG.get();
            for (Direction direction : POSSIBLE_DIRECTIONS) {
                int size;
                BlockPos offset = pos.m_121945_(direction);
                if (!grewNewEgg && level.m_46859_(offset)) {
                    grewNewEgg = true;
                    level.m_46597_(offset, (BlockState)eetleEggs.m_49966_().m_61124_((Property)EetleEggBlock.FACING, (Comparable)direction));
                    continue;
                }
                BlockState offsetState = level.m_8055_(offset);
                if (offsetState.m_60734_() != eetleEggs || !(rand.m_188501_() <= 0.25f) || (size = ((Integer)offsetState.m_61143_((Property)EetleEggBlock.SIZE)).intValue()) >= 2) continue;
                level.m_46597_(offset, (BlockState)offsetState.m_61124_((Property)EetleEggBlock.SIZE, (Comparable)Integer.valueOf(size + 1)));
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.shouldConvert(worldIn)) {
            worldIn.m_186460_(currentPos, (Block)this, 40 + worldIn.m_213780_().m_188503_(40));
        }
        if (CorrockBlock.isSubmerged(worldIn, currentPos)) {
            return EEEvents.convertCorrockBlock(state);
        }
        return state;
    }

    protected Block getConversionBlock(LevelAccessor level) {
        return (Block)((Supplier)CONVERSIONS.getOrDefault(((Registry)level.m_5962_().m_6632_(Registry.f_122818_).get()).m_7981_((Object)level.m_6042_()), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD_BLOCK)).get();
    }

    protected boolean shouldConvert(LevelAccessor level) {
        return this.getConversionBlock(level) != this;
    }
}

