/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.endergetic.common.block.CorrockBlock;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.other.EEEvents;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class SpeckledCorrockBlock
extends Block {
    private static final Map<ResourceLocation, Supplier<Block>> CONVERSIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), conversions -> {
        conversions.put(BuiltinDimensionTypes.f_223538_.m_135782_(), EEBlocks.SPECKLED_OVERWORLD_CORROCK);
        conversions.put(BuiltinDimensionTypes.f_223539_.m_135782_(), EEBlocks.SPECKLED_NETHER_CORROCK);
        conversions.put(BuiltinDimensionTypes.f_223540_.m_135782_(), EEBlocks.SPECKLED_END_CORROCK);
    });

    public SpeckledCorrockBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Block conversion = this.getConversionBlock((LevelAccessor)level);
        if (conversion != this) {
            level.m_46597_(pos, conversion.m_49966_());
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.shouldConvert(worldIn)) {
            worldIn.m_186460_(currentPos, (Block)this, 60 + worldIn.m_213780_().m_188503_(40));
        }
        if (CorrockBlock.isSubmerged(worldIn, currentPos)) {
            return EEEvents.convertCorrockBlock(stateIn);
        }
        return stateIn;
    }

    protected Block getConversionBlock(LevelAccessor level) {
        return (Block)((Supplier)CONVERSIONS.getOrDefault(((Registry)level.m_5962_().m_6632_(Registry.f_122818_).get()).m_7981_((Object)level.m_6042_()), (Supplier<Block>)EEBlocks.SPECKLED_OVERWORLD_CORROCK)).get();
    }

    protected boolean shouldConvert(LevelAccessor level) {
        return this.getConversionBlock(level) != this;
    }
}

