/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block.poise;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import com.teamabnormals.endergetic.common.block.poise.GlowingPoiseStemBlock;
import com.teamabnormals.endergetic.common.levelgen.feature.PoiseTreeFeature;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import com.teamabnormals.endergetic.core.registry.other.tags.EEBlockTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class PoiseTallBushBlock
extends Block
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final IntegerProperty STAGE = BlockStateProperties.f_61387_;

    public PoiseTallBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level world, BlockPos pos, RandomSource rand) {
        if (stateIn.m_61143_(HALF) == DoubleBlockHalf.LOWER || rand.m_188501_() > 0.2f) {
            return;
        }
        double offsetX = GlowingPoiseStemBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
        double offsetZ = GlowingPoiseStemBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
        double x = (double)pos.m_123341_() + 0.5 + offsetX;
        double y = (double)pos.m_123342_() + 0.95 + (double)(rand.m_188501_() * 0.05f);
        double z = (double)pos.m_123343_() + 0.5 + offsetZ;
        world.m_7106_((ParticleOptions)EEParticleTypes.POISE_BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
        if (rand.m_188503_(8) == 0) {
            float rngFloat = rand.m_188501_();
            SoundEvent soundToPlay = rngFloat > 0.9f ? (SoundEvent)EESoundEvents.POISE_BUSH_AMBIENT_LONG.get() : (SoundEvent)EESoundEvents.POISE_BUSH_AMBIENT.get();
            float volume = rngFloat < 0.9f ? 0.1f + rand.m_188501_() * 0.075f : 0.05f + rand.m_188501_() * 0.05f;
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundToPlay, SoundSource.BLOCKS, volume, 0.9f + rand.m_188501_() * 0.15f, false);
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return (Integer)state.m_61143_((Property)STAGE) <= 0;
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(EEBlockTags.POISE_PLANTABLE) || state.m_204336_(EEBlockTags.END_PLANTABLE);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (facing.m_122434_() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.m_60734_() == this && facingState.m_61143_(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        return blockpos.m_123342_() < context.m_43725_().m_151558_() - 1 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context) ? super.m_5573_(context) : null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return this.isValidGround(worldIn.m_8055_(pos.m_7495_()), (BlockGetter)worldIn, pos);
        }
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            this.isValidGround(worldIn.m_8055_(pos.m_7495_()), (BlockGetter)worldIn, pos);
        }
        return blockstate.m_60734_() == this && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public void placeAt(LevelAccessor p_196390_1_, BlockPos p_196390_2_, int flags) {
        p_196390_1_.m_7731_(p_196390_2_, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        p_196390_1_.m_7731_(p_196390_2_.m_7494_(), (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (blockstate.m_60734_() == this && blockstate.m_61143_(HALF) != doubleblockhalf) {
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
            if (!worldIn.f_46443_ && !player.m_7500_()) {
                PoiseTallBushBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                PoiseTallBushBlock.m_49881_((BlockState)blockstate, (Level)worldIn, (BlockPos)blockpos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, STAGE});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return rand.m_188501_() <= 0.35f;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        this.grow(level, pos, state, rand);
    }

    public void grow(ServerLevel worldIn, BlockPos pos, BlockState state, RandomSource rand) {
        if ((Integer)state.m_61143_((Property)STAGE) == 0) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((LevelAccessor)worldIn, (RandomSource)rand, (BlockPos)pos)) {
                return;
            }
            BlockPos treePos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
            new PoiseTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_).m_225028_((FeatureConfiguration)FeatureConfiguration.f_67737_, (WorldGenLevel)worldIn, worldIn.m_7726_().m_8481_(), rand, treePos);
        }
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        ItemStackUtil.fillAfterItemForCategory((Item)this.m_5456_(), (Item)Items.f_42211_, (CreativeModeTab)group, items);
    }
}

