/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.bolloom;

import com.teamabnormals.endergetic.common.block.poise.BolloomBudBlock;
import com.teamabnormals.endergetic.common.entity.bolloom.AbstractBolloom;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PlayMessages;

public class BolloomFruit
extends AbstractBolloom {
    private static final EntityDataAccessor<BlockPos> BUD_POS = SynchedEntityData.m_135353_(BolloomFruit.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> VINE_HEIGHT = SynchedEntityData.m_135353_(BolloomFruit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BolloomFruit(EntityType<? extends BolloomFruit> type, Level world) {
        super((EntityType)EEEntityTypes.BOLLOOM_FRUIT.get(), world);
        this.m_20242_(true);
    }

    public BolloomFruit(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends BolloomFruit>)((EntityType)EEEntityTypes.BOLLOOM_FRUIT.get()), world);
    }

    public BolloomFruit(Level world, BlockPos budPos, BlockPos origin, int height, Direction direction) {
        this((EntityType<? extends BolloomFruit>)((EntityType)EEEntityTypes.BOLLOOM_FRUIT.get()), world);
        float xPos = (float)origin.m_123341_() + 0.5f + 0.8125f * (float)direction.m_122429_();
        float zPos = (float)origin.m_123343_() + 0.5f + 0.8125f * (float)direction.m_122431_();
        float yPos = (float)origin.m_123342_() + 1.15f;
        this.m_6034_(xPos, yPos, zPos);
        this.setOrigin(xPos, yPos, zPos);
        this.setBudPos(budPos);
        this.setVineHeight(height);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VINE_HEIGHT, (Object)1);
        this.f_19804_.m_135372_(BUD_POS, (Object)BlockPos.f_121853_);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128356_("BudPosition", this.getBudPos().m_121878_());
        compound.m_128405_("VineHeight", this.getVineHeight());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBudPos(BlockPos.m_122022_((long)compound.m_128454_("BudPosition")));
        if (compound.m_128425_("VineHeight", 3)) {
            this.setVineHeight(compound.m_128451_("VineHeight"));
        } else {
            this.setVineHeight(1);
        }
    }

    private void setBudPos(BlockPos budPos) {
        this.f_19804_.m_135381_(BUD_POS, (Object)budPos);
    }

    private BlockPos getBudPos() {
        return (BlockPos)this.f_19804_.m_135370_(BUD_POS);
    }

    @Override
    public float getVineXRot() {
        return (float)Math.atan(this.getSway() / (float)this.getVineHeight());
    }

    public void setVineHeight(int height) {
        this.f_19804_.m_135381_(VINE_HEIGHT, (Object)height);
    }

    public int getVineHeight() {
        return (Integer)this.f_19804_.m_135370_(VINE_HEIGHT);
    }

    @Override
    public void updatePositionAndMotion(double angleX, double angleZ) {
        if (!this.isUntied()) {
            float sway = this.getSway();
            this.m_6034_((double)this.getOriginX() + (double)sway * angleX, this.getOriginY(), (double)this.getOriginZ() + (double)sway * angleZ);
        } else {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20334_(angleX * (double)0.05f, 0.07f, angleZ * (double)0.05f);
        }
    }

    @Override
    public void updateUntied() {
        BlockPos budPos = this.getBudPos();
        if (this.f_19853_.isAreaLoaded(budPos, 1) && (this.f_19853_.m_8055_(budPos).m_60734_() != EEBlocks.BOLLOOM_BUD.get() || !((Boolean)this.f_19853_.m_8055_(budPos).m_61143_((Property)BolloomBudBlock.OPENED)).booleanValue())) {
            this.setUntied(true);
        }
        if (!this.isOpenPathBelowFruit()) {
            this.setUntied(true);
        }
    }

    @Override
    public void onBroken(boolean dropFruit) {
        super.onBroken(dropFruit);
        if (dropFruit) {
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)EEItems.BOLLOOM_FRUIT.get()));
        }
    }

    public boolean isOpenPathBelowFruit() {
        BlockPos.MutableBlockPos mutable = this.m_20183_().m_122032_();
        for (int i = 0; i < this.getVineHeight(); ++i) {
            BlockPos pos = mutable.m_6625_(i);
            if (!this.f_19853_.isAreaLoaded(pos, 1) || this.f_19853_.m_8055_(pos).m_60795_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)EEItems.BOLLOOM_FRUIT.get());
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof BolloomFruit) {
            if (entity.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(entity);
            }
        } else if (entity.m_20186_() >= this.m_20191_().f_82289_) {
            super.m_7334_(entity);
        }
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }
}

