/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.teamabnormals.endergetic.api.entity.util.EntityItemStackHelper;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomFruit;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloBaby;
import com.teamabnormals.endergetic.common.entity.booflo.ai.AdolescentAttackGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.AdolescentEatGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloNearestAttackableTargetGoal;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEItems;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoofloAdolescent
extends PathfinderMob
implements Endimatable {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_FRUIT = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DESCENTING = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HUNGRY = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATEN = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_GROW = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> FALL_SPEED = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> BOOF_BOOST_COOLDOWN = SynchedEntityData.m_135353_(BoofloAdolescent.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Entity boofloAttackTarget;
    public int growingAge;
    public int forcedAge;
    public int forcedAgeTimer;
    private float prevTailAnimation;
    private float tailAnimation;
    private float tailSpeed;
    private float prevSwimmingAnimation;
    private float swimmingAnimation;
    private float swimmingAnimationSpeed;
    public boolean wasBred;

    public BoofloAdolescent(EntityType<? extends BoofloAdolescent> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new BoofloAdolescentMoveController(this);
        this.prevTailAnimation = this.tailAnimation = this.f_19796_.m_188501_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(HAS_FRUIT, (Object)false);
        this.f_19804_.m_135372_(DESCENTING, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(HUNGRY, (Object)true);
        this.f_19804_.m_135372_(EATEN, (Object)false);
        this.f_19804_.m_135372_(WANTS_TO_GROW, (Object)false);
        this.f_19804_.m_135372_(FALL_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BOOF_BOOST_COOLDOWN, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AdolescentEatGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new AdolescentAttackGoal(this, 1.1, true));
        this.f_21345_.m_25352_(6, (Goal)new RandomFlyingGoal(this, 1.1, 5));
        this.f_21346_.m_25352_(4, new BoofloNearestAttackableTargetGoal<BolloomFruit>((Mob)this, BolloomFruit.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)1.7f).m_22268_(Attributes.f_22277_, 25.0);
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.m_6142_() && !this.m_20069_()) {
            this.m_19920_(0.015f, vec3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.005 * (double)this.getFallSpeed(), 0.0));
        } else {
            super.m_7023_(vec3d);
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new EndergeticFlyingPathNavigator((Mob)this, worldIn){

            @Override
            public boolean m_6342_(BlockPos pos) {
                return !this.f_26494_.m_20096_();
            }
        };
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.65f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isEndimationPlaying(EEPlayableEndimations.ADOLESCENT_BOOFLO_EATING) && this.getAnimationTick() == 9) {
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)EEItems.BOLLOOM_FRUIT.get())), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 1.5, this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20202_() == null) {
            this.setFallSpeed(this.getFallSpeed() + 0.1f);
        }
        if (this.m_217043_().m_188503_(50000) < 10 && !this.isHungry() && !this.hasFruit()) {
            this.setHungry(true);
        }
        if (this.f_19853_.f_46443_) {
            this.prevTailAnimation = this.tailAnimation;
            this.prevSwimmingAnimation = this.swimmingAnimation;
            if (!this.m_20069_()) {
                this.tailSpeed = 1.0f;
                this.swimmingAnimationSpeed = 1.0f;
            } else {
                this.tailSpeed = this.isMoving() ? (this.tailSpeed < 0.5f ? 1.0f : (this.tailSpeed += (0.25f - this.tailSpeed) * 0.1f)) : (this.tailSpeed += (0.1875f - this.tailSpeed) * 0.1f);
            }
            this.swimmingAnimationSpeed = this.getFallSpeed() > 0.0f ? (this.swimmingAnimationSpeed < 0.5f ? 1.0f : (this.swimmingAnimationSpeed += (this.swimmingAnimationSpeed * 2.5f - this.getFallSpeed()) * 0.1f)) : 1.0f;
            this.tailAnimation += this.tailSpeed;
            this.swimmingAnimation += this.swimmingAnimationSpeed;
        }
        if (this.getBoofBoostCooldown() > 0) {
            this.setBoofBoostCooldown(this.getBoofBoostCooldown() - 1);
        }
        if ((this.f_19861_ || this.m_20159_()) && this.doesWantToGrow() && this.f_19853_.m_45772_(this.m_20191_().m_82377_(2.0, 0.0, 2.0))) {
            this.growUp();
        }
        if (!(this.f_19853_.f_46443_ || this.isDescenting() || this.isEating() || this.getBoofBoostCooldown() > 0 || !this.f_19861_ && !this.m_204029_(FluidTags.f_13131_))) {
            this.m_5997_(-Mth.m_14031_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * (5.0f * (this.f_19796_.m_188501_() + 0.1f)) * 0.1f, this.f_19796_.m_188501_() * 0.45f + 0.65f, Mth.m_14089_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * (5.0f * (this.f_19796_.m_188501_() + 0.1f)) * 0.1f);
            NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.ADOLESCENT_BOOFLO_BOOF);
            this.setFallSpeed(0.0f);
            if (this.f_19800_) {
                this.setBoofBoostCooldown(20);
            }
        }
        if (this.getBoofBoostCooldown() <= 0 && !this.f_19861_ && this.f_19853_.m_46472_() == Level.f_46430_ && !this.isSafePos(this.m_20183_(), 3)) {
            this.setBoofBoostCooldown(20);
            this.setFallSpeed(0.0f);
            if (this.m_20186_() <= 50.0) {
                this.m_5997_(-Mth.m_14031_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * (5.0f * (this.f_19796_.m_188501_() + 0.1f)) * 0.1f, this.f_19796_.m_188501_() * 0.45f + 0.65f, Mth.m_14089_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * (5.0f * (this.f_19796_.m_188501_() + 0.1f)) * 0.1f);
                this.setPlayingEndimation(EEPlayableEndimations.ADOLESCENT_BOOFLO_BOOF);
            }
        }
        if (!(this.f_19861_ || this.f_19853_.m_46472_() != Level.f_46430_ || this.isSafePos(this.m_20183_(), 3) || this.f_19853_.f_46443_)) {
            this.m_5997_(-Mth.m_14031_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * 0.01f, 0.0, Mth.m_14089_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * 0.01f);
        }
        if (this.getBoofloAttackTarget() != null && this.m_142582_(this.getBoofloAttackTarget())) {
            this.m_146922_(this.f_20885_);
        }
        if (this.f_19853_.f_46443_) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.m_6084_() && this.hasEaten()) {
            int growingAge = this.getGrowingAge();
            if (growingAge < 0) {
                this.setGrowingAge(++growingAge);
            } else if (growingAge > 0) {
                this.setGrowingAge(--growingAge);
            }
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)EEItems.BOOFLO_SPAWN_EGG.get());
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_6667_(DamageSource cause) {
        if (this.hasFruit() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.dropFruit();
        }
        super.m_6667_(cause);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Moving", this.isMoving());
        compound.m_128379_("HasFruit", this.hasFruit());
        compound.m_128379_("Descenting", this.isDescenting());
        compound.m_128379_("IsEating", this.isEating());
        compound.m_128379_("IsHungry", this.isHungry());
        compound.m_128379_("HasEaten", this.hasEaten());
        compound.m_128379_("WantsToGrow", this.doesWantToGrow());
        compound.m_128350_("FallSpeed", this.getFallSpeed());
        compound.m_128405_("BoofBoostCooldown", this.getBoofBoostCooldown());
        compound.m_128405_("Age", this.getGrowingAge());
        compound.m_128405_("ForcedAge", this.forcedAge);
        compound.m_128379_("WasBred", this.wasBred);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMoving(compound.m_128471_("Moving"));
        this.setHasFruit(compound.m_128471_("HasFruit"));
        this.setDescenting(compound.m_128471_("Descenting"));
        this.setEating(compound.m_128471_("IsEating"));
        this.setHungry(compound.m_128471_("IsHungry"));
        this.setEaten(compound.m_128471_("HasEaten"));
        this.setWantsToGrow(compound.m_128471_("WantsToGrow"));
        this.setFallSpeed(compound.m_128457_("FallSpeed"));
        this.setBoofBoostCooldown(compound.m_128451_("BoofBoostCooldown"));
        this.setGrowingAge(compound.m_128451_("Age"));
        this.forcedAge = compound.m_128451_("ForcedAge");
        this.wasBred = compound.m_128471_("WasBred");
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    public void setMoving(boolean moving) {
        this.f_19804_.m_135381_(MOVING, (Object)moving);
    }

    public boolean hasFruit() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FRUIT);
    }

    public void setHasFruit(boolean hasFruit) {
        this.f_19804_.m_135381_(HAS_FRUIT, (Object)hasFruit);
    }

    public boolean isDescenting() {
        return (Boolean)this.f_19804_.m_135370_(DESCENTING);
    }

    public void setDescenting(boolean descenting) {
        this.f_19804_.m_135381_(DESCENTING, (Object)descenting);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    public boolean isHungry() {
        return (Boolean)this.f_19804_.m_135370_(HUNGRY);
    }

    public void setHungry(boolean hungry) {
        this.f_19804_.m_135381_(HUNGRY, (Object)hungry);
    }

    public boolean hasEaten() {
        return (Boolean)this.f_19804_.m_135370_(EATEN);
    }

    public void setEaten(boolean eaten) {
        this.f_19804_.m_135381_(EATEN, (Object)eaten);
    }

    public boolean doesWantToGrow() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_GROW);
    }

    public void setWantsToGrow(boolean wantsToGrow) {
        this.f_19804_.m_135381_(WANTS_TO_GROW, (Object)wantsToGrow);
    }

    public float getFallSpeed() {
        return ((Float)this.f_19804_.m_135370_(FALL_SPEED)).floatValue();
    }

    public void setFallSpeed(float speed) {
        this.f_19804_.m_135381_(FALL_SPEED, (Object)Float.valueOf(speed));
    }

    public int getBoofBoostCooldown() {
        return (Integer)this.f_19804_.m_135370_(BOOF_BOOST_COOLDOWN);
    }

    public void setBoofBoostCooldown(int ticks) {
        this.f_19804_.m_135381_(BOOF_BOOST_COOLDOWN, (Object)ticks);
    }

    @Nullable
    public Entity getBoofloAttackTarget() {
        return this.boofloAttackTarget;
    }

    public void setBoofloAttackTarget(@Nullable Entity entity) {
        this.boofloAttackTarget = entity;
    }

    public int getGrowingAge() {
        if (this.f_19853_.f_46443_) {
            return -1;
        }
        return this.growingAge;
    }

    public void setGrowingAge(int age) {
        int oldAge = this.growingAge;
        this.growingAge = age;
        if ((oldAge < 0 && age >= 0 || oldAge > 0 && age < 0) && this.hasEaten()) {
            this.setWantsToGrow(true);
        }
    }

    public void addGrowth(int growth) {
        this.ageUp(growth, false);
    }

    public void ageUp(int growthSeconds, boolean updateForcedAge) {
        int growingAge;
        int j = growingAge = this.getGrowingAge();
        if ((growingAge += growthSeconds * 20) > 0) {
            growingAge = 0;
        }
        int k = growingAge - j;
        this.setGrowingAge(growingAge);
        if (updateForcedAge) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    public LivingEntity growUp() {
        if (this.m_6084_()) {
            this.m_20000_((ItemLike)EEItems.BOOFLO_HIDE.get(), 1);
            Booflo booflo = (Booflo)((EntityType)EEEntityTypes.BOOFLO.get()).m_20615_(this.f_19853_);
            booflo.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            if (this.m_8077_()) {
                booflo.m_6593_(this.m_7770_());
                booflo.m_20340_(this.m_20151_());
            }
            if (this.m_21523_()) {
                booflo.m_21463_(this.m_21524_(), true);
                this.m_21455_(true, false);
            }
            if (this.m_20202_() != null) {
                booflo.m_20329_(this.m_20202_());
            }
            booflo.wasBred = this.wasBred;
            booflo.m_21153_(booflo.m_21233_());
            this.f_19853_.m_7967_((Entity)booflo);
            this.m_146870_();
            return booflo;
        }
        return this;
    }

    public LivingEntity growDown() {
        if (this.m_6084_()) {
            BoofloBaby boofloBaby = (BoofloBaby)((EntityType)EEEntityTypes.BOOFLO_BABY.get()).m_20615_(this.f_19853_);
            boofloBaby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            if (this.m_8077_()) {
                boofloBaby.m_6593_(this.m_7770_());
                boofloBaby.m_20340_(this.m_20151_());
            }
            if (this.m_21523_()) {
                boofloBaby.m_21463_(this.m_21524_(), true);
                this.m_21455_(true, false);
            }
            if (this.m_20202_() != null) {
                boofloBaby.m_20329_(this.m_20202_());
            }
            boofloBaby.wasBred = this.wasBred;
            boofloBaby.m_21153_(boofloBaby.m_21233_());
            this.f_19853_.m_7967_((Entity)boofloBaby);
            this.m_146870_();
            return boofloBaby;
        }
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAnimation(float ptc) {
        return Mth.m_14179_((float)ptc, (float)this.prevTailAnimation, (float)this.tailAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSwimmingAnimation(float ptc) {
        return Mth.m_14179_((float)ptc, (float)this.prevSwimmingAnimation, (float)this.swimmingAnimation);
    }

    public boolean isSafePos(BlockPos pos, int muliplier) {
        BlockPos newPos = pos;
        for (int y = 0; y < 10 * muliplier; ++y) {
            BlockState state = this.f_19853_.m_8055_(newPos = newPos.m_6625_(y));
            if (!state.m_60815_() && (state.m_60819_().m_76178_() || state.m_60819_().m_205070_(FluidTags.f_13132_))) continue;
            return true;
        }
        return false;
    }

    public void dropFruit() {
        if (!this.f_19853_.f_46443_) {
            this.m_19998_((ItemLike)EEItems.BOLLOOM_FRUIT.get());
            this.setHasFruit(false);
        }
    }

    public boolean isPlayerNear() {
        return this.f_19853_.m_6443_(Player.class, this.m_20191_().m_82400_(2.0), Booflo.IS_SCARED_BY).size() > 0;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19316_ || super.m_6673_(source);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof SpawnEggItem && ((SpawnEggItem)item).m_43230_(itemstack.m_41783_(), (EntityType)EEEntityTypes.BOOFLO.get())) {
            if (!this.f_19853_.f_46443_) {
                BoofloBaby baby = (BoofloBaby)((EntityType)EEEntityTypes.BOOFLO_BABY.get()).m_20615_(this.f_19853_);
                baby.setGrowingAge(-24000);
                baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)baby);
                if (itemstack.m_41788_()) {
                    baby.m_6593_(itemstack.m_41786_());
                }
                EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            }
            return InteractionResult.PASS;
        }
        if (item == EEItems.BOLLOOM_FRUIT.get()) {
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f), true);
            this.setEaten(true);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setGrowingAge(-24000);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.wasBred;
    }

    static class BoofloAdolescentMoveController
    extends MoveControl {
        private final BoofloAdolescent booflo;

        BoofloAdolescentMoveController(BoofloAdolescent booflo) {
            super((Mob)booflo);
            this.booflo = booflo;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.booflo.m_21573_().m_26571_()) {
                Position pos = this.booflo.getPos();
                Vec3 vec3d = new Vec3(this.f_24975_ - pos.m_7096_(), this.f_24976_ - pos.m_7098_(), this.f_24977_ - pos.m_7094_());
                this.booflo.m_146922_(this.m_24991_(this.booflo.m_146908_(), (float)(Mth.m_14136_((double)vec3d.f_82481_, (double)vec3d.f_82479_) * 57.2957763671875 - 90.0), 10.0f));
                this.booflo.f_20883_ = this.booflo.m_146908_();
                this.booflo.f_20885_ = this.booflo.m_146908_();
                float f1 = (float)(2.0 * this.booflo.m_21051_(Attributes.f_22279_).m_22135_());
                float f2 = Mth.m_14179_((float)0.125f, (float)this.booflo.m_6113_(), (float)f1);
                this.booflo.m_7910_(f2);
                this.booflo.setMoving(true);
            } else {
                this.booflo.setMoving(false);
            }
        }
    }

    static class RandomFlyingGoal
    extends RandomStrollGoal {
        public RandomFlyingGoal(PathfinderMob booflo, double speed, int chance) {
            super(booflo, speed, chance);
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 view = this.f_25725_.m_20252_(0.0f);
            double viewX = view.f_82479_;
            double viewZ = view.f_82481_;
            Vec3 vec3d = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)10, (int)0, (double)viewX, (double)viewZ, (float)1.5707964f, (int)3, (int)1);
            int i = 0;
            while (vec3d != null && !this.f_25725_.f_19853_.m_8055_(new BlockPos(vec3d)).m_60647_((BlockGetter)this.f_25725_.f_19853_, new BlockPos(vec3d), PathComputationType.AIR) && i++ < 10) {
                vec3d = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)10, (int)0, (double)viewX, (double)viewZ, (float)1.5707964f, (int)3, (int)1);
            }
            return vec3d;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25725_.m_20069_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.f_25725_.m_20069_();
        }
    }
}

