/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo.ai;

import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloAdolescent;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class BoofloNearestAttackableTargetGoal<E extends Entity>
extends TargetGoal {
    protected final Class<E> targetClass;
    protected final int targetChance;
    protected Entity nearestTarget;
    protected TargetingConditions targetEntitySelector;

    public BoofloNearestAttackableTargetGoal(Mob attacker, Class<E> targetClass, boolean p_i50313_3_) {
        this(attacker, targetClass, p_i50313_3_, false);
    }

    public BoofloNearestAttackableTargetGoal(Mob attacker, Class<E> targetClass, boolean p_i50314_3_, boolean p_i50314_4_) {
        this(attacker, targetClass, 5, p_i50314_3_, p_i50314_4_);
    }

    public BoofloNearestAttackableTargetGoal(Mob p_i50315_1_, Class<E> p_i50315_2_, int p_i50315_3_, boolean p_i50315_4_, boolean p_i50315_5_) {
        super(p_i50315_1_, p_i50315_4_, p_i50315_5_);
        this.targetClass = p_i50315_2_;
        this.targetChance = p_i50315_3_;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetEntitySelector = TargetingConditions.f_26872_.m_26883_(this.m_7623_());
    }

    public boolean m_8036_() {
        if (this.targetChance > 0 && this.f_26135_.m_217043_().m_188503_(this.targetChance) != 0) {
            return false;
        }
        if (this.f_26135_ instanceof BoofloAdolescent && !((BoofloAdolescent)this.f_26135_).isHungry()) {
            return false;
        }
        if (!(!(this.f_26135_ instanceof Booflo) || ((Booflo)this.f_26135_).getBoofloAttackTarget() == null && ((Booflo)this.f_26135_).isBoofed() && ((Booflo)this.f_26135_).isHungry())) {
            return false;
        }
        if (this.f_26135_ instanceof Booflo && ((Booflo)this.f_26135_).isTamed() && this.targetClass == PuffBug.class) {
            return false;
        }
        this.findNearestTarget();
        return this.nearestTarget != null;
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.f_26135_.m_20191_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    protected void findNearestTarget() {
        this.nearestTarget = this.findEntity(this.targetClass, this.targetEntitySelector, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20186_() + (double)this.f_26135_.m_20192_(), this.f_26135_.m_20189_(), this.getTargetableArea(this.m_7623_()));
    }

    public void m_8056_() {
        if (this.f_26135_ instanceof Booflo) {
            ((Booflo)this.f_26135_).setBoofloAttackTargetId(this.nearestTarget.m_19879_());
        } else {
            ((BoofloAdolescent)this.f_26135_).setBoofloAttackTarget(this.nearestTarget);
        }
        super.m_8056_();
    }

    @Nullable
    public E findEntity(Class<? extends E> target, TargetingConditions predicate, @Nullable LivingEntity attacker, double p_225318_4_, double p_225318_6_, double p_225318_8_, AABB bb) {
        return this.getClosestEntity(attacker.f_19853_.m_6443_(target, bb, entity -> true), predicate, attacker, p_225318_4_, p_225318_6_, p_225318_8_);
    }

    @Nullable
    private E getClosestEntity(List<? extends E> p_217361_1_, TargetingConditions p_217361_2_, @Nullable LivingEntity attacker, double p_217361_4_, double p_217361_6_, double p_217361_8_) {
        double d0 = -1.0;
        Entity e = null;
        for (Entity e1 : p_217361_1_) {
            if (!this.canTarget(attacker, e1)) continue;
            double d1 = e1.m_20275_(p_217361_4_, p_217361_6_, p_217361_8_);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            e = e1;
        }
        return (E)e;
    }

    public boolean canTarget(@Nullable LivingEntity attacker, Entity target) {
        if (attacker == target) {
            return false;
        }
        if (target.m_5833_()) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (target.m_20147_()) {
            return false;
        }
        if (attacker != null) {
            if (!attacker.m_6549_(target.m_6095_())) {
                return false;
            }
            if (attacker.m_7307_(target)) {
                return false;
            }
            if (this.m_7623_() > 0.0) {
                double d1 = this.m_7623_();
                double d2 = attacker.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (d2 > d1 * d1) {
                    return false;
                }
            }
            return !(attacker instanceof Mob) || ((Mob)attacker).m_21574_().m_148306_(target);
        }
        return true;
    }
}

