/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.TimedEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.teamabnormals.endergetic.api.entity.util.DetectionHelper;
import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import com.teamabnormals.endergetic.common.block.entity.EetleEggTileEntity;
import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEggSack;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleAirSlamGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleDropEggsGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleFlingGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleFlyNearPosGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleHurtByTargetGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleLandGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleLastStageGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleLaunchEggsGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleSlamGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleSleepGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleTakeoffGoal;
import com.teamabnormals.endergetic.common.entity.eetle.flying.FlyingEetleMoveController;
import com.teamabnormals.endergetic.common.entity.eetle.flying.FlyingRotations;
import com.teamabnormals.endergetic.common.entity.eetle.flying.IFlyingEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.TargetFlyingRotations;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.other.EEDataSerializers;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BroodEetle
extends Monster
implements Endimatable,
IFlyingEetle {
    private static final Field SIZE_FIELD = ObfuscationReflectionHelper.findField(Entity.class, (String)"f_19815_");
    private static final Field EYE_HEIGHT_FIELD = ObfuscationReflectionHelper.findField(Entity.class, (String)"f_19816_");
    private static final EntityDataAccessor<Boolean> FIRING_CANNON = SynchedEntityData.m_135353_(BroodEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(BroodEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(BroodEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DROPPING_EGGS = SynchedEntityData.m_135353_(BroodEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(BroodEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<TargetFlyingRotations> TARGET_FLYING_ROTATIONS = SynchedEntityData.m_135353_(BroodEetle.class, EEDataSerializers.TARGET_FLYING_ROTATIONS);
    private static final EntityDataAccessor<Integer> EGG_SACK_ID = SynchedEntityData.m_135353_(BroodEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<HealthStage> HEALTH_STAGE = SynchedEntityData.m_135353_(BroodEetle.class, EEDataSerializers.BROOD_HEALTH_STAGE);
    private static final EntityDimensions FLYING_SIZE = EntityDimensions.m_20398_((float)1.875f, (float)2.125f);
    private static final EntityDimensions FINAL_STAGE_SIZE = EntityDimensions.m_20398_((float)2.1875f, (float)2.125f);
    private final TimedEndimation eggCannonEndimation = new TimedEndimation(20, 0);
    private final TimedEndimation eggMouthEndimation = new TimedEndimation(15, 0);
    private final TimedEndimation takeoffEndimation = new TimedEndimation(15, 0);
    private final TimedEndimation eggCannonFlyingEndimation = new TimedEndimation(20, 0);
    private final TimedEndimation flyingEndimation = new TimedEndimation(20, 0);
    private final TimedEndimation sleepingEndimation = new TimedEndimation(20, 0);
    private final TimedEndimation healPulseEndimation = new TimedEndimation(10, 0);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_6);
    private final Set<ServerPlayer> trackedPlayers = new HashSet<ServerPlayer>();
    private final FlyingRotations flyingRotations = new FlyingRotations();
    private final Set<LivingEntity> revengeTargets = new HashSet<LivingEntity>();
    @Nullable
    public BlockPos takeoffPos;
    private int idleDelay;
    private int slamCooldown;
    private int eggCannonCooldown;
    private int ticksFlying;
    private int flyCooldown;
    private int eggDropOffCooldown;
    private boolean takeoffMoving;
    private float prevWingFlap;
    private float wingFlap;
    private float wingFlapSpeed;
    private float prevHealthPercentage;
    public boolean wokenUpAggressively;

    public BroodEetle(EntityType<? extends BroodEetle> type, Level world) {
        super(type, world);
        this.f_21364_ = 50;
        this.prevWingFlap = this.wingFlap = this.f_19796_.m_188501_();
        this.prevHealthPercentage = 1.0f;
        this.takeoffEndimation.setDecrementing(true);
        this.flyingEndimation.setDecrementing(true);
        this.healPulseEndimation.setDecrementing(true);
        this.resetIdleFlapDelay();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BroodEetleLastStageGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BroodEetleSleepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BroodEetleDropEggsGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BroodEetleAirSlamGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BroodEetleLandGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BroodEetleFlyNearPosGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BroodEetleLaunchEggsGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BroodEetleTakeoffGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new BroodEetleSlamGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new BroodEetleFlingGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractEetle.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new BroodEetleHurtByTargetGoal(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FIRING_CANNON, (Object)false);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(DROPPING_EGGS, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(TARGET_FLYING_ROTATIONS, (Object)TargetFlyingRotations.ZERO);
        this.f_19804_.m_135372_(EGG_SACK_ID, (Object)-1);
        this.f_19804_.m_135372_(HEALTH_STAGE, (Object)HealthStage.ZERO);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (FLYING.equals(key)) {
            if (this.isFlying()) {
                this.f_21342_ = new FlyingEetleMoveController<BroodEetle>(this, 10.0f, 30.0f);
                this.f_21344_ = new EndergeticFlyingPathNavigator((Mob)this, this.f_19853_);
            } else {
                this.f_21342_ = new MoveControl((Mob)this);
                this.f_21344_ = this.m_6037_(this.f_19853_);
            }
            this.resetIdleFlapDelay();
            this.m_6210_();
            BroodEggSack eggSackEntity = this.getEggSack(this.f_19853_);
            if (eggSackEntity != null) {
                eggSackEntity.m_6210_();
            }
        } else if (TARGET_FLYING_ROTATIONS.equals(key)) {
            this.flyingRotations.setLooking(true);
        } else if (SLEEPING.equals(key) && !this.m_5803_()) {
            for (ServerPlayer playerEntity : this.trackedPlayers) {
                this.bossInfo.m_6543_(playerEntity);
            }
        } else if (HEALTH_STAGE.equals(key)) {
            this.m_6210_();
            BroodEggSack eggSackEntity = this.getEggSack(this.f_19853_);
            if (eggSackEntity != null) {
                eggSackEntity.m_6210_();
            }
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 11.0).m_22268_(Attributes.f_22280_, (double)0.35f).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        Level world = this.f_19853_;
        if (this.m_21224_()) {
            if (!(this.isEndimationPlaying(EEPlayableEndimations.BROOD_EETLE_DEATH_LEFT) || this.isEndimationPlaying(EEPlayableEndimations.BROOD_EETLE_DEATH_RIGHT) || world.f_46443_)) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)(this.f_19796_.m_188499_() ? EEPlayableEndimations.BROOD_EETLE_DEATH_LEFT : EEPlayableEndimations.BROOD_EETLE_DEATH_RIGHT));
            }
            if (++this.f_20919_ >= 105) {
                if (!world.f_46443_) {
                    ItemEntity elytra = this.m_19998_((ItemLike)Items.f_42741_);
                    if (elytra != null) {
                        elytra.m_32064_();
                    }
                    this.m_146870_();
                    if (world instanceof ServerLevel) {
                        Vec3 eggSackPos = BroodEggSack.getEggPos(this.m_20182_(), this.f_20883_, this.getEggCannonProgressServer(), this.getEggCannonFlyingProgressServer(), this.getFlyingRotations().getFlyPitch(), this.isOnLastHealthStage());
                        ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)EEBlocks.EETLE_EGG.get()).m_49966_()), eggSackPos.m_7096_(), eggSackPos.m_7098_() + (double)0.83f, eggSackPos.m_7094_(), 20, 0.3125, 0.3125, 0.3125, 0.2);
                        ((ServerLevel)world).m_8767_((ParticleOptions)new CorrockCrownParticleData((ParticleType<CorrockCrownParticleData>)((ParticleType)EEParticleTypes.END_CROWN.get()), true), eggSackPos.m_7096_(), eggSackPos.m_7098_() + (double)0.83f, eggSackPos.m_7094_(), 30, 0.3125, 0.3125, 0.3125, 0.2);
                    }
                } else {
                    for (int i = 0; i < 20; ++i) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                    }
                }
            }
        }
        if (!world.f_46443_) {
            BlockPos takeoffPos;
            BroodEggSack eggSackEntity;
            if (this.idleDelay > 0) {
                --this.idleDelay;
            }
            if (this.slamCooldown > 0) {
                --this.slamCooldown;
            }
            if (this.eggCannonCooldown > 0) {
                --this.eggCannonCooldown;
            }
            if (this.flyCooldown > 0) {
                --this.flyCooldown;
            }
            if (this.eggDropOffCooldown > 0) {
                --this.eggDropOffCooldown;
            }
            if (this.f_19796_.m_188501_() < 0.005f && this.idleDelay <= 0 && this.m_20096_() && !this.isFiringCannon() && this.isNoEndimationPlaying()) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)(this.f_19796_.m_188501_() < 0.6f && !this.isFlying() ? EEPlayableEndimations.BROOD_EETLE_FLAP : EEPlayableEndimations.BROOD_EETLE_MUNCH));
                this.resetIdleFlapDelay();
            }
            if ((eggSackEntity = this.getEggSack(world)) != null && eggSackEntity.m_6084_()) {
                eggSackEntity.f_19854_ = eggSackEntity.f_19790_ = eggSackEntity.m_20185_();
                eggSackEntity.f_19855_ = eggSackEntity.f_19791_ = eggSackEntity.m_20186_();
                eggSackEntity.f_19856_ = eggSackEntity.f_19792_ = eggSackEntity.m_20189_();
                eggSackEntity.updatePosition(this);
            } else {
                eggSackEntity = new BroodEggSack(world);
                eggSackEntity.setBroodID(this.m_19879_());
                eggSackEntity.updatePosition(this);
                world.m_7967_((Entity)eggSackEntity);
                this.setEggSackID(eggSackEntity.m_19879_());
            }
            if (this.isFlying()) {
                ++this.ticksFlying;
                if (this.isEndimationPlaying(EEPlayableEndimations.BROOD_EETLE_AIR_SLAM) && this.getAnimationTick() == 5 && (this.f_19861_ || !this.f_19853_.m_45772_(DetectionHelper.checkOnGround(this.m_20191_(), 0.25f)))) {
                    BroodEetleSlamGoal.slam(this, this.f_19796_, 1.0f);
                }
            } else {
                this.ticksFlying = 0;
            }
            if (this.f_19853_.m_46467_() % 5L == 0L && (takeoffPos = this.takeoffPos) != null && this.m_20182_().m_82557_(Vec3.m_82528_((Vec3i)takeoffPos)) > 256.0) {
                this.takeoffPos = null;
            }
            float percentage = this.m_21223_() / this.m_21233_();
            this.bossInfo.m_142711_(percentage);
            if (percentage != this.prevHealthPercentage) {
                HealthStage newStage = HealthStage.getStage(percentage);
                if (newStage.eggGrowthChance > 0.0f && newStage.ordinal() > this.getHealthStage().ordinal()) {
                    newStage.awakeNearbyEggs(this);
                }
                this.setHealthStage(newStage);
            }
            this.prevHealthPercentage = percentage;
        } else {
            TimedEndimation takeoff = this.takeoffEndimation;
            takeoff.tick();
            if (takeoff.isMaxed()) {
                this.takeoffMoving = true;
                takeoff.setDecrementing(true);
            } else if (this.takeoffMoving) {
                this.takeoffMoving = takeoff.getTick() > 15;
            } else {
                takeoff.setDecrementing(!this.isFlying());
            }
            this.wingFlapSpeed += this.isMoving() ? (0.5f - this.wingFlapSpeed) * 0.1f : (0.125f - this.wingFlapSpeed) * 0.2f;
            this.prevWingFlap = this.wingFlap;
            this.wingFlap += this.wingFlapSpeed;
        }
        TimedEndimation eggCannonEndimation = this.eggCannonEndimation;
        eggCannonEndimation.setDecrementing(!this.isFiringCannon() && (!this.isEndimationPlaying(EEPlayableEndimations.BROOD_EETLE_DEATH_LEFT) && !this.isEndimationPlaying(EEPlayableEndimations.BROOD_EETLE_DEATH_RIGHT) || this.getAnimationTick() < 15));
        eggCannonEndimation.tick();
        TimedEndimation eggMouthEndimation = this.eggMouthEndimation;
        eggMouthEndimation.setDecrementing(!eggCannonEndimation.isMaxed() && this.isNotDroppingEggs());
        eggMouthEndimation.tick();
        TimedEndimation eggCannonFlyingEndimation = this.eggCannonFlyingEndimation;
        eggCannonFlyingEndimation.setDecrementing(!this.isFlying());
        eggCannonFlyingEndimation.tick();
        TimedEndimation flying = this.flyingEndimation;
        flying.setDecrementing(!this.isMoving());
        flying.tick();
        TimedEndimation sleepingEndimation = this.sleepingEndimation;
        sleepingEndimation.setDecrementing(!this.m_5803_());
        sleepingEndimation.tick();
        TimedEndimation healPulseEndimation = this.healPulseEndimation;
        if (healPulseEndimation.isMaxed()) {
            healPulseEndimation.setDecrementing(true);
        }
        healPulseEndimation.tick();
        this.flyingRotations.tick(this.getTargetFlyingRotations());
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && !this.m_6162_() && this.isFlying()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.01, 0.0));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsSleeping", this.m_5803_());
        if (this.takeoffPos != null) {
            compound.m_128365_("TakeoffPos", (Tag)NbtUtils.m_129224_((BlockPos)this.takeoffPos));
        }
        compound.m_128405_("EggCannonCooldown", this.eggCannonCooldown);
        compound.m_128405_("FlyCooldown", this.flyCooldown);
        compound.m_128405_("EggDropOffCooldown", this.eggDropOffCooldown);
        compound.m_128379_("IsFlying", this.isFlying());
    }

    public void m_7378_(CompoundTag compound) {
        float progress;
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setSleeping(compound.m_128471_("IsSleeping"));
        if (compound.m_128425_("TakeoffPos", 10)) {
            this.takeoffPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("TakeoffPos"));
        }
        this.eggCannonCooldown = compound.m_128451_("EggCannonCooldown");
        this.flyCooldown = compound.m_128451_("FlyCooldown");
        this.eggDropOffCooldown = compound.m_128451_("EggDropOffCooldown");
        this.setFlying(compound.m_128471_("IsFlying"));
        this.prevHealthPercentage = progress = this.m_21223_() / this.m_21233_();
        this.setHealthStage(HealthStage.getStage(progress));
    }

    protected void m_7324_(Entity collider) {
        double d1;
        double d0;
        double d2;
        if (!this.m_20365_(collider) && !collider.f_19794_ && !this.f_19794_ && (d2 = Mth.m_14005_((double)(d0 = collider.m_20185_() - this.m_20185_()), (double)(d1 = collider.m_20189_() - this.m_20189_()))) >= 0.01) {
            d2 = Mth.m_14116_((float)((float)d2));
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= 0.05;
            d1 *= 0.05;
            if (!this.m_20160_()) {
                this.m_5997_(-d0 * (double)0.2f, 0.0, -d1 * (double)0.2f);
            }
            if (!collider.m_20160_()) {
                collider.m_5997_(d0 * 2.0, 0.0, d1 * 2.0);
            }
        }
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_6072_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7327_(Entity target) {
        float attackDamage;
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BROOD_EETLE_ATTACK);
        }
        float damage = (float)((int)(attackDamage = (float)this.m_21133_(Attributes.f_22281_))) > 0.0f ? attackDamage / 2.0f + (float)this.f_19796_.m_188503_((int)attackDamage) : attackDamage;
        boolean attacked = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
        if (attacked) {
            this.m_19970_((LivingEntity)this, target);
            this.m_6731_((LivingEntity)target);
        }
        return attacked;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(source, source.m_19387_() && source.m_19376_() ? amount : amount * (source.m_19360_() ? 0.05f : 0.1f));
    }

    public boolean attackEntityFromEggSack(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.m_5496_(SoundEvents.f_12546_, 1.0f, 0.6f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
            return true;
        }
        return false;
    }

    protected void m_6153_() {
    }

    protected void m_6731_(LivingEntity target) {
        double knockbackForce = this.m_21133_(Attributes.f_22282_) - target.m_21133_(Attributes.f_22278_);
        if (knockbackForce > 0.0) {
            RandomSource random = this.f_19853_.f_46441_;
            double scale = knockbackForce * (double)(random.m_188501_() * 0.5f + 0.5f);
            Vec3 horizontalVelocity = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_().m_82490_(scale);
            target.m_5997_(horizontalVelocity.f_82479_, knockbackForce * 0.5 * (double)random.m_188501_() * 0.5, horizontalVelocity.f_82481_);
            target.f_19864_ = true;
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        if (this.m_5803_()) {
            this.trackedPlayers.add(player);
        } else {
            this.bossInfo.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        if (this.m_5803_()) {
            this.trackedPlayers.remove(player);
        } else {
            this.bossInfo.m_6539_(player);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isFlying() ? FLYING_SIZE : (this.isOnLastHealthStage() ? FINAL_STAGE_SIZE : super.m_6972_(pose));
    }

    public void m_7822_(byte id) {
        if (id == 60) {
            this.healPulseEndimation.setDecrementing(false);
        } else {
            super.m_7822_(id);
        }
    }

    public void setFiringCannon(boolean firingCannon) {
        this.f_19804_.m_135381_(FIRING_CANNON, (Object)firingCannon);
    }

    public boolean isFiringCannon() {
        return (Boolean)this.f_19804_.m_135370_(FIRING_CANNON);
    }

    public float getEggCannonProgress() {
        return this.eggCannonEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public float getEggCannonProgressServer() {
        return this.eggCannonEndimation.getServerProgress();
    }

    public float getEggMouthProgress() {
        return this.eggMouthEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public boolean isEggMouthOpen() {
        return this.eggMouthEndimation.isMaxed();
    }

    public float getTakeoffProgress() {
        return this.takeoffEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public boolean isEggCannonFlyingAtMax() {
        return this.eggCannonFlyingEndimation.isMaxed();
    }

    public float getEggCannonFlyingProgress() {
        return this.eggCannonFlyingEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public float getEggCannonFlyingProgressServer() {
        return this.eggCannonFlyingEndimation.getServerProgress();
    }

    public boolean hasWokenUp() {
        return this.sleepingEndimation.getTick() == 0;
    }

    public boolean shouldSlamWhenWakingUp() {
        return this.sleepingEndimation.getTick() == 2 && this.wokenUpAggressively;
    }

    public float getSleepingProgress() {
        return Mth.m_14031_((float)(1.5708f * this.sleepingEndimation.getProgress(ClientInfo.getPartialTicks())));
    }

    public float getFlyingProgress() {
        return this.flyingEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public float getHealPulseProgress() {
        return this.healPulseEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public void resetIdleFlapDelay() {
        this.idleDelay = this.f_19796_.m_188503_(41) + 25;
    }

    public void resetSlamCooldown() {
        this.slamCooldown = this.f_19796_.m_188503_(21) + 70;
    }

    public void resetEggCannonCooldown() {
        this.eggCannonCooldown = this.f_19796_.m_188503_(201) + 1200;
    }

    public boolean canSlam() {
        return this.slamCooldown <= 0;
    }

    public boolean canFireEggCannon() {
        return this.eggCannonCooldown <= 0;
    }

    public int getEggCannonCooldown() {
        return this.eggCannonCooldown;
    }

    public int getTicksFlying() {
        return this.ticksFlying;
    }

    public void resetFlyCooldown() {
        this.flyCooldown = this.f_19796_.m_188503_(301) + 500;
    }

    public boolean canFly() {
        return this.flyCooldown <= 0;
    }

    public void resetEggDropOffCooldown() {
        this.eggDropOffCooldown = this.f_19796_.m_188503_(201) + 800;
    }

    public boolean canDropOffEggs() {
        return this.eggDropOffCooldown <= 0;
    }

    private void setHealthStage(HealthStage stage) {
        this.f_19804_.m_135381_(HEALTH_STAGE, (Object)stage);
    }

    public HealthStage getHealthStage() {
        return (HealthStage)((Object)this.f_19804_.m_135370_(HEALTH_STAGE));
    }

    public boolean isOnLastHealthStage() {
        return this.getHealthStage() == HealthStage.FIVE;
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
        if (!flying) {
            this.setMoving(false);
        }
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setDroppingEggs(boolean droppingEggs) {
        this.f_19804_.m_135381_(DROPPING_EGGS, (Object)droppingEggs);
    }

    public boolean isNotDroppingEggs() {
        return (Boolean)this.f_19804_.m_135370_(DROPPING_EGGS) == false;
    }

    @Override
    public void setMoving(boolean moving) {
        this.f_19804_.m_135381_(MOVING, (Object)moving);
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    @Override
    public void setTargetFlyingRotations(TargetFlyingRotations flyingRotations) {
        this.f_19804_.m_135381_(TARGET_FLYING_ROTATIONS, (Object)flyingRotations);
    }

    private TargetFlyingRotations getTargetFlyingRotations() {
        return (TargetFlyingRotations)this.f_19804_.m_135370_(TARGET_FLYING_ROTATIONS);
    }

    public void setEggSackID(int id) {
        this.f_19804_.m_135381_(EGG_SACK_ID, (Object)Math.max(-1, id));
    }

    private int getEggSackID() {
        return (Integer)this.f_19804_.m_135370_(EGG_SACK_ID);
    }

    @Nullable
    public BroodEggSack getEggSack(Level world) {
        Entity entity;
        int eggSackID = this.getEggSackID();
        if (eggSackID >= 0 && (entity = world.m_6815_(eggSackID)) instanceof BroodEggSack) {
            return (BroodEggSack)entity;
        }
        return null;
    }

    public FlyingRotations getFlyingRotations() {
        return this.flyingRotations;
    }

    public void addRevengeTarget(LivingEntity target) {
        this.revengeTargets.add(target);
    }

    public boolean isAnAggressor(LivingEntity entity) {
        return this.revengeTargets.contains(entity);
    }

    public float getWingFlap() {
        return Mth.m_14179_((float)ClientInfo.getPartialTicks(), (float)this.prevWingFlap, (float)this.wingFlap);
    }

    public void onEndimationStart(PlayableEndimation endimation, PlayableEndimation oldEndimation) {
        Level world;
        if (endimation == EEPlayableEndimations.BROOD_EETLE_DEATH_LEFT || endimation == EEPlayableEndimations.BROOD_EETLE_DEATH_RIGHT) {
            this.f_20919_ = 0;
            this.setFlying(false);
            this.setDroppingEggs(false);
            this.setFiringCannon(false);
        } else if ((endimation == EEPlayableEndimations.BROOD_EETLE_LAUNCH || endimation == EEPlayableEndimations.BROOD_EETLE_DROP_EGGS) && (world = this.f_19853_) instanceof ServerLevel) {
            Vec3 eggSackPos = BroodEggSack.getEggPos(this.m_20182_(), this.f_20883_, this.getEggCannonProgressServer(), this.getEggCannonFlyingProgressServer(), this.getFlyingRotations().getFlyPitch(), this.isOnLastHealthStage());
            ((ServerLevel)world).m_8767_((ParticleOptions)new CorrockCrownParticleData((ParticleType<CorrockCrownParticleData>)((ParticleType)EEParticleTypes.END_CROWN.get()), true), eggSackPos.m_7096_(), eggSackPos.m_7098_() + (double)(this.isFlying() ? 0.0f : 1.0f), eggSackPos.m_7094_(), 20, 0.3125, 0.3125, 0.3125, 0.15);
        }
    }

    public void m_6210_() {
        try {
            EntityDimensions currentSize = (EntityDimensions)SIZE_FIELD.get(this);
            Pose pose = this.m_20089_();
            EntityDimensions newSize = this.m_6972_(pose);
            EntityEvent.Size sizeEvent = ForgeEventFactory.getEntitySizeForge((Entity)this, (Pose)pose, (EntityDimensions)currentSize, (EntityDimensions)newSize, (float)this.m_6380_(pose, newSize));
            newSize = sizeEvent.getNewSize();
            SIZE_FIELD.set(this, newSize);
            EYE_HEIGHT_FIELD.set(this, Float.valueOf(sizeEvent.getNewEyeHeight()));
            if (newSize.f_20377_ < currentSize.f_20377_) {
                double d0 = (double)newSize.f_20377_ / 2.0;
                this.m_20011_(new AABB(this.m_20185_() - d0, this.m_20186_(), this.m_20189_() - d0, this.m_20185_() + d0, this.m_20186_() + (double)newSize.f_20378_, this.m_20189_() + d0));
            } else {
                AABB axisalignedbb = this.m_20191_();
                this.m_20011_(new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_, axisalignedbb.f_82290_, axisalignedbb.f_82288_ + (double)newSize.f_20377_, axisalignedbb.f_82289_ + (double)newSize.f_20378_, axisalignedbb.f_82290_ + (double)newSize.f_20377_));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static enum HealthStage {
        ZERO(1.0f, 0.0f),
        ONE(0.8333333f, 0.1f),
        TWO(0.6666667f, 0.1f),
        THREE(0.5f, 0.2f),
        FOUR(0.33333334f, 0.3f),
        FIVE(0.16666667f, 0.0f);

        private static final HealthStage[] VALUES;
        private final float percentage;
        private final float eggGrowthChance;

        private HealthStage(float percentage, float eggGrowthChance) {
            this.percentage = percentage;
            this.eggGrowthChance = eggGrowthChance;
        }

        private void awakeNearbyEggs(BroodEetle broodEetle) {
            BlockPos.MutableBlockPos mutable = broodEetle.m_20183_().m_122032_();
            int originX = mutable.m_123341_();
            int originY = mutable.m_123342_();
            int originZ = mutable.m_123343_();
            Level world = broodEetle.f_19853_;
            RandomSource random = broodEetle.f_19796_;
            for (int x = -10; x <= 10; ++x) {
                for (int y = -6; y <= 14; ++y) {
                    for (int z = -10; z <= 10; ++z) {
                        EetleEggTileEntity eetleEggs;
                        mutable.m_122178_(originX + x, originY + y, originZ + z);
                        BlockEntity tileEntity = world.m_7702_((BlockPos)mutable);
                        if (!(tileEntity instanceof EetleEggTileEntity) || !(random.m_188501_() < this.eggGrowthChance) || (eetleEggs = (EetleEggTileEntity)tileEntity).getHatchDelay() >= -60) continue;
                        eetleEggs.bypassSpawningGameRule();
                        eetleEggs.fromBroodEetle = true;
                        eetleEggs.updateHatchDelay(world, -60 - random.m_188503_(10));
                    }
                }
            }
        }

        private static HealthStage getStage(float progress) {
            for (HealthStage stage : VALUES) {
                if (!(progress <= stage.percentage)) continue;
                return stage;
            }
            return ZERO;
        }

        static {
            VALUES = new HealthStage[]{FIVE, FOUR, THREE, TWO, ONE, ZERO};
        }
    }

    public static enum HeadTiltDirection {
        LEFT(-0.17f),
        RIGHT(0.17f);

        public final float angle;

        private HeadTiltDirection(float angle) {
            this.angle = angle;
        }
    }
}

