/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle;

import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import com.teamabnormals.endergetic.common.block.EetleEggBlock;
import com.teamabnormals.endergetic.common.block.entity.EetleEggTileEntity;
import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EetleEgg
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Block EETLE_EGGS_BLOCK = (Block)EEBlocks.EETLE_EGG.get();
    private static final Direction[] DIRECTIONS = Direction.values();
    private final EetleEggTileEntity.SackGrowth[] sackGrowths = new EetleEggTileEntity.SackGrowth[]{new EetleEggTileEntity.SackGrowth(), new EetleEggTileEntity.SackGrowth(), new EetleEggTileEntity.SackGrowth(), new EetleEggTileEntity.SackGrowth()};
    private EggSize eggSize = EggSize.SMALL;
    private int fallTime;
    private boolean fromBroodEetle;

    public EetleEgg(EntityType<? extends EetleEgg> type, Level world) {
        super((EntityType)EEEntityTypes.EETLE_EGG.get(), world);
    }

    public EetleEgg(Level world, Vec3 pos) {
        super((EntityType)EEEntityTypes.EETLE_EGG.get(), world);
        this.f_19854_ = pos.m_7096_();
        this.f_19855_ = pos.m_7098_();
        this.f_19856_ = pos.m_7094_();
        this.m_6034_(this.f_19854_, this.f_19855_, this.f_19856_);
        this.fromBroodEetle = true;
    }

    public EetleEgg(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)EEEntityTypes.EETLE_EGG.get(), world);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        block6: {
            block4: {
                RandomSource random;
                BlockPos newPos;
                Level world;
                block7: {
                    BlockEntity tileentity;
                    block5: {
                        this.f_19854_ = this.m_20185_();
                        this.f_19855_ = this.m_20186_();
                        this.f_19856_ = this.m_20189_();
                        ++this.fallTime;
                        if (!this.m_20068_()) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                        }
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                        world = this.f_19853_;
                        if (world.f_46443_) break block4;
                        newPos = this.m_20183_();
                        if (this.f_19861_ || world.m_6425_(newPos).m_205070_(FluidTags.f_13131_)) break block5;
                        if (this.fallTime > 100 && (newPos.m_123342_() < 1 || newPos.m_123342_() > 256) || this.fallTime > 600) {
                            EetleEgg.burstOpenEgg(world, newPos, this.f_19796_, this.eggSize.ordinal(), this.fromBroodEetle);
                        }
                        break block6;
                    }
                    BlockState state = world.m_8055_(newPos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    this.m_146870_();
                    boolean flag3 = FallingBlock.m_53241_((BlockState)world.m_8055_(newPos.m_7495_()));
                    BlockState placingState = (BlockState)EETLE_EGGS_BLOCK.m_49966_().m_61124_((Property)EetleEggBlock.SIZE, (Comparable)Integer.valueOf(this.eggSize.ordinal()));
                    boolean flag4 = placingState.m_60710_((LevelReader)world, newPos) && !flag3;
                    random = this.f_19796_;
                    if (!state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, newPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) || !flag4) break block7;
                    if (placingState.m_61138_((Property)BlockStateProperties.f_61362_) && world.m_6425_(newPos).m_76152_() == Fluids.f_76193_) {
                        placingState = (BlockState)placingState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                    }
                    if (!world.m_7731_(newPos, placingState = EetleEgg.assignRandomDirection(world, placingState, random, newPos), 3)) break block6;
                    world.m_5594_(null, newPos, (SoundEvent)EESoundEvents.EETLE_EGG_PLACE.get(), SoundSource.BLOCKS, 1.0f - random.m_188501_() * 0.1f, 0.8f + random.m_188501_() * 0.2f);
                    if (((Boolean)placingState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || !((tileentity = world.m_7702_(newPos)) instanceof EetleEggTileEntity)) break block6;
                    EetleEggTileEntity eetleEggsTileEntity = (EetleEggTileEntity)tileentity;
                    eetleEggsTileEntity.fromBroodEetle = this.fromBroodEetle;
                    eetleEggsTileEntity.updateHatchDelay(world, random.m_188503_(6) + 5);
                    eetleEggsTileEntity.bypassSpawningGameRule();
                    break block6;
                }
                EetleEgg.burstOpenEgg(world, newPos, random, this.eggSize.ordinal(), this.fromBroodEetle);
                break block6;
            }
            for (EetleEggTileEntity.SackGrowth growth : this.sackGrowths) {
                growth.tick();
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7378_(CompoundTag compound) {
        this.fallTime = compound.m_128451_("FallTime");
        this.eggSize = EggSize.getById(Math.min(2, compound.m_128451_("EggSize")));
        this.fromBroodEetle = compound.m_128471_("FromBroodEetle");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("FallTime", this.fallTime);
        compound.m_128405_("EggSize", this.eggSize.ordinal());
        compound.m_128379_("FromBroodEetle", this.fromBroodEetle);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6097_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6051_() {
        return false;
    }

    public boolean m_6127_() {
        return true;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.eggSize.ordinal());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.eggSize = EggSize.getById(buffer.readInt());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EetleEggTileEntity.SackGrowth[] getSackGrowths() {
        return this.sackGrowths;
    }

    public void setEggSize(EggSize eggSize) {
        this.eggSize = eggSize;
    }

    public EggSize getEggSize() {
        return this.eggSize;
    }

    private static void burstOpenEgg(Level world, BlockPos pos, RandomSource random, int size, boolean fromBroodEetle) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (int i = 0; i <= size; ++i) {
            AbstractEetle eetle;
            AbstractEetle abstractEetle = eetle = random.m_188501_() < 0.6f ? (AbstractEetle)((EntityType)EEEntityTypes.CHARGER_EETLE.get()).m_20615_(world) : (AbstractEetle)((EntityType)EEEntityTypes.GLIDER_EETLE.get()).m_20615_(world);
            if (eetle == null) continue;
            eetle.markFromEgg();
            eetle.updateAge(-(random.m_188503_(41) + 120));
            eetle.m_19890_((float)x + random.m_188501_(), (float)y + 0.1f, (float)z + random.m_188501_(), random.m_188501_() * 360.0f, 0.0f);
            if (fromBroodEetle) {
                eetle.applyDespawnTimer();
            }
            world.m_7967_((Entity)eetle);
        }
        if (world instanceof ServerLevel) {
            world.m_5594_(null, pos, (SoundEvent)EESoundEvents.EETLE_EGG_BREAK.get(), SoundSource.BLOCKS, 1.0f - random.m_188501_() * 0.1f, 0.8f + random.m_188501_() * 0.2f);
            ((ServerLevel)world).m_8767_((ParticleOptions)new CorrockCrownParticleData((ParticleType<CorrockCrownParticleData>)((ParticleType)EEParticleTypes.END_CROWN.get()), true), (double)((float)x + 0.5f), (double)((float)y + 0.25f * ((float)size + 1.0f)), (double)((float)z + 0.5f), 5 + size, (double)0.3f, (double)0.1f, (double)0.3f, 0.1);
        }
    }

    private static BlockState assignRandomDirection(Level world, BlockState state, RandomSource random, BlockPos pos) {
        EetleEggBlock.shuffleDirections(DIRECTIONS, random);
        for (Direction direction : DIRECTIONS) {
            BlockState directionState = (BlockState)state.m_61124_((Property)EetleEggBlock.FACING, (Comparable)direction);
            if (!directionState.m_60710_((LevelReader)world, pos)) continue;
            return directionState;
        }
        return state;
    }

    public static enum EggSize {
        SMALL,
        MEDIUM,
        LARGE;

        private static final EggSize[] VALUES;

        public static EggSize random(RandomSource random, boolean biased) {
            return biased ? (random.m_188501_() < 0.6f ? SMALL : VALUES[random.m_188503_(VALUES.length)]) : VALUES[random.m_188503_(VALUES.length)];
        }

        public static EggSize getById(int id) {
            return VALUES[id];
        }

        static {
            VALUES = EggSize.values();
        }
    }
}

