/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.AbstractPurpoidTeleportGoal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PurpoidTeleportToFlowerGoal
extends AbstractPurpoidTeleportGoal {
    public PurpoidTeleportToFlowerGoal(Purpoid purpoid) {
        super(purpoid);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean m_8036_() {
        return !this.purpoid.hasRestCooldown() && super.m_8036_();
    }

    @Override
    protected void beginTeleportation(Purpoid purpoid, BlockPos pos) {
        super.beginTeleportation(purpoid, pos);
        BlockPos restingPos = pos.m_6625_(3);
        purpoid.setRestingPos(restingPos);
        purpoid.setRestingSide(Direction.UP);
        List nearbyPurpoids = purpoid.f_19853_.m_45976_(Purpoid.class, purpoid.m_20191_().m_82377_(12.0, 12.0, 12.0));
        for (Purpoid nearbyPurpoid : nearbyPurpoids) {
            Purpoid leaderOfNearbyPurpoid = nearbyPurpoid.getLeader();
            if (leaderOfNearbyPurpoid != purpoid && (leaderOfNearbyPurpoid != null || !(nearbyPurpoid.m_20280_((Entity)purpoid) <= 9.0)) || !nearbyPurpoid.m_6162_() || nearbyPurpoid.getTeleportController().isTeleporting() || nearbyPurpoid.isResting()) continue;
            nearbyPurpoid.forcedRelativeTeleportingPos = restingPos;
            nearbyPurpoid.m_21573_().m_26573_();
            nearbyPurpoid.m_20256_(Vec3.f_82478_);
            nearbyPurpoid.allowRest();
        }
    }

    @Override
    @Nullable
    protected BlockPos generateTeleportPos(Purpoid purpoid, RandomSource random) {
        BlockPos pos = purpoid.m_20183_();
        int originX = pos.m_123341_();
        int originY = pos.m_123342_();
        int originZ = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Level level = purpoid.f_19853_;
        ArrayList<BlockPos> teleportPositions = new ArrayList<BlockPos>();
        for (int x = originX - 16; x <= originX + 16; ++x) {
            for (int y = originY - 16; y <= originY + 16; ++y) {
                for (int z = originZ - 16; z <= originZ + 16; ++z) {
                    mutable.m_122178_(x, y, z);
                    if (level.m_8055_((BlockPos)mutable).m_60734_() != Blocks.f_50491_ || !level.m_8055_((BlockPos)mutable.m_142448_(mutable.m_123342_() + 1)).m_60795_() || !level.m_8055_((BlockPos)mutable.m_142448_(mutable.m_123342_() + 1)).m_60795_() || !level.m_8055_((BlockPos)mutable.m_142448_(mutable.m_123342_() + 1)).m_60795_() || !PurpoidTeleportToFlowerGoal.isRestingPosNotBlocked(purpoid, Vec3.m_82539_((Vec3i)mutable), mutable.m_6625_(3), Direction.UP)) continue;
                    teleportPositions.add(mutable.m_7949_());
                }
            }
        }
        return teleportPositions.isEmpty() ? null : (BlockPos)teleportPositions.get(random.m_188503_(teleportPositions.size()));
    }

    public static boolean isRestingPosNotBlocked(Purpoid purpoid, Vec3 pos, BlockPos restingPos, Direction side) {
        double purpoidCollisionBoxSideCoordinate;
        double sideCoordinate;
        Level level = purpoid.f_19853_;
        VoxelShape restingPosShape = level.m_8055_(restingPos).m_60812_((BlockGetter)level, restingPos).m_83216_((double)restingPos.m_123341_(), (double)restingPos.m_123342_(), (double)restingPos.m_123343_());
        AABB purpoidCollisionBox = purpoid.m_6972_(purpoid.m_20089_()).m_20384_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Direction.Axis axis = side.m_122434_();
        if (side.m_122421_() == Direction.AxisDirection.POSITIVE) {
            sideCoordinate = restingPosShape.m_83297_(axis);
            purpoidCollisionBoxSideCoordinate = purpoidCollisionBox.m_82340_(axis);
        } else {
            sideCoordinate = restingPosShape.m_83288_(axis);
            purpoidCollisionBoxSideCoordinate = purpoidCollisionBox.m_82374_(axis);
        }
        double expand = sideCoordinate - purpoidCollisionBoxSideCoordinate;
        AABB detectionBox = purpoidCollisionBox.m_82363_(expand * (double)side.m_122429_(), expand * (double)side.m_122430_(), expand * (double)side.m_122431_());
        for (VoxelShape voxelShape : level.m_186434_((Entity)purpoid, detectionBox)) {
            if (voxelShape.m_83281_()) continue;
            return false;
        }
        return level.m_5450_((Entity)purpoid, Shapes.m_83064_((AABB)purpoidCollisionBox.m_82367_(restingPosShape.m_83215_())));
    }

    @Override
    public boolean m_183429_() {
        return true;
    }
}

