/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.item;

import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class PuffBugBottleItem
extends Item {
    public PuffBugBottleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType entitytype = (EntityType)EEEntityTypes.PUFF_BUG.get();
        if (entitytype.m_20592_((ServerLevel)world, itemstack, context.m_43723_(), blockpos1, MobSpawnType.BUCKET, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            this.emptyBottle(context.m_43723_(), context.m_43724_());
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Booflo booflo;
        if (!target.f_19853_.f_46443_ && target instanceof Booflo && !(booflo = (Booflo)target).hasCaughtFruit() && !booflo.hasCaughtPuffBug() && booflo.isTamed()) {
            Level world = player.f_19853_;
            PuffBug puffbug = (PuffBug)((EntityType)EEEntityTypes.PUFF_BUG.get()).m_20615_(world);
            if (puffbug != null) {
                puffbug.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                EntityType.m_20620_((Level)world, (Player)player, (Entity)puffbug, (CompoundTag)stack.m_41784_());
                puffbug.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(puffbug.m_20183_()), MobSpawnType.BUCKET, null, stack.m_41784_());
                world.m_7967_((Entity)puffbug);
                booflo.catchPuffBug(puffbug);
                if (!player.m_150110_().f_35937_) {
                    this.emptyBottle(player, hand);
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        BlockHitResult raytraceresult = PuffBugBottleItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        BlockHitResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.m_82425_();
        if (!(worldIn.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos, blockraytraceresult.m_82434_(), itemstack)) {
            EntityType entitytype = (EntityType)EEEntityTypes.PUFF_BUG.get();
            if (entitytype.m_20592_((ServerLevel)worldIn, itemstack, playerIn, blockpos, MobSpawnType.SPAWN_EGG, false, false) == null) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            if (!playerIn.m_150110_().f_35937_) {
                this.emptyBottle(playerIn, handIn);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("CustomPotionEffects")) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.endergetic.activePotions").m_130940_(ChatFormatting.DARK_PURPLE));
            for (MobEffectInstance effects : PotionUtils.m_43573_((CompoundTag)nbt)) {
                ChatFormatting[] potionTextFormat = new ChatFormatting[]{ChatFormatting.ITALIC, this.getEffectTextColor(effects)};
                tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)effects.m_19576_(), (Object[])new Object[0]) + " " + ItemStackUtil.intToRomanNumerals((int)(effects.m_19564_() + 1)))).m_130944_(potionTextFormat));
            }
        }
    }

    private ChatFormatting getEffectTextColor(MobEffectInstance effect) {
        Map map = effect.m_19544_().m_19485_();
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeModifier entryValue = (AttributeModifier)entry.getValue();
                AttributeModifier modifier = new AttributeModifier(entryValue.m_22214_(), effect.m_19544_().m_7048_(effect.m_19564_(), entryValue), entryValue.m_22217_());
                if (!(modifier.m_22218_() <= 0.0)) continue;
                return ChatFormatting.RED;
            }
        }
        return effect.m_19544_().m_19486_() ? ChatFormatting.BLUE : ChatFormatting.RED;
    }

    private void emptyBottle(Player player, InteractionHand hand) {
        if (!player.m_7500_()) {
            EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            player.m_8061_(slot, new ItemStack((ItemLike)Items.f_42590_));
        }
    }

    public static class PuffBugBottleDispenseBehavior
    extends DefaultDispenseItemBehavior {
        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            if (!source.m_7727_().m_8055_(source.m_7961_().m_121945_(direction)).m_60812_((BlockGetter)source.m_7727_(), source.m_7961_().m_121945_(direction)).m_83281_()) {
                return super.m_7498_(source, stack);
            }
            EntityType entitytype = (EntityType)EEEntityTypes.PUFF_BUG.get();
            entitytype.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_121945_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
            stack = new ItemStack((ItemLike)Items.f_42590_);
            return stack;
        }
    }
}

