/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.teamabnormals.endergetic.common.levelgen.feature.EndergeticEndPodiumFeature;
import com.teamabnormals.endergetic.core.EEConfig;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EndergeticDragonFightManager
extends EndDragonFight {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<Entity> VALID_PLAYER = EntitySelector.f_20402_.and(EntitySelector.m_20410_((double)0.0, (double)128.0, (double)0.0, (double)192.0));

    public EndergeticDragonFightManager(ServerLevel worldIn, long seed, CompoundTag compound) {
        super(worldIn, seed, compound);
    }

    public void m_64095_() {
        this.f_64060_.m_8321_(!this.f_64068_);
        if (this.f_64067_++ >= 20) {
            this.updatePlayers();
            this.f_64067_ = 0;
        }
        if (!this.f_64060_.m_8324_().isEmpty()) {
            this.f_64061_.m_7726_().m_8387_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean flag = this.m_64106_();
            if (this.f_64071_ && flag) {
                this.scanForLegacyFight();
                this.f_64071_ = false;
            }
            if (this.f_64073_ != null) {
                if (this.f_64075_ == null && flag) {
                    this.f_64073_ = null;
                    this.m_64100_();
                }
                this.f_64073_.m_6363_(this.f_64061_, (EndDragonFight)this, this.f_64075_, this.f_64074_++, this.f_64072_);
            }
            if (!this.f_64068_) {
                if ((this.f_64070_ == null || ++this.f_64064_ >= 1200) && flag) {
                    this.m_64103_();
                    this.f_64064_ = 0;
                }
                if (++this.f_64066_ >= 100 && flag) {
                    this.m_64108_();
                    this.f_64066_ = 0;
                }
            }
        } else {
            this.f_64061_.m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
        if (EEConfig.ValuesHolder.shouldDebugDragonFightManager()) {
            LOGGER.debug("Found exit portal: " + this.findEndergeticExitPortal(true));
            LOGGER.debug(this.f_64072_ != null ? this.f_64072_.toString() : "null");
        }
    }

    private void scanForLegacyFight() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean flag = this.exitPortalExists();
        if (flag) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.f_64069_ = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.f_64069_ = false;
            if (!this.findEndergeticExitPortal(false)) {
                this.m_64093_(false);
            }
        }
        List list = this.f_64061_.m_8857_();
        if (list.isEmpty()) {
            this.f_64068_ = true;
        } else {
            EnderDragon enderdragonentity = (EnderDragon)list.get(0);
            this.f_64070_ = enderdragonentity.m_20148_();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)enderdragonentity);
            this.f_64068_ = false;
            if (!flag) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                enderdragonentity.m_146870_();
                this.f_64070_ = null;
            }
        }
        if (!this.f_64069_ && this.f_64068_) {
            this.f_64068_ = false;
        }
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayer serverplayerentity : this.f_64061_.m_8795_(VALID_PLAYER)) {
            this.f_64060_.m_6543_(serverplayerentity);
            set.add(serverplayerentity);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.f_64060_.m_8324_());
        set1.removeAll(set);
        for (ServerPlayer serverplayerentity1 : set1) {
            this.f_64060_.m_6539_(serverplayerentity1);
        }
    }

    private boolean exitPortalExists() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                LevelChunk chunk = this.f_64061_.m_6325_(i, j);
                for (BlockEntity tileentity : chunk.m_62954_().values()) {
                    if (!(tileentity instanceof TheEndPortalBlockEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void m_64100_() {
        if (this.f_64068_ && this.f_64073_ == null) {
            BlockPos portalPos = this.f_64072_;
            if (portalPos == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                if (!this.findEndergeticExitPortal(false)) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.m_64093_(true);
                } else {
                    LOGGER.debug("Found the exit portal & temporarily using it.");
                }
                portalPos = this.f_64072_;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos centerPos = portalPos.m_6630_(2);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List list = this.f_64061_.m_45976_(EndCrystal.class, new AABB(centerPos.m_5484_(direction, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.m_64091_(list1);
        }
    }

    @Nullable
    public BlockPattern.BlockPatternMatch m_64105_() {
        return null;
    }

    public boolean findEndergeticExitPortal(boolean debug) {
        int height;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                LevelChunk chunk = this.f_64061_.m_6325_(i, j);
                for (BlockEntity tileentity : chunk.m_62954_().values()) {
                    if (!(tileentity instanceof TheEndPortalBlockEntity)) continue;
                    BlockPos tilePos = tileentity.m_58899_();
                    for (Direction directions : Direction.Plane.HORIZONTAL) {
                        BlockPos possiblePortalPos;
                        if (this.f_64061_.m_8055_(tilePos.m_121945_(directions)).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN.get() || !this.isPortalAtPos(possiblePortalPos = tilePos.m_121945_(directions).m_7495_())) continue;
                        if (!debug) {
                            this.f_64072_ = possiblePortalPos;
                        }
                        return true;
                    }
                }
            }
        }
        for (int y = height = this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndergeticEndPodiumFeature.END_PODIUM_LOCATION.m_7494_()).m_123342_(); y >= 0; --y) {
            BlockPos pos = new BlockPos(EndergeticEndPodiumFeature.END_PODIUM_LOCATION.m_123341_(), y, EndergeticEndPodiumFeature.END_PODIUM_LOCATION.m_123343_());
            if (!this.isPortalAtPos(pos)) continue;
            if (!debug) {
                this.f_64072_ = pos;
            }
            return true;
        }
        return false;
    }

    private boolean isPortalAtPos(BlockPos pos) {
        BlockPos up = pos.m_7494_();
        ServerLevel world = this.f_64061_;
        boolean[] flag = new boolean[4];
        for (Direction directions : Direction.Plane.HORIZONTAL) {
            BlockPos side = up.m_5484_(directions, 3);
            if (world.m_8055_(side).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN_ACTIVATION_RUNE.get() && world.m_8055_(side).m_60734_() != EEBlocks.ACTIVATED_MYSTICAL_OBSIDIAN_ACTIVATION_RUNE.get() || world.m_8055_(side.m_121945_(directions.m_122427_())).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN_RUNE.get() || world.m_8055_(side.m_121945_(directions.m_122428_())).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN_RUNE.get() || world.m_8055_(up).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.m_8055_(up.m_122013_(2).m_122030_(2)).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.m_8055_(up.m_122013_(2).m_122025_(2)).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.m_8055_(up.m_122020_(2).m_122030_(2)).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.m_8055_(up.m_122020_(2).m_122025_(2)).m_60734_() != EEBlocks.MYSTICAL_OBSIDIAN.get()) continue;
            flag[directions.m_122411_() - 2] = true;
        }
        return flag[0] && flag[1] && flag[2] && flag[3];
    }

    public void m_64085_(EnderDragon dragon) {
        if (dragon.m_20148_().equals(this.f_64070_)) {
            this.f_64060_.m_142711_(0.0f);
            this.f_64060_.m_8321_(false);
            this.m_64093_(true);
            this.m_64109_();
            if (!this.f_64069_) {
                this.f_64061_.m_46597_(this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndergeticEndPodiumFeature.END_PODIUM_LOCATION), Blocks.f_50260_.m_49966_());
            }
            this.f_64069_ = true;
            this.f_64068_ = true;
        }
    }

    public void m_64093_(boolean active) {
        EndergeticEndPodiumFeature endpodium = new EndergeticEndPodiumFeature(active);
        if (this.f_64072_ == null) {
            this.f_64072_ = this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndergeticEndPodiumFeature.END_PODIUM_LOCATION).m_7495_();
            while (this.f_64061_.m_8055_(this.f_64072_).m_60734_() == Blocks.f_50752_ && this.f_64072_.m_123342_() > this.f_64061_.m_5736_()) {
                this.f_64072_ = this.f_64072_.m_7495_();
            }
        }
        endpodium.m_225028_((FeatureConfiguration)FeatureConfiguration.f_67737_, (WorldGenLevel)this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), this.f_64072_);
    }

    protected void m_64109_() {
        List gateways = (List)ObfuscationReflectionHelper.getPrivateValue(EndDragonFight.class, (Object)((Object)this), (String)"f_64062_");
        if (!gateways.isEmpty()) {
            int removed = (Integer)gateways.remove(gateways.size() - 1);
            BlockPos pos = new BlockPos(Mth.m_14107_((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)removed)))), 75, Mth.m_14107_((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)removed)))));
            ServerLevel level = this.f_64061_;
            level.m_46796_(3000, pos, 0);
            ConfiguredFeature endGateway = (ConfiguredFeature)level.m_5962_().m_175515_(Registry.f_122881_).m_7745_(new ResourceLocation("end_gateway_delayed"));
            if (endGateway != null) {
                endGateway.m_224953_((WorldGenLevel)this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), pos);
            }
        }
    }
}

