/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature.corrock;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.GenerationPiece;
import com.teamabnormals.endergetic.common.block.CorrockCrownBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownStandingBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownWallBlock;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public abstract class AbstractCorrockFeature<FC extends FeatureConfiguration>
extends Feature<FC> {
    protected static final Block CORROCK_BLOCK_BLOCK = (Block)EEBlocks.CORROCK_END_BLOCK.get();
    protected static final LazyLoadedValue<BlockState> CORROCK_STATE = new LazyLoadedValue(() -> ((Block)EEBlocks.CORROCK_END.get()).m_49966_());
    protected static final LazyLoadedValue<BlockState> CORROCK_BLOCK_STATE = new LazyLoadedValue(() -> ((Block)EEBlocks.CORROCK_END_BLOCK.get()).m_49966_());

    protected static BlockState getCorrockCrownWall(Direction facing) {
        return (BlockState)((CorrockCrownWallBlock)((Object)EEBlocks.CORROCK_CROWN_END_WALL.get())).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing);
    }

    protected static BlockState getCorrockCrownStanding(int rotation) {
        return (BlockState)((CorrockCrownBlock)((Object)EEBlocks.CORROCK_CROWN_END_STANDING.get())).m_49966_().m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(rotation));
    }

    public AbstractCorrockFeature(Codec<FC> configFactory) {
        super(configFactory);
    }

    protected static boolean isNotCloseToAnotherGrowth(List<ChorusPlantPart> growths, BlockPos pos) {
        for (ChorusPlantPart part : growths) {
            if (!(Mth.m_14116_((float)((float)part.pos.m_123331_((Vec3i)pos))) < 2.0f)) continue;
            return false;
        }
        return true;
    }

    protected static boolean tryToFillWithCorrockBlock(WorldGenLevel level, int x1, int y1, int z1, int x2, int y2, int z2, List<BlockPos> positions) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!level.m_46859_((BlockPos)mutable.m_122178_(xx, yy, zz))) {
                        return false;
                    }
                    positions.add(mutable.m_7949_());
                }
            }
        }
        return true;
    }

    protected static boolean tryToPlaceCorrockBlock(WorldGenLevel level, BlockPos pos, List<BlockPos> positions) {
        if (level.m_46859_(pos)) {
            positions.add(pos.m_7949_());
            return true;
        }
        return false;
    }

    protected static boolean tryToPlaceCorrockBlockWithCrown(WorldGenLevel level, RandomSource rand, BlockPos pos, List<BlockPos> positions, Direction direction, GenerationPiece crowns, @Nullable List<BlockPos> corners, float crownChance) {
        if (level.m_46859_(pos)) {
            BlockPos immutable = pos.m_7949_();
            positions.add(immutable);
            if (corners != null) {
                corners.add(immutable);
            }
            if (rand.m_188501_() < crownChance) {
                if (rand.m_188499_()) {
                    BlockPos up = pos.m_7494_();
                    if (level.m_46859_(up)) {
                        crowns.addBlockPiece(AbstractCorrockFeature.getCorrockCrownStanding(rand.m_188503_(16)), up);
                    }
                } else {
                    BlockPos offset = pos.m_121945_(direction);
                    if (level.m_46859_(offset)) {
                        crowns.addBlockPiece(AbstractCorrockFeature.getCorrockCrownWall(direction), offset);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean tryToPlaceCrownedCorrockSquare(WorldGenLevel level, RandomSource rand, int y, int x1, int z1, int x2, int z2, List<BlockPos> positions, Direction direction, GenerationPiece crowns, float crownChance) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                if (AbstractCorrockFeature.tryToPlaceCorrockBlockWithCrown(level, rand, (BlockPos)mutable.m_122178_(x, y, z), positions, direction, crowns, null, crownChance)) continue;
                return false;
            }
        }
        return true;
    }

    protected static class ChorusPlantPart {
        public final BlockPos pos;

        public ChorusPlantPart(BlockPos pos) {
            this.pos = pos;
        }

        public void placeGrowth(LevelAccessor world, RandomSource rand) {
            world.m_7731_(this.pos, (BlockState)CORROCK_BLOCK_STATE.m_13971_(), 2);
            ChorusFlowerBlock.m_220962_((LevelAccessor)world, (BlockPos)this.pos.m_7494_(), (RandomSource)rand, (int)8);
        }
    }
}

