/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature.corrock;

import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.common.block.CorrockCrownBlock;
import com.teamabnormals.endergetic.common.block.CorrockPlantBlock;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.AbstractCorrockFeature;
import com.teamabnormals.endergetic.common.levelgen.structure.structures.EetleNestPieces;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import org.apache.commons.lang3.ArrayUtils;

public class CorrockShelfFeature
extends AbstractCorrockFeature<ProbabilityFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = CorrockShelfFeature.getDirections(false);
    private static final Direction[] DIRECTIONS_REVERSED = CorrockShelfFeature.getDirections(true);
    private static final BlockState SPECKLED_CORROCK = ((Block)EEBlocks.SPECKLED_END_CORROCK.get()).m_49966_();

    public CorrockShelfFeature(Codec<ProbabilityFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<ProbabilityFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        if (EetleNestPieces.isNotInsideGeneratingBounds(pos) && level.m_46859_(pos) && level.m_8055_(pos.m_7494_()).m_60734_() != CORROCK_BLOCK_BLOCK && CorrockShelfFeature.isTouchingWall(level, pos)) {
            RandomSource rand = context.m_225041_();
            int size = rand.m_188499_() ? 3 : 4;
            CorrockShelfFeature.generateShelf(level, rand, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), size, 10, rand.m_188503_(2) + 2, rand.m_188503_(2) + 2, ((ProbabilityFeatureConfiguration)context.m_159778_()).f_67859_);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            BlockState corrockState = (BlockState)CORROCK_STATE.m_13971_();
            for (int i = 0; i < 16; ++i) {
                if (!(rand.m_188501_() < 0.4f) || !level.m_46859_((BlockPos)mutable.m_122154_((Vec3i)pos, rand.m_188503_(size) - rand.m_188503_(size), 1, rand.m_188503_(size) - rand.m_188503_(size))) || level.m_8055_(mutable.m_7495_()).m_60734_() != CORROCK_BLOCK_BLOCK) continue;
                level.m_7731_((BlockPos)mutable, corrockState, 2);
            }
            return true;
        }
        return false;
    }

    private static Direction[] getDirections(boolean reversed) {
        Object[] directions = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new);
        if (reversed) {
            ArrayUtils.reverse((Object[])directions);
        }
        return directions;
    }

    private static boolean isTouchingWall(WorldGenLevel world, BlockPos origin) {
        for (Direction direction : DIRECTIONS) {
            if (!CorrockShelfFeature.searchForWall(world, origin.m_122032_(), direction) || !CorrockShelfFeature.searchForWall(world, origin.m_122032_().m_122173_(direction.m_122427_()), direction) || !CorrockShelfFeature.searchForWall(world, origin.m_122032_().m_122173_(direction.m_122428_()), direction)) continue;
            return true;
        }
        return false;
    }

    private static boolean searchForWall(WorldGenLevel world, BlockPos.MutableBlockPos mutable, Direction facing) {
        for (int i = 0; i < 2; ++i) {
            Block block = world.m_8055_((BlockPos)mutable.m_122173_(facing)).m_60734_();
            if (block != Blocks.f_50259_ && block != CORROCK_BLOCK_BLOCK && block != EEBlocks.EUMUS.get()) continue;
            return true;
        }
        return false;
    }

    private static void generateShelf(WorldGenLevel level, RandomSource rand, int originX, int originY, int originZ, int size, int edgeBias, float underXDistance, float underZDistance, float crownChance) {
        int min = -(size / edgeBias + size);
        int max = size / edgeBias + size;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
        ArrayList<BlockPos> wallCrowns = new ArrayList<BlockPos>();
        ArrayList<BlockPos> speckledPatchPositions = new ArrayList<BlockPos>();
        for (int x = min; x <= max; ++x) {
            for (int z = min; z <= max; ++z) {
                double radiusMinusOne;
                BlockPos down;
                double radius;
                int distance;
                mutable.m_122178_(originX + x, originY, originZ + z);
                if (!CorrockShelfFeature.canReplace(level, (BlockPos)mutable) || !((double)(distance = x * x + z * z) < (radius = (Math.cos(4.0 * Math.atan2(z, x)) / (double)edgeBias + 1.0) * (double)size) * radius)) continue;
                level.m_7731_((BlockPos)mutable, corrockBlockState, 2);
                if (rand.m_188501_() < 0.25f) {
                    speckledPatchPositions.add(mutable.m_7949_());
                }
                if ((double)(x * x) < (radius - (double)underXDistance) * (radius - (double)underXDistance) && (double)(z * z) < (radius - (double)underZDistance) * (radius - (double)underZDistance) && CorrockShelfFeature.canReplace(level, down = mutable.m_7495_())) {
                    level.m_7731_(down, corrockBlockState, 2);
                }
                if (!(rand.m_188501_() < crownChance) || !((double)distance > (radiusMinusOne = radius - 1.0) * radiusMinusOne)) continue;
                if (rand.m_188499_()) {
                    BlockPos up = mutable.m_7494_();
                    if (!CorrockShelfFeature.canReplace(level, up)) continue;
                    level.m_7731_(up, CorrockShelfFeature.getCorrockCrownStanding(rand.m_188503_(16)), 2);
                    continue;
                }
                wallCrowns.add(mutable.m_7949_());
            }
        }
        block2: for (BlockPos pos : wallCrowns) {
            Direction[] directions;
            int crownsPlaced = 0;
            for (Direction direction : directions = rand.m_188499_() ? DIRECTIONS : DIRECTIONS_REVERSED) {
                BlockPos offset = pos.m_121945_(direction);
                if (!CorrockShelfFeature.canReplace(level, offset)) continue;
                level.m_7731_(offset, CorrockShelfFeature.getCorrockCrownWall(direction), 2);
                if (rand.m_188501_() > crownChance || crownsPlaced++ == 1) continue block2;
            }
        }
        for (BlockPos pos : speckledPatchPositions) {
            int radius = 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (rand.m_188501_() <= 0.6f) {
                            if (rand.m_188499_()) {
                                if (rand.m_188499_()) {
                                    x += rand.m_188503_(3) - rand.m_188503_(3);
                                } else {
                                    z += rand.m_188503_(3) - rand.m_188503_(3);
                                }
                            } else {
                                y += rand.m_188503_(3) - rand.m_188503_(3);
                            }
                        }
                        if (level.m_8055_((BlockPos)mutable.m_122154_((Vec3i)pos, x, y, z)).m_60734_() != Blocks.f_50259_ || !(rand.m_188501_() < 0.6f)) continue;
                        level.m_7731_((BlockPos)mutable, SPECKLED_CORROCK, 2);
                    }
                }
            }
        }
    }

    private static boolean canReplace(WorldGenLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60767_().m_76336_() || state.m_60734_() instanceof CorrockPlantBlock || state.m_60734_() instanceof CorrockCrownBlock;
    }
}

