/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature.corrock.tower;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.GenerationPiece;
import com.teamabnormals.endergetic.api.util.GenerationUtils;
import com.teamabnormals.endergetic.common.levelgen.configs.CorrockTowerConfig;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.AbstractCorrockFeature;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public final class LargeCorrockTowerFeature
extends AbstractCorrockFeature<CorrockTowerConfig> {
    public LargeCorrockTowerFeature(Codec<CorrockTowerConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<CorrockTowerConfig> context) {
        BlockPos pos;
        WorldGenLevel level = context.m_159774_();
        if (level.m_46859_(pos = context.m_159777_()) && level.m_8055_(pos.m_7495_()).m_60734_() == EEBlocks.CORROCK_END_BLOCK.get() && level.m_8055_(pos.m_6625_(2)).m_60815_()) {
            BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
            ArrayList<BlockPos> corrockPositions = new ArrayList<BlockPos>();
            if (LargeCorrockTowerFeature.tryToMakeGroundSuitable(level, corrockPositions, pos)) {
                Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> top;
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                int startX = pos.m_123341_();
                int startY = pos.m_123342_();
                int startZ = pos.m_123343_();
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        for (int z = 0; z < 4; ++z) {
                            mutable.m_122178_(startX + x, startY + y, startZ + z);
                            if (!level.m_46859_((BlockPos)mutable)) {
                                return false;
                            }
                            corrockPositions.add(mutable.m_7949_());
                        }
                    }
                }
                RandomSource rand = context.m_225041_();
                LargeCorrockTowerFeature.tryToMakeSide(level, rand, corrockPositions, pos.m_122012_().m_122030_(rand.m_188503_(2) + 1), Direction.NORTH);
                LargeCorrockTowerFeature.tryToMakeSide(level, rand, corrockPositions, pos.m_122024_().m_122020_(rand.m_188503_(2) + 1), Direction.WEST);
                LargeCorrockTowerFeature.tryToMakeSide(level, rand, corrockPositions, pos.m_122020_(4).m_122030_(rand.m_188503_(2) + 1), Direction.SOUTH);
                LargeCorrockTowerFeature.tryToMakeSide(level, rand, corrockPositions, pos.m_122030_(4).m_122020_(rand.m_188503_(2) + 1), Direction.EAST);
                CorrockTowerConfig config = (CorrockTowerConfig)context.m_159778_();
                int height = rand.m_188503_(config.getMaxHeight() - config.getMinHeight() + 1) + config.getMinHeight();
                float crownChance = config.getCrownChance();
                if (LargeCorrockTowerFeature.tryToMakeMiddle(level, rand, corrockPositions, pos, height) && (top = LargeCorrockTowerFeature.tryToMakeLargeTop(level, rand, corrockPositions, pos.m_6630_(3 + height), crownChance, config.getChorusChance())) != null) {
                    corrockPositions.forEach(corrockPos -> level.m_7731_(corrockPos, corrockBlockState, 2));
                    ((GenerationPiece)top.getFirst()).place((LevelAccessor)level);
                    ((List)top.getSecond()).forEach(chorusPlantPart -> chorusPlantPart.placeGrowth((LevelAccessor)level, rand));
                    BlockPos topMiddle = pos.m_6630_(4 + height);
                    BlockState corrockPlantState = (BlockState)CORROCK_STATE.m_13971_();
                    for (int i = 0; i < 16; ++i) {
                        if (!(rand.m_188501_() < 0.6f) || !level.m_46859_((BlockPos)mutable.m_122154_((Vec3i)topMiddle, rand.m_188503_(7) - rand.m_188503_(7), rand.m_188503_(2) - rand.m_188503_(2), rand.m_188503_(7) - rand.m_188503_(7))) || level.m_8055_(mutable.m_7495_()).m_60734_() != CORROCK_BLOCK_BLOCK) continue;
                        level.m_7731_((BlockPos)mutable, corrockPlantState, 2);
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean tryToMakeGroundSuitable(WorldGenLevel level, List<BlockPos> positions, BlockPos origin) {
        int startZ;
        int startY;
        BlockPos down = origin.m_6625_(2);
        int startX = down.m_123341_();
        boolean isSolidBelow = GenerationUtils.isAreaCompletelySolid((LevelAccessor)level, startX - 2, startY = down.m_123342_(), (startZ = down.m_123343_()) - 2, startX + 2, startY, startZ + 2);
        if (isSolidBelow) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 4; ++x) {
                    for (int z = 0; z < 4; ++z) {
                        mutable.m_122178_(startX + x, startY + y, startZ + z);
                        BlockPos immutable = mutable.m_7949_();
                        if (!level.m_8055_(immutable).m_60767_().m_76336_()) continue;
                        positions.add(immutable);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static void tryToMakeSide(WorldGenLevel level, RandomSource rand, List<BlockPos> positions, BlockPos origin, Direction facing) {
        ArrayList<BlockPos> toAdd = new ArrayList<BlockPos>();
        if (level.m_46859_(origin)) {
            LargeCorrockTowerFeature.tryToMakeSidePillar(level, rand, 0, rand.m_188503_(2) + 2, origin, toAdd, facing);
        }
        positions.addAll(toAdd);
    }

    private static void tryToMakeSidePillar(WorldGenLevel level, RandomSource rand, int index, int height, BlockPos origin, List<BlockPos> positions, Direction facing) {
        BlockPos.MutableBlockPos mutable = origin.m_122032_();
        int startX = origin.m_123341_();
        int startY = origin.m_123342_();
        int startZ = origin.m_123343_();
        for (int y = 0; y < height; ++y) {
            BlockPos offset;
            mutable.m_122178_(startX, startY + y, startZ);
            if (!level.m_46859_((BlockPos)mutable)) {
                positions.clear();
                return;
            }
            positions.add(mutable.m_7949_());
            if (!LargeCorrockTowerFeature.tryToBuildPillarDownwards(level, positions, origin)) {
                positions.clear();
                return;
            }
            if (index >= 1 || !level.m_46859_(offset = origin.m_121945_(rand.m_188499_() ? facing.m_122427_() : facing.m_122428_()))) continue;
            LargeCorrockTowerFeature.tryToMakeSidePillar(level, rand, index + 1, height - 1, offset, positions, facing);
        }
    }

    private static boolean tryToBuildPillarDownwards(WorldGenLevel world, List<BlockPos> positions, BlockPos origin) {
        boolean foundGround = false;
        BlockPos.MutableBlockPos mutable = origin.m_122032_();
        for (int y = 0; y < 4; ++y) {
            mutable.m_122184_(0, -1, 0);
            if (!world.m_8055_((BlockPos)mutable).m_60767_().m_76336_()) {
                foundGround = true;
                continue;
            }
            positions.add(mutable.m_7949_());
        }
        return foundGround;
    }

    private static boolean tryToMakeMiddle(WorldGenLevel world, RandomSource rand, List<BlockPos> positions, BlockPos origin, int height) {
        int startX = origin.m_123341_() + 1;
        int startY = origin.m_123342_() + 3;
        int startZ = origin.m_123343_() + 1;
        BlockPos.MutableBlockPos innerMutable = origin.m_122032_();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    innerMutable.m_122178_(startX + x, startY + y, startZ + z);
                    if (!world.m_46859_((BlockPos)innerMutable)) {
                        return false;
                    }
                    positions.add(innerMutable.m_7949_());
                }
            }
        }
        BlockPos.MutableBlockPos roundTripMutable = origin.m_122032_();
        Direction currentDirection = Direction.NORTH;
        for (int i = 0; i < 12; ++i) {
            if (i % 3 != 0) {
                roundTripMutable.m_122173_(currentDirection);
                for (int y = 0; y < height; ++y) {
                    roundTripMutable.m_142448_(startY + y);
                    if (!world.m_46859_((BlockPos)roundTripMutable)) {
                        return false;
                    }
                    positions.add(roundTripMutable.m_7949_());
                }
                continue;
            }
            if (i != 0) {
                roundTripMutable.m_122173_(currentDirection);
            }
            currentDirection = currentDirection.m_122427_();
            if (!(rand.m_188501_() < 0.8f)) continue;
            int cornerTop = startY + height;
            roundTripMutable.m_142448_(cornerTop - 1);
            if (!world.m_46859_((BlockPos)roundTripMutable)) continue;
            positions.add(roundTripMutable.m_7949_());
            if (height <= 2 || !(rand.m_188501_() < 0.25f)) continue;
            roundTripMutable.m_142448_(cornerTop - 2);
            if (!world.m_46859_((BlockPos)roundTripMutable)) continue;
            positions.add(roundTripMutable.m_7949_());
        }
        return true;
    }

    @Nullable
    private static Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> tryToMakeLargeTop(WorldGenLevel world, RandomSource rand, List<BlockPos> positions, BlockPos origin, float crownChance, float chorusChance) {
        BlockPos.MutableBlockPos mutable;
        int startZ;
        int startY;
        int startX = origin.m_123341_();
        if (LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX, startY = origin.m_123342_(), startZ = origin.m_123343_(), startX + 3, startY, startZ + 3, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX + 1, startY, startZ - 1, startX + 2, startY, startZ - 1, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX - 1, startY, startZ + 1, startX - 1, startY, startZ + 2, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX + 4, startY, startZ + 1, startX + 4, startY, startZ + 2, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX + 1, startY, startZ + 4, startX + 2, startY, startZ + 4, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX - 1, ++startY, startZ, startX + 4, startY, startZ + 3, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX, startY, startZ - 1, startX + 3, startY, startZ - 1, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX, startY, startZ + 4, startX + 3, startY, startZ + 4, positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)(mutable = new BlockPos.MutableBlockPos()).m_122178_(startX + rand.m_188503_(2) + 1, startY, startZ - 2), positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX - 2, startY, startZ + rand.m_188503_(2) + 1), positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX + rand.m_188503_(2) + 1, startY, startZ + 5), positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX + 5, startY, startZ + rand.m_188503_(2) + 1), positions)) {
            GenerationPiece crowns = new GenerationPiece((iWorld, blockPart) -> true);
            ArrayList<BlockPos> corners = new ArrayList<BlockPos>();
            if (LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.m_122178_(startX - 1, ++startY, startZ - 1), positions, rand.m_188499_() ? Direction.WEST : Direction.NORTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.m_122178_(startX + 4, startY, startZ - 1), positions, rand.m_188499_() ? Direction.EAST : Direction.NORTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.m_122178_(startX + 4, startY, startZ + 4), positions, rand.m_188499_() ? Direction.EAST : Direction.SOUTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.m_122178_(startX - 1, startY, startZ + 4), positions, rand.m_188499_() ? Direction.WEST : Direction.SOUTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX, startZ - 2, startX + 3, startZ - 2, positions, Direction.NORTH, crowns, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX - 2, startZ, startX - 2, startZ + 3, positions, Direction.WEST, crowns, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX + 5, startZ, startX + 5, startZ + 3, positions, Direction.EAST, crowns, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX, startZ + 5, startX + 3, startZ + 5, positions, Direction.SOUTH, crowns, crownChance)) {
                if (rand.m_188499_()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX - 1, startY, startZ), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX, startY, startZ - 1), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                }
                if (rand.m_188499_()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX + 4, startY, startZ), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX + 3, startY, startZ - 1), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                }
                if (rand.m_188499_()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX + 4, startY, startZ + 3), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX + 3, startY, startZ + 4), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                }
                if (rand.m_188499_()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX, startY, startZ + 4), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.m_122178_(startX - 1, startY, startZ + 3), positions)) {
                        corners.add(mutable.m_7949_());
                    }
                }
                ArrayList<AbstractCorrockFeature.ChorusPlantPart> chorusPlantParts = new ArrayList<AbstractCorrockFeature.ChorusPlantPart>();
                int y = startY - 1;
                int cornerX = startX - 1;
                int cornerZ = startZ - 1;
                for (int x = 0; x < 5; ++x) {
                    for (int z = 0; z < 5; ++z) {
                        BlockPos up;
                        mutable.m_122178_(cornerX + x, y, cornerZ + z);
                        if (!(rand.m_188501_() < chorusChance) || !world.m_46859_(up = mutable.m_7494_()) || corners.contains(up) || !LargeCorrockTowerFeature.isNotCloseToAnotherGrowth(chorusPlantParts, (BlockPos)mutable)) continue;
                        chorusPlantParts.add(new AbstractCorrockFeature.ChorusPlantPart(mutable.m_7949_()));
                    }
                }
                return Pair.of((Object)crowns, chorusPlantParts);
            }
        }
        return null;
    }
}

