/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.network.entity;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import com.teamabnormals.endergetic.core.interfaces.BalloonHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public final class S2CUpdateBalloonsMessage {
    private int entityId;
    private int[] balloonIds;

    private S2CUpdateBalloonsMessage(int entityId, int[] balloonIds) {
        this.entityId = entityId;
        this.balloonIds = balloonIds;
    }

    public S2CUpdateBalloonsMessage(Entity entity) {
        this.entityId = entity.m_19879_();
        List<BolloomBalloon> balloons = ((BalloonHolder)entity).getBalloons();
        this.balloonIds = new int[balloons.size()];
        for (int i = 0; i < balloons.size(); ++i) {
            this.balloonIds[i] = balloons.get(i).m_19879_();
        }
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130089_(this.balloonIds);
    }

    public static S2CUpdateBalloonsMessage deserialize(FriendlyByteBuf buf) {
        return new S2CUpdateBalloonsMessage(buf.m_130242_(), buf.m_130100_());
    }

    public static void handle(S2CUpdateBalloonsMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Level world = ClientInfo.getClientPlayerLevel();
                Entity entity = world.m_6815_(message.entityId);
                if (entity == null) {
                    EndergeticExpansion.LOGGER.warn("Received balloons for unknown entity!");
                } else {
                    ((BalloonHolder)entity).detachBalloons();
                    for (int id : message.balloonIds) {
                        Entity balloon = world.m_6815_(id);
                        if (!(balloon instanceof BolloomBalloon)) continue;
                        ((BolloomBalloon)balloon).attachToEntity(entity);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

