/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.data.server;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.endergetic.common.levelgen.biome.modifiers.SmallEndIslandsAmbienceBiomeModifier;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class EEBiomeModifierProvider {
    public static JsonCodecProvider<BiomeModifier> create(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) {
        RegistryAccess.Writable access = RegistryAccess.m_206197_();
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        Registry placedFeatures = access.m_175515_(Registry.f_194567_);
        HolderSet.Direct endHighlandsOrMidlands = HolderSet.m_205800_(List.of(biomeRegistry.m_206081_(Biomes.f_48164_), biomeRegistry.m_206081_(Biomes.f_48163_)));
        HashMap<ResourceLocation, BiomeModifier> modifiers = new HashMap<ResourceLocation, BiomeModifier>();
        EEBiomeModifierProvider.addModifier(modifiers, "small_end_islands_ambience", SmallEndIslandsAmbienceBiomeModifier.INSTANCE);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)dataGenerator, (ExistingFileHelper)existingFileHelper, (String)"endergetic", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)access), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, modifiers);
    }

    private static void addModifier(HashMap<ResourceLocation, BiomeModifier> modifiers, String name, BiomeModifier modifier) {
        modifiers.put(new ResourceLocation("endergetic", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> of(Registry<PlacedFeature> placedFeatures, RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> placedFeatures.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

